/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop;

import io.datakernel.eventloop.FatalErrorHandler;
import java.io.IOError;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipError;
import org.jetbrains.annotations.NotNull;

public final class FatalErrorHandlers {
    public static FatalErrorHandler ignoreAllErrors() {
        return (e, context) -> {};
    }

    public static FatalErrorHandler exitOnAnyError() {
        return (e, context) -> FatalErrorHandlers.shutdownForcibly();
    }

    public static FatalErrorHandler exitOnMatchedError(List<Class<?>> whiteList, List<Class<?>> blackList) {
        return (e, context) -> {
            if (FatalErrorHandlers.matchesAny(e.getClass(), whiteList) && !FatalErrorHandlers.matchesAny(e.getClass(), blackList)) {
                FatalErrorHandlers.shutdownForcibly();
            }
        };
    }

    public static FatalErrorHandler exitOnJvmError() {
        return FatalErrorHandlers.exitOnMatchedError(Collections.singletonList(Error.class), Arrays.asList(AssertionError.class, StackOverflowError.class, IOError.class, ZipError.class));
    }

    public static FatalErrorHandler rethrowOnAnyError() {
        return (e, context) -> FatalErrorHandlers.propagate(e);
    }

    public static FatalErrorHandler rethrowOnMatchedError(List<Class<?>> whiteList, List<Class<?>> blackList) {
        return (e, context) -> {
            if (FatalErrorHandlers.matchesAny(e.getClass(), whiteList) && !FatalErrorHandlers.matchesAny(e.getClass(), blackList)) {
                FatalErrorHandlers.propagate(e);
            }
        };
    }

    public static void propagate(@NotNull Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    private static void shutdownForcibly() {
        Runtime.getRuntime().halt(1);
    }

    private static boolean matchesAny(Class<?> c, List<Class<?>> list) {
        return list.stream().anyMatch(cl -> cl.isAssignableFrom(c));
    }
}

