/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop;

import io.datakernel.common.Stopwatch;
import io.datakernel.common.inspector.BaseInspector;
import io.datakernel.common.inspector.ForwardingInspector;
import io.datakernel.eventloop.Eventloop;
import io.datakernel.eventloop.EventloopInspector;
import io.datakernel.eventloop.jmx.EventStats;
import io.datakernel.eventloop.jmx.ExceptionStats;
import io.datakernel.eventloop.jmx.JmxStats;
import io.datakernel.eventloop.jmx.JmxStatsWithReset;
import io.datakernel.eventloop.jmx.ValueStats;
import io.datakernel.jmx.api.JmxAttribute;
import io.datakernel.jmx.api.JmxReducers;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventloopStats
extends ForwardingInspector<EventloopInspector>
implements EventloopInspector {
    @Nullable
    private final EventloopInspector next;
    private final EventStats loops;
    private final ValueStats selectorSelectTimeout;
    private final ValueStats selectorSelectTime;
    private final ValueStats businessLogicTime;
    private final Tasks tasks;
    private final Keys keys;
    private final ExceptionStats fatalErrors;
    private final Map<Class<? extends Throwable>, ExceptionStats> fatalErrorsMap;
    private final EventStats idleLoops;
    private final EventStats idleLoopsWaitingExternalTask;
    private final EventStats selectOverdues;

    private EventloopStats(@Nullable EventloopInspector next) {
        super((BaseInspector)next);
        this.next = next;
        this.loops = EventStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW);
        this.selectorSelectTimeout = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(new int[]{-256, -128, -64, -32, -16, -8, -4, -2, -1, 0, 1, 2, 4, 8, 16, 32}).withUnit("milliseconds");
        this.selectorSelectTime = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO).withUnit("milliseconds");
        this.businessLogicTime = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO).withUnit("milliseconds");
        this.tasks = new Tasks();
        this.keys = new Keys();
        this.fatalErrors = ExceptionStats.create();
        this.fatalErrorsMap = new HashMap<Class<? extends Throwable>, ExceptionStats>();
        this.idleLoops = EventStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW);
        this.idleLoopsWaitingExternalTask = EventStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW);
        this.selectOverdues = EventStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW);
    }

    public static EventloopStats create() {
        return new EventloopStats(null);
    }

    public static EventloopStats create(EventloopInspector next) {
        return new EventloopStats(next);
    }

    @Override
    public void onUpdateBusinessLogicTime(boolean taskOrKeyPresent, boolean externalTaskPresent, long businessLogicTime) {
        this.loops.recordEvent();
        if (taskOrKeyPresent) {
            this.businessLogicTime.recordValue((int)businessLogicTime);
        } else if (!externalTaskPresent) {
            this.idleLoops.recordEvent();
        } else {
            this.idleLoopsWaitingExternalTask.recordEvent();
        }
        if (this.next != null) {
            this.next.onUpdateBusinessLogicTime(taskOrKeyPresent, externalTaskPresent, businessLogicTime);
        }
    }

    @Override
    public void onUpdateSelectorSelectTime(long selectorSelectTime) {
        this.selectorSelectTime.recordValue((int)selectorSelectTime);
        if (this.next != null) {
            this.next.onUpdateSelectorSelectTime(selectorSelectTime);
        }
    }

    @Override
    public void onUpdateSelectorSelectTimeout(long selectorSelectTimeout) {
        this.selectorSelectTimeout.recordValue((int)selectorSelectTimeout);
        if (selectorSelectTimeout < 0L) {
            this.selectOverdues.recordEvent();
        }
        if (this.next != null) {
            this.next.onUpdateSelectorSelectTimeout(selectorSelectTimeout);
        }
    }

    @Override
    public void onUpdateSelectedKeyDuration(@NotNull Stopwatch sw) {
        this.keys.oneKeyTime.recordValue((int)sw.elapsed(TimeUnit.MICROSECONDS));
        if (this.next != null) {
            this.next.onUpdateSelectedKeyDuration(sw);
        }
    }

    @Override
    public void onUpdateSelectedKeysStats(int lastSelectedKeys, int invalidKeys, int acceptKeys, int connectKeys, int readKeys, int writeKeys, long loopTime) {
        this.keys.all.recordEvents(lastSelectedKeys);
        this.keys.invalid.recordEvents(invalidKeys);
        this.keys.acceptPerLoop.recordValue(acceptKeys);
        this.keys.connectPerLoop.recordValue(connectKeys);
        this.keys.readPerLoop.recordValue(readKeys);
        this.keys.writePerLoop.recordValue(writeKeys);
        if (lastSelectedKeys != 0) {
            this.keys.loopTime.recordValue((int)loopTime);
        }
        if (this.next != null) {
            this.next.onUpdateSelectedKeysStats(lastSelectedKeys, invalidKeys, acceptKeys, connectKeys, readKeys, writeKeys, loopTime);
        }
    }

    private void updateTaskDuration(ValueStats counter, DurationRunnable longestCounter, Runnable runnable, @Nullable Stopwatch sw) {
        if (sw != null) {
            int elapsed = (int)sw.elapsed(TimeUnit.MICROSECONDS);
            counter.recordValue(elapsed);
            if ((long)elapsed > longestCounter.getDuration()) {
                longestCounter.update(runnable, elapsed);
            }
        }
    }

    @Override
    public void onUpdateLocalTaskDuration(@NotNull Runnable runnable, @Nullable Stopwatch sw) {
        this.updateTaskDuration(this.tasks.local.oneTaskTime, this.tasks.local.longestTask, runnable, sw);
        if (this.next != null) {
            this.next.onUpdateLocalTaskDuration(runnable, sw);
        }
    }

    @Override
    public void onUpdateLocalTasksStats(int newLocalTasks, long loopTime) {
        if (newLocalTasks != 0) {
            this.tasks.local.loopTime.recordValue((int)loopTime);
        }
        this.tasks.local.tasksPerLoop.recordValue(newLocalTasks);
        if (this.next != null) {
            this.next.onUpdateLocalTasksStats(newLocalTasks, loopTime);
        }
    }

    @Override
    public void onUpdateConcurrentTaskDuration(@NotNull Runnable runnable, @Nullable Stopwatch sw) {
        this.updateTaskDuration(this.tasks.concurrent.oneTaskTime, this.tasks.concurrent.longestTask, runnable, sw);
        if (this.next != null) {
            this.next.onUpdateConcurrentTaskDuration(runnable, sw);
        }
    }

    @Override
    public void onUpdateConcurrentTasksStats(int newConcurrentTasks, long loopTime) {
        if (newConcurrentTasks != 0) {
            this.tasks.concurrent.loopTime.recordValue((int)loopTime);
        }
        this.tasks.concurrent.tasksPerLoop.recordValue(newConcurrentTasks);
        if (this.next != null) {
            this.next.onUpdateConcurrentTasksStats(newConcurrentTasks, loopTime);
        }
    }

    @Override
    public void onUpdateScheduledTaskDuration(@NotNull Runnable runnable, @Nullable Stopwatch sw, boolean background) {
        if (background) {
            this.updateTaskDuration(this.tasks.background.getOneTaskTime(), this.tasks.background.getLongestTask(), runnable, sw);
        } else {
            this.updateTaskDuration(this.tasks.scheduled.getOneTaskTime(), this.tasks.scheduled.getLongestTask(), runnable, sw);
        }
        if (this.next != null) {
            this.next.onUpdateScheduledTaskDuration(runnable, sw, background);
        }
    }

    @Override
    public void onUpdateScheduledTasksStats(int newScheduledTasks, long loopTime, boolean background) {
        if (background) {
            if (newScheduledTasks != 0) {
                this.tasks.background.getLoopTime().recordValue((int)loopTime);
            }
            this.tasks.background.getTasksPerLoop().recordValue(newScheduledTasks);
        } else {
            if (newScheduledTasks != 0) {
                this.tasks.scheduled.getLoopTime().recordValue((int)loopTime);
            }
            this.tasks.scheduled.getTasksPerLoop().recordValue(newScheduledTasks);
        }
        if (this.next != null) {
            this.next.onUpdateScheduledTasksStats(newScheduledTasks, loopTime, background);
        }
    }

    @Override
    public void onFatalError(@NotNull Throwable e, Object causedObject) {
        this.fatalErrors.recordException(e, causedObject);
        Class<?> type = e.getClass();
        ExceptionStats stats = this.fatalErrorsMap.computeIfAbsent(type, k -> ExceptionStats.create());
        stats.recordException(e, causedObject);
        if (this.next != null) {
            this.next.onFatalError(e, causedObject);
        }
    }

    @Override
    public void onScheduledTaskOverdue(int overdue, boolean background) {
        if (background) {
            this.tasks.background.overdues.recordValue(overdue);
        } else {
            this.tasks.scheduled.overdues.recordValue(overdue);
        }
        if (this.next != null) {
            this.next.onScheduledTaskOverdue(overdue, background);
        }
    }

    @JmxAttribute
    public EventStats getLoops() {
        return this.loops;
    }

    @JmxAttribute(extraSubAttributes={"histogram"})
    public ValueStats getSelectorSelectTime() {
        return this.selectorSelectTime;
    }

    @JmxAttribute(extraSubAttributes={"histogram"})
    public ValueStats getSelectorSelectTimeout() {
        return this.selectorSelectTimeout;
    }

    @JmxAttribute(extraSubAttributes={"histogram"})
    public ValueStats getBusinessLogicTime() {
        return this.businessLogicTime;
    }

    @JmxAttribute
    public Tasks getTasks() {
        return this.tasks;
    }

    @JmxAttribute
    public Keys getKeys() {
        return this.keys;
    }

    @JmxAttribute
    public ExceptionStats getFatalErrors() {
        return this.fatalErrors;
    }

    @JmxAttribute
    public Map<Class<? extends Throwable>, ExceptionStats> getFatalErrorsMap() {
        return this.fatalErrorsMap;
    }

    @JmxAttribute
    public EventStats getIdleLoops() {
        return this.idleLoops;
    }

    @JmxAttribute
    public EventStats getIdleLoopsWaitingExternalTask() {
        return this.idleLoopsWaitingExternalTask;
    }

    @JmxAttribute
    public EventStats getSelectOverdues() {
        return this.selectOverdues;
    }

    public static final class DurationRunnable
    implements JmxStats<DurationRunnable>,
    JmxStatsWithReset {
        private long duration;
        @Nullable
        private Runnable runnable;

        @Override
        public void resetStats() {
            this.duration = 0L;
            this.runnable = null;
        }

        void update(Runnable runnable, long duration) {
            this.duration = duration;
            this.runnable = runnable;
        }

        @JmxAttribute(name="duration(\u03bcs)")
        public long getDuration() {
            return this.duration;
        }

        @JmxAttribute
        public String getClassName() {
            return this.runnable == null ? "" : this.runnable.getClass().getName();
        }

        @Override
        public void add(DurationRunnable another) {
            if (another.duration > this.duration) {
                this.duration = another.duration;
                this.runnable = another.runnable;
            }
        }
    }

    private static final class StackTrace {
        private final StackTraceElement[] stackTraceElements;

        public StackTrace(StackTraceElement[] stackTraceElements) {
            this.stackTraceElements = stackTraceElements;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StackTrace)) {
                return false;
            }
            StackTrace that = (StackTrace)o;
            return Arrays.equals(this.stackTraceElements, that.stackTraceElements);
        }

        public int hashCode() {
            return this.stackTraceElements != null ? Arrays.hashCode(this.stackTraceElements) : 0;
        }
    }

    public static final class Keys {
        private final EventStats all = EventStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withRateUnit("keys");
        private final EventStats invalid = EventStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withRateUnit("keys");
        private final ValueStats acceptPerLoop = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO);
        private final ValueStats connectPerLoop = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO);
        private final ValueStats readPerLoop = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO);
        private final ValueStats writePerLoop = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO);
        private final ValueStats loopTime = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO).withUnit("milliseconds");
        private final ValueStats oneKeyTime = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO).withUnit("microseconds");

        @JmxAttribute
        public EventStats getAll() {
            return this.all;
        }

        @JmxAttribute
        public EventStats getInvalid() {
            return this.invalid;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getAcceptPerLoop() {
            return this.acceptPerLoop;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getConnectPerLoop() {
            return this.connectPerLoop;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getReadPerLoop() {
            return this.readPerLoop;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getWritePerLoop() {
            return this.writePerLoop;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getLoopTime() {
            return this.loopTime;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getOneKeyTime() {
            return this.oneKeyTime;
        }
    }

    public static final class ScheduledTaskStats
    extends TaskStats {
        private final ValueStats overdues = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO).withRate().withUnit("milliseconds");

        ScheduledTaskStats() {
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getOverdues() {
            return this.overdues;
        }
    }

    public static class TaskStats {
        private final ValueStats tasksPerLoop = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO);
        private final ValueStats loopTime = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO).withUnit("milliseconds");
        private final ValueStats oneTaskTime = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO).withUnit("microseconds");
        private final DurationRunnable longestTask = new DurationRunnable();

        TaskStats() {
        }

        @JmxAttribute(name="perLoop", extraSubAttributes={"histogram"})
        public ValueStats getTasksPerLoop() {
            return this.tasksPerLoop;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getLoopTime() {
            return this.loopTime;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getOneTaskTime() {
            return this.oneTaskTime;
        }

        @JmxAttribute
        public DurationRunnable getLongestTask() {
            return this.longestTask;
        }

        @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
        public int getCount() {
            return (int)this.tasksPerLoop.getLastValue();
        }
    }

    public static final class Tasks {
        private final TaskStats local = new TaskStats();
        private final TaskStats concurrent = new TaskStats();
        private final ScheduledTaskStats scheduled = new ScheduledTaskStats();
        private final ScheduledTaskStats background = new ScheduledTaskStats();

        Tasks() {
        }

        @JmxAttribute
        public TaskStats getLocal() {
            return this.local;
        }

        @JmxAttribute
        public TaskStats getConcurrent() {
            return this.concurrent;
        }

        @JmxAttribute
        public ScheduledTaskStats getScheduled() {
            return this.scheduled;
        }

        @JmxAttribute
        public ScheduledTaskStats getBackground() {
            return this.background;
        }
    }
}

