/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop;

import io.datakernel.async.callback.Completable;
import io.datakernel.common.Initializable;
import io.datakernel.common.Preconditions;
import io.datakernel.common.Stopwatch;
import io.datakernel.common.exception.AsyncTimeoutException;
import io.datakernel.common.exception.StacklessException;
import io.datakernel.common.exception.UncheckedException;
import io.datakernel.common.inspector.BaseInspector;
import io.datakernel.common.time.CurrentTimeProvider;
import io.datakernel.common.time.CurrentTimeProviderSystem;
import io.datakernel.eventloop.AcceptCallback;
import io.datakernel.eventloop.ConnectCallback;
import io.datakernel.eventloop.EventloopExecutor;
import io.datakernel.eventloop.EventloopInspector;
import io.datakernel.eventloop.EventloopStats;
import io.datakernel.eventloop.FatalErrorHandler;
import io.datakernel.eventloop.FatalErrorHandlers;
import io.datakernel.eventloop.NioChannelEventHandler;
import io.datakernel.eventloop.ScheduledRunnable;
import io.datakernel.eventloop.Scheduler;
import io.datakernel.eventloop.jmx.EventloopJmxMBeanEx;
import io.datakernel.eventloop.net.DatagramSocketSettings;
import io.datakernel.eventloop.net.ServerSocketSettings;
import io.datakernel.eventloop.util.OptimizedSelectedKeysSet;
import io.datakernel.eventloop.util.ReflectionUtils;
import io.datakernel.eventloop.util.Utils;
import io.datakernel.jmx.api.JmxAttribute;
import io.datakernel.jmx.api.JmxOperation;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Eventloop
implements Runnable,
EventloopExecutor,
Scheduler,
Initializable<Eventloop>,
EventloopJmxMBeanEx {
    public static final Logger logger = LoggerFactory.getLogger(Eventloop.class);
    public static final boolean jigsawDisabled;
    static final Duration DEFAULT_SMOOTHING_WINDOW;
    public static final AsyncTimeoutException CONNECT_TIMEOUT;
    public static final StacklessException NOT_CONNECTED;
    public static final Duration DEFAULT_IDLE_INTERVAL;
    @NotNull
    private static volatile FatalErrorHandler globalFatalErrorHandler;
    private final ArrayDeque<Runnable> localTasks = new ArrayDeque();
    private final ConcurrentLinkedQueue<Runnable> concurrentTasks = new ConcurrentLinkedQueue();
    private final PriorityQueue<ScheduledRunnable> scheduledTasks = new PriorityQueue();
    private final PriorityQueue<ScheduledRunnable> backgroundTasks = new PriorityQueue();
    private final AtomicInteger externalTasksCount = new AtomicInteger(0);
    private int loop;
    private int tick;
    private long timestamp;
    @NotNull
    private final CurrentTimeProvider timeProvider;
    @Nullable
    private Selector selector;
    @Nullable
    private SelectorProvider selectorProvider;
    @Nullable
    private Thread eventloopThread;
    private static final ThreadLocal<Eventloop> CURRENT_EVENTLOOP;
    @Nullable
    private String threadName;
    private int threadPriority;
    @Nullable
    private FatalErrorHandler fatalErrorHandler;
    private volatile boolean keepAlive;
    private volatile boolean breakEventloop;
    private Duration idleInterval = DEFAULT_IDLE_INTERVAL;
    private int lastSelectedKeys;
    private int cancelledKeys;
    private int lastExternalTasksCount;
    @Nullable
    private EventloopInspector inspector;
    private boolean monitoring = false;
    private static final String NO_CURRENT_EVENTLOOP_ERROR = "Trying to start async operations prior eventloop.run(), or from outside of eventloop.run() \nPossible solutions: 1) Eventloop.create().withCurrentThread() ... {your code block} ... eventloop.run() \n2) try_with_resources Eventloop.useCurrentThread() ... {your code block} \n3) refactor application so it starts async operations within eventloop.run(), \n   i.e. by implementing EventloopService::start() {your code block} and using ServiceGraphModule";

    private Eventloop(@NotNull CurrentTimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        this.refreshTimestamp();
    }

    public static Eventloop create() {
        return Eventloop.create((CurrentTimeProvider)CurrentTimeProviderSystem.instance());
    }

    public static Eventloop create(@NotNull CurrentTimeProvider currentTimeProvider) {
        return new Eventloop(currentTimeProvider);
    }

    @NotNull
    public Eventloop withThreadName(@Nullable String threadName) {
        this.threadName = threadName;
        return this;
    }

    @NotNull
    public Eventloop withThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
        return this;
    }

    @NotNull
    public Eventloop withInspector(@Nullable EventloopInspector inspector) {
        this.inspector = inspector;
        return this;
    }

    @NotNull
    public Eventloop withFatalErrorHandler(@Nullable FatalErrorHandler fatalErrorHandler) {
        this.fatalErrorHandler = fatalErrorHandler;
        return this;
    }

    @NotNull
    public Eventloop withSelectorProvider(@Nullable SelectorProvider selectorProvider) {
        this.selectorProvider = selectorProvider;
        return this;
    }

    @NotNull
    public Eventloop withIdleInterval(@NotNull Duration idleInterval) {
        this.idleInterval = idleInterval;
        return this;
    }

    @NotNull
    public Eventloop withCurrentThread() {
        CURRENT_EVENTLOOP.set(this);
        return this;
    }

    @Nullable
    public Selector getSelector() {
        return this.selector;
    }

    @NotNull
    public static Eventloop getCurrentEventloop() {
        Eventloop eventloop = CURRENT_EVENTLOOP.get();
        if (eventloop != null) {
            return eventloop;
        }
        throw new IllegalStateException(NO_CURRENT_EVENTLOOP_ERROR);
    }

    private void openSelector() {
        if (this.selector == null) {
            try {
                this.selector = (this.selectorProvider != null ? this.selectorProvider : SelectorProvider.provider()).openSelector();
            }
            catch (Exception e) {
                logger.error("Could not open selector", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void closeSelector() {
        if (this.selector != null) {
            try {
                this.selector.close();
                this.selector = null;
                this.cancelledKeys = 0;
            }
            catch (IOException e) {
                logger.error("Could not close selector", (Throwable)e);
            }
        }
    }

    @Nullable
    public Selector ensureSelector() {
        if (this.selector == null) {
            this.openSelector();
        }
        return this.selector;
    }

    public void closeChannel(@Nullable SelectableChannel channel, @Nullable SelectionKey key) {
        Preconditions.checkArgument((channel != null || key == null ? 1 : 0) != 0, (Object)"Either channel or key should be not null");
        if (channel == null || !channel.isOpen()) {
            return;
        }
        if (key != null && key.isValid()) {
            ++this.cancelledKeys;
        }
        try {
            channel.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close channel {}", (Object)channel, (Object)e);
        }
    }

    public boolean inEventloopThread() {
        return this.eventloopThread == null || this.eventloopThread == Thread.currentThread();
    }

    public void keepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        if (!keepAlive && this.selector != null) {
            this.selector.wakeup();
        }
    }

    public void breakEventloop() {
        this.breakEventloop = true;
        if (this.breakEventloop && this.selector != null) {
            this.selector.wakeup();
        }
    }

    private boolean isAlive() {
        if (this.breakEventloop) {
            return false;
        }
        this.lastExternalTasksCount = this.externalTasksCount.get();
        return !this.localTasks.isEmpty() || !this.scheduledTasks.isEmpty() || !this.concurrentTasks.isEmpty() || this.lastExternalTasksCount > 0 || this.keepAlive || this.selector != null && this.selector.isOpen() && this.selector.keys().size() - this.cancelledKeys > 0;
    }

    @Nullable
    public Thread getEventloopThread() {
        return this.eventloopThread;
    }

    @Override
    public void run() {
        this.eventloopThread = Thread.currentThread();
        if (this.threadName != null) {
            this.eventloopThread.setName(this.threadName);
        }
        if (this.threadPriority != 0) {
            this.eventloopThread.setPriority(this.threadPriority);
        }
        CURRENT_EVENTLOOP.set(this);
        this.ensureSelector();
        assert (this.selector != null);
        this.breakEventloop = false;
        boolean setWasOptimized = jigsawDisabled && Utils.tryToOptimizeSelector(this.selector);
        long timeAfterBusinessLogic = 0L;
        while (this.isAlive()) {
            try {
                long selectTimeout = this.getSelectTimeout();
                if (this.inspector != null) {
                    this.inspector.onUpdateSelectorSelectTimeout(selectTimeout);
                }
                this.lastSelectedKeys = selectTimeout <= 0L ? this.selector.selectNow() : this.selector.select(selectTimeout);
                this.cancelledKeys = 0;
            }
            catch (ClosedChannelException e) {
                logger.error("Selector is closed, exiting...", (Throwable)e);
                break;
            }
            catch (IOException e) {
                this.recordIoError(e, this.selector);
            }
            long timeAfterSelectorSelect = this.refreshTimestampAndGet();
            int keys = setWasOptimized ? this.optimizedProcessSelectedKeys((OptimizedSelectedKeysSet)this.selector.selectedKeys()) : this.processSelectedKeys(this.selector.selectedKeys());
            int concurrentTasks = this.executeConcurrentTasks();
            int scheduledTasks = this.executeScheduledTasks();
            int backgroundTasks = this.executeBackgroundTasks();
            int localTasks = this.executeLocalTasks();
            if (this.inspector != null) {
                if (timeAfterBusinessLogic != 0L) {
                    long selectorSelectTime = timeAfterSelectorSelect - timeAfterBusinessLogic;
                    this.inspector.onUpdateSelectorSelectTime(selectorSelectTime);
                }
                timeAfterBusinessLogic = this.timestamp;
                boolean taskOrKeyPresent = keys + concurrentTasks + scheduledTasks + backgroundTasks + localTasks != 0;
                boolean externalTaskPresent = this.lastExternalTasksCount != 0;
                long businessLogicTime = timeAfterBusinessLogic - timeAfterSelectorSelect;
                this.inspector.onUpdateBusinessLogicTime(taskOrKeyPresent, externalTaskPresent, businessLogicTime);
            }
            ++this.loop;
            this.tick = 0;
        }
        logger.info("{} finished", (Object)this);
        this.eventloopThread = null;
        if (this.selector != null && this.selector.isOpen() && this.selector.keys().stream().anyMatch(SelectionKey::isValid)) {
            logger.warn("Selector is still open, because event loop {} has {} keys", (Object)this, this.selector.keys());
            return;
        }
        this.closeSelector();
    }

    private long getSelectTimeout() {
        if (!this.concurrentTasks.isEmpty() || !this.localTasks.isEmpty()) {
            return 0L;
        }
        if (this.scheduledTasks.isEmpty() && this.backgroundTasks.isEmpty()) {
            return this.idleInterval.toMillis();
        }
        return Math.min(this.getTimeBeforeExecution(this.scheduledTasks), this.getTimeBeforeExecution(this.backgroundTasks));
    }

    private long getTimeBeforeExecution(PriorityQueue<ScheduledRunnable> taskQueue) {
        while (!taskQueue.isEmpty()) {
            ScheduledRunnable first = taskQueue.peek();
            assert (first != null);
            if (first.isCancelled()) {
                taskQueue.poll();
                continue;
            }
            return first.getTimestamp() - this.currentTimeMillis();
        }
        return this.idleInterval.toMillis();
    }

    private int processSelectedKeys(@NotNull Set<SelectionKey> selectedKeys) {
        Iterator<Object> iterator;
        long startTimestamp = this.timestamp;
        Stopwatch sw = this.monitoring ? Stopwatch.createUnstarted() : null;
        int invalidKeys = 0;
        int acceptKeys = 0;
        int connectKeys = 0;
        int readKeys = 0;
        int writeKeys = 0;
        Iterator<Object> iterator2 = iterator = this.lastSelectedKeys != 0 ? selectedKeys.iterator() : Collections.emptyIterator();
        while (iterator.hasNext()) {
            SelectionKey key = (SelectionKey)iterator.next();
            iterator.remove();
            if (!key.isValid()) {
                ++invalidKeys;
                continue;
            }
            if (sw != null) {
                sw.reset();
                sw.start();
            }
            if (key.isAcceptable()) {
                this.onAccept(key);
                ++acceptKeys;
            } else if (key.isConnectable()) {
                this.onConnect(key);
                ++connectKeys;
            } else {
                if (key.isReadable()) {
                    this.onRead(key);
                    ++readKeys;
                }
                if (key.isValid()) {
                    if (key.isWritable()) {
                        this.onWrite(key);
                        ++writeKeys;
                    }
                } else {
                    ++invalidKeys;
                }
            }
            if (sw == null || this.inspector == null) continue;
            this.inspector.onUpdateSelectedKeyDuration(sw);
        }
        int keys = acceptKeys + connectKeys + readKeys + writeKeys + invalidKeys;
        if (keys != 0) {
            long loopTime = this.refreshTimestampAndGet() - startTimestamp;
            if (this.inspector != null) {
                this.inspector.onUpdateSelectedKeysStats(this.lastSelectedKeys, invalidKeys, acceptKeys, connectKeys, readKeys, writeKeys, loopTime);
            }
        }
        return keys;
    }

    private int optimizedProcessSelectedKeys(@NotNull OptimizedSelectedKeysSet selectedKeys) {
        long startTimestamp = this.timestamp;
        Stopwatch sw = this.monitoring ? Stopwatch.createUnstarted() : null;
        int invalidKeys = 0;
        int acceptKeys = 0;
        int connectKeys = 0;
        int readKeys = 0;
        int writeKeys = 0;
        for (int i = 0; i < selectedKeys.size(); ++i) {
            SelectionKey key = selectedKeys.get(i);
            assert (key != null);
            if (!key.isValid()) {
                ++invalidKeys;
                continue;
            }
            if (sw != null) {
                sw.reset();
                sw.start();
            }
            if (key.isAcceptable()) {
                this.onAccept(key);
                ++acceptKeys;
            } else if (key.isConnectable()) {
                this.onConnect(key);
                ++connectKeys;
            } else {
                if (key.isReadable()) {
                    this.onRead(key);
                    ++readKeys;
                }
                if (key.isValid()) {
                    if (key.isWritable()) {
                        this.onWrite(key);
                        ++writeKeys;
                    }
                } else {
                    ++invalidKeys;
                }
            }
            if (sw == null || this.inspector == null) continue;
            this.inspector.onUpdateSelectedKeyDuration(sw);
        }
        selectedKeys.clear();
        int keys = acceptKeys + connectKeys + readKeys + writeKeys + invalidKeys;
        if (keys != 0) {
            long loopTime = this.refreshTimestampAndGet() - startTimestamp;
            if (this.inspector != null) {
                this.inspector.onUpdateSelectedKeysStats(this.lastSelectedKeys, invalidKeys, acceptKeys, connectKeys, readKeys, writeKeys, loopTime);
            }
        }
        return keys;
    }

    private static void executeTask(@Async.Execute Runnable task) {
        task.run();
    }

    private int executeLocalTasks() {
        Runnable runnable;
        Stopwatch sw;
        long startTimestamp = this.timestamp;
        int localTasks = 0;
        Object object = sw = this.monitoring ? Stopwatch.createUnstarted() : null;
        while ((runnable = this.localTasks.poll()) != null) {
            if (sw != null) {
                sw.reset();
                sw.start();
            }
            try {
                Eventloop.executeTask(runnable);
                ++this.tick;
                if (sw != null && this.inspector != null) {
                    this.inspector.onUpdateLocalTaskDuration(runnable, sw);
                }
            }
            catch (Throwable e) {
                this.recordFatalError(e, runnable);
            }
            ++localTasks;
        }
        if (localTasks != 0) {
            long loopTime = this.refreshTimestampAndGet() - startTimestamp;
            if (this.inspector != null) {
                this.inspector.onUpdateLocalTasksStats(localTasks, loopTime);
            }
        }
        return localTasks;
    }

    private int executeConcurrentTasks() {
        Runnable runnable;
        Stopwatch sw;
        long startTimestamp = this.timestamp;
        int concurrentTasks = 0;
        Object object = sw = this.monitoring ? Stopwatch.createUnstarted() : null;
        while ((runnable = this.concurrentTasks.poll()) != null) {
            if (sw != null) {
                sw.reset();
                sw.start();
            }
            try {
                Eventloop.executeTask(runnable);
                if (sw != null && this.inspector != null) {
                    this.inspector.onUpdateConcurrentTaskDuration(runnable, sw);
                }
            }
            catch (Throwable e) {
                this.recordFatalError(e, runnable);
            }
            ++concurrentTasks;
        }
        if (concurrentTasks != 0) {
            long loopTime = this.refreshTimestampAndGet() - startTimestamp;
            if (this.inspector != null) {
                this.inspector.onUpdateConcurrentTasksStats(concurrentTasks, loopTime);
            }
        }
        return concurrentTasks;
    }

    private int executeScheduledTasks() {
        return this.executeScheduledTasks(this.scheduledTasks);
    }

    private int executeBackgroundTasks() {
        return this.executeScheduledTasks(this.backgroundTasks);
    }

    private int executeScheduledTasks(PriorityQueue<ScheduledRunnable> taskQueue) {
        ScheduledRunnable peeked;
        Stopwatch sw;
        long startTimestamp = this.timestamp;
        boolean background = taskQueue == this.backgroundTasks;
        int scheduledTasks = 0;
        Object object = sw = this.monitoring ? Stopwatch.createUnstarted() : null;
        while ((peeked = taskQueue.peek()) != null) {
            if (peeked.isCancelled()) {
                taskQueue.poll();
                continue;
            }
            if (peeked.getTimestamp() > this.currentTimeMillis()) break;
            taskQueue.poll();
            Runnable runnable = peeked.getRunnable();
            if (sw != null) {
                sw.reset();
                sw.start();
            }
            if (this.monitoring && this.inspector != null) {
                int overdue = (int)(System.currentTimeMillis() - peeked.getTimestamp());
                this.inspector.onScheduledTaskOverdue(overdue, background);
            }
            try {
                Eventloop.executeTask(runnable);
                ++this.tick;
                peeked.complete();
                if (sw != null && this.inspector != null) {
                    this.inspector.onUpdateScheduledTaskDuration(runnable, sw, background);
                }
            }
            catch (Throwable e) {
                this.recordFatalError(e, runnable);
            }
            ++scheduledTasks;
        }
        if (scheduledTasks != 0) {
            long loopTime = this.refreshTimestampAndGet() - startTimestamp;
            if (this.inspector != null) {
                this.inspector.onUpdateScheduledTasksStats(scheduledTasks, loopTime, background);
            }
        }
        return scheduledTasks;
    }

    private void onAccept(SelectionKey key) {
        assert (this.inEventloopThread());
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
        if (!serverSocketChannel.isOpen()) {
            key.cancel();
            return;
        }
        AcceptCallback acceptCallback = (AcceptCallback)key.attachment();
        while (true) {
            SocketChannel channel;
            try {
                channel = serverSocketChannel.accept();
                if (channel == null) break;
                channel.configureBlocking(false);
            }
            catch (ClosedChannelException e) {
                break;
            }
            catch (IOException e) {
                this.recordIoError(e, serverSocketChannel);
                break;
            }
            try {
                acceptCallback.onAccept(channel);
            }
            catch (Throwable e) {
                this.recordFatalError(e, acceptCallback);
                this.closeChannel(channel, null);
            }
        }
    }

    private void onConnect(SelectionKey key) {
        boolean connected;
        assert (this.inEventloopThread());
        ConnectCallback cb = (ConnectCallback)key.attachment();
        SocketChannel channel = (SocketChannel)key.channel();
        try {
            connected = channel.finishConnect();
        }
        catch (IOException e) {
            this.closeChannel(channel, key);
            cb.onException(e);
            return;
        }
        try {
            if (connected) {
                cb.onConnect(channel);
            } else {
                cb.onException((Throwable)NOT_CONNECTED);
            }
        }
        catch (Throwable e) {
            this.recordFatalError(e, channel);
            this.closeChannel(channel, null);
        }
    }

    private void onRead(SelectionKey key) {
        assert (this.inEventloopThread());
        NioChannelEventHandler handler = (NioChannelEventHandler)key.attachment();
        try {
            handler.onReadReady();
        }
        catch (Throwable e) {
            this.recordFatalError(e, handler);
            this.closeChannel(key.channel(), null);
        }
    }

    private void onWrite(SelectionKey key) {
        assert (this.inEventloopThread());
        NioChannelEventHandler handler = (NioChannelEventHandler)key.attachment();
        try {
            handler.onWriteReady();
        }
        catch (Throwable e) {
            this.recordFatalError(e, handler);
            this.closeChannel(key.channel(), null);
        }
    }

    @NotNull
    public ServerSocketChannel listen(@Nullable InetSocketAddress address, @NotNull ServerSocketSettings serverSocketSettings, @NotNull AcceptCallback acceptCallback) throws IOException {
        assert (this.inEventloopThread());
        ServerSocketChannel serverSocketChannel = null;
        try {
            serverSocketChannel = ServerSocketChannel.open();
            serverSocketSettings.applySettings(serverSocketChannel);
            serverSocketChannel.configureBlocking(false);
            serverSocketChannel.bind(address, serverSocketSettings.getBacklog());
            serverSocketChannel.register(this.ensureSelector(), 16, acceptCallback);
            return serverSocketChannel;
        }
        catch (IOException e) {
            if (serverSocketChannel != null) {
                this.closeChannel(serverSocketChannel, null);
            }
            throw e;
        }
    }

    @NotNull
    public static DatagramChannel createDatagramChannel(DatagramSocketSettings datagramSocketSettings, @Nullable InetSocketAddress bindAddress, @Nullable InetSocketAddress connectAddress) throws IOException {
        DatagramChannel datagramChannel = null;
        try {
            datagramChannel = DatagramChannel.open();
            datagramSocketSettings.applySettings(datagramChannel);
            datagramChannel.configureBlocking(false);
            datagramChannel.bind(bindAddress);
            if (connectAddress != null) {
                datagramChannel.connect(connectAddress);
            }
            return datagramChannel;
        }
        catch (IOException e) {
            if (datagramChannel != null) {
                try {
                    datagramChannel.close();
                }
                catch (Exception nested) {
                    logger.error("Failed closing datagram channel after I/O error", (Throwable)nested);
                    e.addSuppressed(nested);
                }
            }
            throw e;
        }
    }

    public void connect(SocketAddress address, @NotNull ConnectCallback cb) {
        this.connect(address, 0L, cb);
    }

    public void connect(SocketAddress address, @Nullable Duration timeout, @NotNull ConnectCallback cb) {
        this.connect(address, timeout == null ? 0L : timeout.toMillis(), cb);
    }

    public void connect(@NotNull SocketAddress address, final long timeout, final @NotNull ConnectCallback cb) {
        SocketChannel channel;
        assert (this.inEventloopThread());
        try {
            channel = SocketChannel.open();
        }
        catch (IOException e) {
            try {
                cb.onException(e);
            }
            catch (Throwable e1) {
                this.recordFatalError(e1, cb);
            }
            return;
        }
        try {
            channel.configureBlocking(false);
            channel.connect(address);
            channel.register(this.ensureSelector(), 8, timeout == 0L ? cb : new ConnectCallback(){
                final ScheduledRunnable scheduledTimeout;
                {
                    this.scheduledTimeout = Eventloop.this.delay(timeout, () -> {
                        Eventloop.this.closeChannel(channel, null);
                        cb.onException((Throwable)CONNECT_TIMEOUT);
                    });
                }

                @Override
                public void onConnect(@NotNull SocketChannel socketChannel) {
                    this.scheduledTimeout.cancel();
                    cb.onConnect(socketChannel);
                }

                @Override
                public void onException(@NotNull Throwable e) {
                    this.scheduledTimeout.cancel();
                    cb.onException(e);
                }
            });
        }
        catch (IOException e) {
            this.closeChannel(channel, null);
            try {
                cb.onException(e);
            }
            catch (Throwable e1) {
                this.recordFatalError(e1, cb);
            }
        }
    }

    public long tick() {
        assert (this.inEventloopThread());
        return (long)this.loop << 32 | (long)this.tick;
    }

    public void post(@NotNull @Async.Schedule Runnable runnable) {
        assert (this.inEventloopThread());
        this.localTasks.addFirst(runnable);
    }

    public void postLater(@NotNull @Async.Schedule Runnable runnable) {
        assert (this.inEventloopThread());
        this.localTasks.addLast(runnable);
    }

    @Override
    public void execute(@NotNull @Async.Schedule Runnable runnable) {
        this.concurrentTasks.offer(runnable);
        if (this.selector != null) {
            this.selector.wakeup();
        }
    }

    @Override
    @NotNull
    public ScheduledRunnable schedule(long timestamp, @NotNull @Async.Schedule Runnable runnable) {
        assert (this.inEventloopThread());
        return this.addScheduledTask(timestamp, runnable, false);
    }

    @Override
    @NotNull
    public ScheduledRunnable scheduleBackground(long timestamp, @NotNull @Async.Schedule Runnable runnable) {
        assert (this.inEventloopThread());
        return this.addScheduledTask(timestamp, runnable, true);
    }

    @NotNull
    private ScheduledRunnable addScheduledTask(long timestamp, Runnable runnable, boolean background) {
        ScheduledRunnable scheduledTask = ScheduledRunnable.create(timestamp, runnable);
        PriorityQueue<ScheduledRunnable> taskQueue = background ? this.backgroundTasks : this.scheduledTasks;
        taskQueue.offer(scheduledTask);
        return scheduledTask;
    }

    public void startExternalTask() {
        this.externalTasksCount.incrementAndGet();
    }

    public void completeExternalTask() {
        this.externalTasksCount.decrementAndGet();
    }

    public long refreshTimestampAndGet() {
        this.refreshTimestamp();
        return this.timestamp;
    }

    private void refreshTimestamp() {
        this.timestamp = this.timeProvider.currentTimeMillis();
    }

    public long currentTimeMillis() {
        return this.timestamp;
    }

    @Override
    @NotNull
    public Eventloop getEventloop() {
        return this;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> submit(@NotNull Runnable computation) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.execute(() -> {
            try {
                computation.run();
            }
            catch (UncheckedException u) {
                future.completeExceptionally(u.getCause());
                return;
            }
            future.complete(null);
        });
        return future;
    }

    @Override
    @NotNull
    public <T> CompletableFuture<T> submit(Supplier<? extends Completable<T>> computation) {
        CompletableFuture future = new CompletableFuture();
        this.execute(() -> {
            try {
                ((Completable)computation.get()).onComplete((result, e) -> {
                    if (e == null) {
                        future.complete(result);
                    } else {
                        future.completeExceptionally(e);
                    }
                });
            }
            catch (UncheckedException u) {
                future.completeExceptionally(u.getCause());
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (Exception e3) {
                future.completeExceptionally(e3);
            }
        });
        return future;
    }

    public static void setGlobalFatalErrorHandler(@NotNull FatalErrorHandler handler) {
        globalFatalErrorHandler = (FatalErrorHandler)Preconditions.checkNotNull((Object)handler);
    }

    @JmxOperation(description="enable monitoring [ when monitoring is enabled more stats are collected, but it causes more overhead (for example, most of the durationStats are collected only when monitoring is enabled) ]")
    public void startExtendedMonitoring() {
        this.monitoring = true;
    }

    @JmxOperation(description="disable monitoring [ when monitoring is enabled more stats are collected, but it causes more overhead (for example, most of the durationStats are collected only when monitoring is enabled) ]")
    public void stopExtendedMonitoring() {
        this.monitoring = false;
    }

    @JmxAttribute(description="when monitoring is enabled more stats are collected, but it causes more overhead (for example, most of the durationStats are collected only when monitoring is enabled)")
    public boolean isExtendedMonitoring() {
        return this.monitoring;
    }

    private void recordIoError(@NotNull Exception e, @Nullable Object context) {
        logger.warn("IO Error in {}: {}", context, (Object)e.toString());
    }

    public void recordFatalError(@NotNull Throwable e, @Nullable Object context) {
        while (e instanceof UncheckedException) {
            e = e.getCause();
        }
        logger.error("Fatal Error in " + context, e);
        if (this.fatalErrorHandler != null) {
            this.handleFatalError(this.fatalErrorHandler, e, context);
        } else {
            this.handleFatalError(globalFatalErrorHandler, e, context);
        }
        if (this.inspector != null) {
            if (this.inEventloopThread()) {
                this.inspector.onFatalError(e, context);
            } else {
                Throwable finalE = e;
                this.execute(() -> this.inspector.onFatalError(finalE, context));
            }
        }
    }

    private void handleFatalError(@NotNull FatalErrorHandler handler, @NotNull Throwable e, @Nullable Object context) {
        if (this.inEventloopThread()) {
            handler.handle(e, context);
        } else {
            try {
                handler.handle(e, context);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @JmxAttribute
    public int getLoop() {
        return this.loop;
    }

    @JmxAttribute
    public long getTick() {
        return this.tick;
    }

    @Nullable
    public FatalErrorHandler getFatalErrorHandler() {
        return this.fatalErrorHandler;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    @JmxAttribute
    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    @JmxAttribute(name="")
    @Nullable
    public EventloopStats getStats() {
        return (EventloopStats)BaseInspector.lookup((BaseInspector)this.inspector, EventloopStats.class);
    }

    @JmxAttribute
    public Duration getIdleInterval() {
        return this.idleInterval;
    }

    @JmxAttribute
    public void setIdleInterval(Duration idleInterval) {
        this.idleInterval = idleInterval;
    }

    public String toString() {
        int externalTasks;
        int selectorKeys;
        StringBuilder sb = new StringBuilder("Eventloop");
        if (this.threadName != null) {
            sb.append('(').append(this.threadName).append(')');
        }
        sb.append("{loop=").append(this.loop);
        if (this.tick != 0) {
            sb.append(", tick=").append(this.tick);
        }
        if (this.selector != null && this.selector.isOpen() && (selectorKeys = this.selector.keys().size() - this.cancelledKeys) != 0) {
            sb.append(", selectorKeys=").append(selectorKeys);
        }
        if (!this.localTasks.isEmpty()) {
            sb.append(", localTasks=").append(this.localTasks.size());
        }
        if (!this.scheduledTasks.isEmpty()) {
            sb.append(", scheduledTasks=").append(this.scheduledTasks.size());
        }
        if (!this.backgroundTasks.isEmpty()) {
            sb.append(", backgroundTasks=").append(this.backgroundTasks.size());
        }
        if (!this.concurrentTasks.isEmpty()) {
            sb.append(", concurrentTasks=").append(this.concurrentTasks.size());
        }
        if ((externalTasks = this.externalTasksCount.get()) != 0) {
            sb.append(", externalTasks=").append(externalTasks);
        }
        return sb.append('}').toString();
    }

    static {
        DEFAULT_SMOOTHING_WINDOW = Duration.ofMinutes(1L);
        jigsawDisabled = ReflectionUtils.isPrivateApiAvailable();
        CONNECT_TIMEOUT = new AsyncTimeoutException(Eventloop.class, "Connection timed out");
        NOT_CONNECTED = new StacklessException(Eventloop.class, "Connection key was received but the channel was not connected - this is not possible without some bug in Java NIO");
        DEFAULT_IDLE_INTERVAL = Duration.ofSeconds(1L);
        globalFatalErrorHandler = FatalErrorHandlers.ignoreAllErrors();
        CURRENT_EVENTLOOP = new ThreadLocal();
    }
}

