/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop;

import io.datakernel.async.callback.Completable;
import io.datakernel.common.exception.UncheckedException;
import io.datakernel.eventloop.Eventloop;
import io.datakernel.eventloop.EventloopExecutor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class BlockingEventloopExecutor
implements EventloopExecutor {
    private final Eventloop eventloop;
    private final Lock lock = new ReentrantLock();
    private final Condition notFull = this.lock.newCondition();
    private final AtomicInteger tasks = new AtomicInteger();
    private final int limit;

    private BlockingEventloopExecutor(Eventloop eventloop, int limit) {
        this.eventloop = eventloop;
        this.limit = limit;
    }

    public static BlockingEventloopExecutor create(Eventloop eventloop, int limit) {
        return new BlockingEventloopExecutor(eventloop, limit);
    }

    public int getLimit() {
        return this.limit;
    }

    private void post(Runnable runnable) throws InterruptedException {
        this.lock.lock();
        try {
            while (this.tasks.get() > this.limit) {
                this.notFull.await();
            }
            this.tasks.incrementAndGet();
            this.eventloop.execute(runnable);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void post(Runnable runnable, CompletableFuture<?> future) {
        try {
            this.post(runnable);
        }
        catch (InterruptedException e) {
            future.completeExceptionally(e);
        }
    }

    private void complete() {
        this.lock.lock();
        try {
            this.tasks.decrementAndGet();
            this.notFull.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void execute(@NotNull Runnable runnable) {
        try {
            this.post(() -> {
                try {
                    runnable.run();
                }
                finally {
                    this.complete();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public CompletableFuture<Void> submit(@NotNull Runnable computation) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.post(() -> {
            try {
                computation.run();
            }
            catch (UncheckedException u) {
                future.completeExceptionally(u.getCause());
                return;
            }
            future.complete(null);
        }, future);
        return future;
    }

    @Override
    @NotNull
    public <T> CompletableFuture<T> submit(Supplier<? extends Completable<T>> computation) {
        CompletableFuture future = new CompletableFuture();
        this.post(() -> {
            try {
                ((Completable)computation.get()).onComplete((result, e) -> {
                    if (e == null) {
                        future.complete(result);
                    } else {
                        future.completeExceptionally(e);
                    }
                });
            }
            catch (UncheckedException u) {
                future.completeExceptionally(u.getCause());
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (Exception e3) {
                future.completeExceptionally(e3);
            }
        }, future);
        return future;
    }
}

