/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.codec.registry;

import io.datakernel.codec.StructuredCodec;
import io.datakernel.codec.StructuredCodecs;
import io.datakernel.codec.registry.CodecFactory;
import io.datakernel.util.Preconditions;
import io.datakernel.util.RecursiveType;
import io.datakernel.util.Tuple1;
import io.datakernel.util.Tuple2;
import io.datakernel.util.Tuple3;
import io.datakernel.util.Tuple4;
import io.datakernel.util.Tuple5;
import io.datakernel.util.Tuple6;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class CodecRegistry
implements CodecFactory {
    private final Map<Class<?>, BiFunction<CodecFactory, StructuredCodec<?>[], StructuredCodec<?>>> map = new HashMap();

    private CodecRegistry() {
    }

    public static CodecRegistry create() {
        return new CodecRegistry();
    }

    public static CodecRegistry createDefault() {
        return CodecRegistry.create().with(Void.TYPE, StructuredCodecs.VOID_CODEC).with(Boolean.TYPE, StructuredCodecs.BOOLEAN_CODEC).with(Character.TYPE, StructuredCodecs.CHARACTER_CODEC).with(Byte.TYPE, StructuredCodecs.BYTE_CODEC).with(Integer.TYPE, StructuredCodecs.INT_CODEC).with(Long.TYPE, StructuredCodecs.LONG_CODEC).with(Float.TYPE, StructuredCodecs.FLOAT_CODEC).with(Double.TYPE, StructuredCodecs.DOUBLE_CODEC).with(Void.class, StructuredCodecs.VOID_CODEC).with(Boolean.class, StructuredCodecs.BOOLEAN_CODEC).with(Character.class, StructuredCodecs.CHARACTER_CODEC).with(Byte.class, StructuredCodecs.BYTE_CODEC).with(Integer.class, StructuredCodecs.INT_CODEC).with(Long.class, StructuredCodecs.LONG_CODEC).with(Float.class, StructuredCodecs.FLOAT_CODEC).with(Double.class, StructuredCodecs.DOUBLE_CODEC).with(String.class, StructuredCodecs.STRING_CODEC).with(byte[].class, StructuredCodecs.BYTES_CODEC).withGeneric(Optional.class, (registry, subCodecs) -> StructuredCodecs.ofOptional(subCodecs[0])).withGeneric(Set.class, (registry, subCodecs) -> StructuredCodecs.ofSet(subCodecs[0])).withGeneric(List.class, (registry, subCodecs) -> StructuredCodecs.ofList(subCodecs[0])).withGeneric(Map.class, (registry, subCodecs) -> StructuredCodecs.ofMap(subCodecs[0], subCodecs[1])).withGeneric(Tuple1.class, (registry, subCodecs) -> StructuredCodecs.tuple(Tuple1::new, Tuple1::getValue1, subCodecs[0])).withGeneric(Tuple2.class, (registry, subCodecs) -> StructuredCodecs.tuple(Tuple2::new, Tuple2::getValue1, subCodecs[0], Tuple2::getValue2, subCodecs[1])).withGeneric(Tuple3.class, (registry, subCodecs) -> StructuredCodecs.tuple(Tuple3::new, Tuple3::getValue1, subCodecs[0], Tuple3::getValue2, subCodecs[1], Tuple3::getValue3, subCodecs[2])).withGeneric(Tuple4.class, (registry, subCodecs) -> StructuredCodecs.tuple(Tuple4::new, Tuple4::getValue1, subCodecs[0], Tuple4::getValue2, subCodecs[1], Tuple4::getValue3, subCodecs[2], Tuple4::getValue4, subCodecs[3])).withGeneric(Tuple5.class, (registry, subCodecs) -> StructuredCodecs.tuple(Tuple5::new, Tuple5::getValue1, subCodecs[0], Tuple5::getValue2, subCodecs[1], Tuple5::getValue3, subCodecs[2], Tuple5::getValue4, subCodecs[3], Tuple5::getValue5, subCodecs[4])).withGeneric(Tuple6.class, (registry, subCodecs) -> StructuredCodecs.tuple(Tuple6::new, Tuple6::getValue1, subCodecs[0], Tuple6::getValue2, subCodecs[1], Tuple6::getValue3, subCodecs[2], Tuple6::getValue4, subCodecs[3], Tuple6::getValue5, subCodecs[4], Tuple6::getValue6, subCodecs[5]));
    }

    public <T> CodecRegistry with(Class<T> type, StructuredCodec<T> codec) {
        return this.withGeneric(type, (self, $) -> codec);
    }

    public <T> CodecRegistry with(Class<T> type, Function<CodecFactory, StructuredCodec<T>> codec) {
        return this.withGeneric(type, (self, $) -> (StructuredCodec)codec.apply((CodecFactory)self));
    }

    public <T> CodecRegistry withGeneric(Class<T> type, BiFunction<CodecFactory, StructuredCodec<Object>[], StructuredCodec<? extends T>> fn) {
        this.map.put(type, fn);
        return this;
    }

    @Override
    public <T> StructuredCodec<T> get(Type type) {
        if (type instanceof Class && Enum.class.isAssignableFrom((Class)type)) {
            return StructuredCodecs.ofEnum((Class)type);
        }
        return this.doGet(RecursiveType.of((Type)type));
    }

    private <T> StructuredCodec<T> doGet(RecursiveType type) {
        Class clazz = type.getRawType();
        BiFunction fn = (BiFunction)Preconditions.checkNotNull(this.map.get(clazz));
        StructuredCodec[] subCodecs = new StructuredCodec[type.getTypeParams().length];
        RecursiveType[] typeParams = type.getTypeParams();
        for (int i = 0; i < typeParams.length; ++i) {
            subCodecs[i] = this.doGet(typeParams[i]);
        }
        return (StructuredCodec)fn.apply(this, subCodecs);
    }
}

