/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.codec.json;

import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.datakernel.codec.StructuredCodec;
import io.datakernel.codec.StructuredDecoder;
import io.datakernel.codec.StructuredEncoder;
import io.datakernel.codec.StructuredInput;
import io.datakernel.codec.StructuredOutput;
import io.datakernel.codec.json.JsonStructuredInput;
import io.datakernel.codec.json.JsonStructuredOutput;
import io.datakernel.exception.ParseException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class JsonUtils {
    private JsonUtils() {
    }

    public static <T> T fromJson(StructuredDecoder<T> decoder, String string) throws ParseException {
        JsonReader reader = new JsonReader((Reader)new StringReader(string));
        T result = decoder.decode(new JsonStructuredInput(reader));
        try {
            if (reader.peek() != JsonToken.END_DOCUMENT) {
                throw new ParseException("Json data was not fully consumed when decoding");
            }
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        return result;
    }

    private static <T> void toJson(StructuredEncoder<T> encoder, T value, Writer writer) {
        JsonWriterEx jsonWriter = new JsonWriterEx(writer);
        jsonWriter.setLenient(true);
        jsonWriter.setIndentEx("");
        jsonWriter.setHtmlSafe(false);
        jsonWriter.setSerializeNulls(true);
        encoder.encode(new JsonStructuredOutput(jsonWriter), value);
    }

    public static <T> String toJson(StructuredEncoder<? super T> encoder, T value) {
        StringWriter writer = new StringWriter();
        JsonUtils.toJson(encoder, value, writer);
        return writer.toString();
    }

    public static <T> void toJson(StructuredEncoder<? super T> encoder, T value, Appendable appendable) {
        JsonUtils.toJson(encoder, value, Streams.writerForAppendable((Appendable)appendable));
    }

    public static <T> StructuredCodec<T> oneline(StructuredCodec<T> codec) {
        return JsonUtils.indent(codec, "");
    }

    public static <T> StructuredCodec<T> indent(final StructuredCodec<T> codec, final String indent) {
        return new StructuredCodec<T>(){

            @Override
            public void encode(StructuredOutput out, T item) {
                if (out instanceof JsonStructuredOutput) {
                    JsonStructuredOutput jsonOut = (JsonStructuredOutput)out;
                    if (jsonOut.writer instanceof JsonWriterEx) {
                        JsonWriterEx jsonWriterEx = (JsonWriterEx)jsonOut.writer;
                        String previousIndent = jsonWriterEx.getIndentEx();
                        jsonWriterEx.setIndentEx(indent);
                        if (indent.isEmpty()) {
                            try {
                                jsonWriterEx.writer.write(10);
                            }
                            catch (IOException e) {
                                throw new AssertionError();
                            }
                        }
                        codec.encode(out, item);
                        jsonWriterEx.setIndentEx(previousIndent);
                        return;
                    }
                }
                codec.encode(out, item);
            }

            @Override
            public T decode(StructuredInput in) throws ParseException {
                return codec.decode(in);
            }
        };
    }

    public static final class JsonWriterEx
    extends JsonWriter {
        final Writer writer;
        private String indentEx;

        public JsonWriterEx(Writer writer) {
            super(writer);
            this.writer = writer;
        }

        public final void setIndentEx(String indent) {
            this.indentEx = indent;
            this.setIndent(indent);
        }

        public JsonWriter name(String name) throws IOException {
            return super.name(name);
        }

        public final String getIndentEx() {
            return this.indentEx;
        }
    }
}

