/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.codec.json;

import com.google.gson.stream.JsonWriter;
import io.datakernel.codec.StructuredCodecs;
import io.datakernel.codec.StructuredEncoder;
import io.datakernel.codec.StructuredOutput;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Base64;
import java.util.List;
import java.util.Map;

public class JsonStructuredOutput
implements StructuredOutput {
    final JsonWriter writer;

    public JsonStructuredOutput(JsonWriter writer) {
        this.writer = writer;
    }

    @Override
    public void writeBoolean(boolean value) {
        try {
            this.writer.value(value);
        }
        catch (IOException ignored) {
            throw new AssertionError();
        }
    }

    @Override
    public void writeByte(byte value) {
        try {
            this.writer.value((long)(value & 0xFF));
        }
        catch (IOException ignored) {
            throw new AssertionError();
        }
    }

    @Override
    public void writeInt(int value) {
        try {
            this.writer.value((long)value);
        }
        catch (IOException ignored) {
            throw new AssertionError();
        }
    }

    @Override
    public void writeLong(long value) {
        try {
            this.writer.value(value);
        }
        catch (IOException ignored) {
            throw new AssertionError();
        }
    }

    @Override
    public void writeInt32(int value) {
        try {
            this.writer.value((long)value);
        }
        catch (IOException ignored) {
            throw new AssertionError();
        }
    }

    @Override
    public void writeLong64(long value) {
        try {
            this.writer.value(value);
        }
        catch (IOException ignored) {
            throw new AssertionError();
        }
    }

    @Override
    public void writeFloat(float value) {
        try {
            this.writer.value((double)value);
        }
        catch (IOException ignored) {
            throw new AssertionError();
        }
    }

    @Override
    public void writeDouble(double value) {
        try {
            this.writer.value(value);
        }
        catch (IOException ignored) {
            throw new AssertionError();
        }
    }

    @Override
    public void writeBytes(byte[] bytes, int off, int len) {
    }

    @Override
    public void writeBytes(byte[] bytes) {
        try {
            this.writer.value(Base64.getEncoder().encodeToString(bytes));
        }
        catch (IOException ignored) {
            throw new AssertionError();
        }
    }

    @Override
    public void writeString(String value) {
        try {
            this.writer.value(value);
        }
        catch (IOException ignored) {
            throw new AssertionError();
        }
    }

    @Override
    public void writeNull() {
        try {
            this.writer.nullValue();
        }
        catch (IOException ignored) {
            throw new AssertionError();
        }
    }

    @Override
    public <T> void writeNullable(StructuredEncoder<T> encoder, T value) {
        if (value != null) {
            encoder.encode(this, value);
        } else {
            this.writeNull();
        }
    }

    @Override
    public <T> void writeList(StructuredEncoder<T> encoder, List<T> list) {
        try {
            this.writer.beginArray();
            for (T item : list) {
                encoder.encode(this, item);
            }
            this.writer.endArray();
        }
        catch (IOException ignored) {
            throw new AssertionError();
        }
    }

    @Override
    public <K, V> void writeMap(StructuredEncoder<K> keyEncoder, StructuredEncoder<V> valueEncoder, Map<K, V> map) {
        try {
            if (keyEncoder == StructuredCodecs.STRING_CODEC) {
                this.writer.beginObject();
                for (Map.Entry<K, V> entry : map.entrySet()) {
                    this.writer.name((String)entry.getKey());
                    valueEncoder.encode(this, entry.getValue());
                }
                this.writer.endObject();
            } else {
                this.writer.beginArray();
                for (Map.Entry<K, V> entry : map.entrySet()) {
                    this.writer.beginArray();
                    keyEncoder.encode(this, entry.getKey());
                    valueEncoder.encode(this, entry.getValue());
                    this.writer.endArray();
                }
                this.writer.endArray();
            }
        }
        catch (IOException ignored) {
            throw new AssertionError();
        }
    }

    @Override
    public <T> void writeTuple(StructuredEncoder<T> encoder, T value) {
        try {
            this.writer.beginArray();
            encoder.encode(this, value);
            this.writer.endArray();
        }
        catch (IOException ignored) {
            throw new AssertionError();
        }
    }

    @Override
    public <T> void writeObject(StructuredEncoder<T> encoder, T value) {
        try {
            this.writer.beginObject();
            encoder.encode(this, value);
            this.writer.endObject();
        }
        catch (IOException ignored) {
            throw new AssertionError();
        }
    }

    @Override
    public void writeKey(String field) {
        try {
            this.writer.name(field);
        }
        catch (IOException ignored) {
            throw new AssertionError();
        }
    }

    @Override
    public <T> void writeCustom(Type type, T value) {
        throw new UnsupportedOperationException("No custom type writers");
    }
}

