/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.codec.json;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import io.datakernel.codec.StructuredCodecs;
import io.datakernel.codec.StructuredDecoder;
import io.datakernel.codec.StructuredInput;
import io.datakernel.exception.ParseException;
import io.datakernel.exception.UncheckedException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Base64;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class JsonStructuredInput
implements StructuredInput {
    private final JsonReader reader;

    public JsonStructuredInput(JsonReader reader) {
        this.reader = reader;
    }

    @Override
    public boolean readBoolean() throws ParseException {
        try {
            return this.reader.nextBoolean();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        catch (IllegalStateException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public byte readByte() throws ParseException {
        int n = this.readInt();
        if (n != (n & 0xFF)) {
            throw new ParseException("Expected byte, but was: " + n);
        }
        return (byte)n;
    }

    @Override
    public int readInt() throws ParseException {
        try {
            return this.reader.nextInt();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        catch (IllegalStateException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public long readLong() throws ParseException {
        try {
            return this.reader.nextLong();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        catch (IllegalStateException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public int readInt32() throws ParseException {
        return this.readInt();
    }

    @Override
    public long readLong64() throws ParseException {
        return this.readLong();
    }

    @Override
    public float readFloat() throws ParseException {
        return (float)this.readDouble();
    }

    @Override
    public double readDouble() throws ParseException {
        try {
            return this.reader.nextDouble();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        catch (IllegalStateException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public byte[] readBytes() throws ParseException {
        String str;
        try {
            str = this.reader.nextString();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        catch (IllegalStateException e) {
            throw new ParseException((Throwable)e);
        }
        try {
            return Base64.getDecoder().decode(str);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public String readString() throws ParseException {
        try {
            return this.reader.nextString();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        catch (IllegalStateException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public void readNull() throws ParseException {
        try {
            this.reader.nextNull();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        catch (IllegalStateException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public <T> T readNullable(StructuredDecoder<T> decoder) throws ParseException {
        try {
            if (this.reader.peek() == JsonToken.NULL) {
                this.reader.nextNull();
                return null;
            }
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        catch (IllegalStateException e) {
            throw new ParseException((Throwable)e);
        }
        return decoder.decode(this);
    }

    @Override
    public <T> T readTuple(StructuredDecoder<T> decoder) throws ParseException {
        try {
            this.reader.beginArray();
            T result = decoder.decode(this);
            this.reader.endArray();
            return result;
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        catch (IllegalStateException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public <T> T readObject(StructuredDecoder<T> decoder) throws ParseException {
        try {
            this.reader.beginObject();
            T result = decoder.decode(this);
            this.reader.endObject();
            return result;
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        catch (IllegalStateException e) {
            throw new ParseException((Throwable)e);
        }
        catch (UncheckedException e) {
            throw (ParseException)e.propagate(ParseException.class);
        }
    }

    @Override
    public <T> List<T> readList(StructuredDecoder<T> decoder) throws ParseException {
        try {
            ArrayList<T> list = new ArrayList<T>();
            this.reader.beginArray();
            while (this.reader.hasNext()) {
                T item = decoder.decode(this);
                list.add(item);
            }
            this.reader.endArray();
            return list;
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        catch (IllegalStateException e) {
            throw new ParseException((Throwable)e);
        }
        catch (UncheckedException e) {
            throw (ParseException)e.propagate(ParseException.class);
        }
    }

    @Override
    public <K, V> Map<K, V> readMap(StructuredDecoder<K> keyDecoder, StructuredDecoder<V> valueDecoder) throws ParseException {
        try {
            LinkedHashMap<String, V> map = new LinkedHashMap<String, V>();
            if (keyDecoder == StructuredCodecs.STRING_CODEC) {
                this.reader.beginObject();
                while (this.reader.hasNext()) {
                    String key = this.reader.nextName();
                    V value = valueDecoder.decode(this);
                    map.put(key, value);
                }
                this.reader.endObject();
            } else {
                this.reader.beginArray();
                while (this.reader.hasNext()) {
                    this.reader.beginArray();
                    K key = keyDecoder.decode(this);
                    V value = valueDecoder.decode(this);
                    map.put((String)key, value);
                    this.reader.endArray();
                }
                this.reader.endArray();
            }
            return map;
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        catch (IllegalStateException e) {
            throw new ParseException((Throwable)e);
        }
        catch (UncheckedException e) {
            throw (ParseException)e.propagate(ParseException.class);
        }
    }

    @Override
    public boolean hasNext() throws ParseException {
        try {
            JsonToken token = this.reader.peek();
            return token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT;
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        catch (IllegalStateException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public String readKey() throws ParseException {
        try {
            return this.reader.nextName();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        catch (IllegalStateException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public <T> T readCustom(Type type) throws ParseException {
        throw new UnsupportedOperationException("No custom type readers");
    }

    @Override
    public EnumSet<StructuredInput.Token> getNext() throws ParseException {
        JsonToken jsonToken;
        try {
            jsonToken = this.reader.peek();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        catch (IllegalStateException e) {
            throw new ParseException((Throwable)e);
        }
        switch (jsonToken) {
            case NULL: {
                return EnumSet.of(StructuredInput.Token.NULL);
            }
            case BOOLEAN: {
                return EnumSet.of(StructuredInput.Token.BOOLEAN);
            }
            case NUMBER: {
                return EnumSet.of(StructuredInput.Token.BYTE, StructuredInput.Token.INT, StructuredInput.Token.LONG, StructuredInput.Token.FLOAT, StructuredInput.Token.DOUBLE);
            }
            case STRING: {
                return EnumSet.of(StructuredInput.Token.STRING, StructuredInput.Token.BYTES);
            }
            case BEGIN_ARRAY: {
                return EnumSet.of(StructuredInput.Token.LIST, StructuredInput.Token.TUPLE);
            }
            case BEGIN_OBJECT: {
                return EnumSet.of(StructuredInput.Token.MAP, StructuredInput.Token.OBJECT);
            }
        }
        throw new ParseException("Invalid token: " + jsonToken);
    }
}

