/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.codec.binary;

import io.datakernel.bytebuf.ByteBuf;
import io.datakernel.bytebuf.ByteBufPool;
import io.datakernel.codec.StructuredDecoder;
import io.datakernel.codec.StructuredEncoder;
import io.datakernel.codec.binary.BinaryStructuredInput;
import io.datakernel.codec.binary.BinaryStructuredOutput;
import io.datakernel.exception.ParseException;

public final class BinaryUtils {
    private BinaryUtils() {
    }

    public static <T> T decode(StructuredDecoder<T> decoder, byte[] bytes) throws ParseException {
        return BinaryUtils.decode(decoder, ByteBuf.wrapForReading((byte[])bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T decode(StructuredDecoder<T> decoder, ByteBuf buf) throws ParseException {
        try {
            BinaryStructuredInput in = new BinaryStructuredInput(buf);
            T result = decoder.decode(in);
            if (buf.readRemaining() != 0) {
                throw new ParseException("Byte buffer was not fully consumed when decoding");
            }
            T t = result;
            return t;
        }
        finally {
            buf.recycle();
        }
    }

    public static <T> ByteBuf encode(StructuredEncoder<T> encoder, T item) {
        BinaryStructuredOutput out = new BinaryStructuredOutput();
        encoder.encode(out, item);
        return out.getBuf();
    }

    public static <T> byte[] encodeAsArray(StructuredEncoder<T> encoder, T item) {
        return BinaryUtils.encode(encoder, item).asArray();
    }

    public static <T> void encodeInto(StructuredEncoder<T> encoder, T item, ByteBuf dest) {
        ByteBuf encoded = BinaryUtils.encode(encoder, item);
        dest.write(encoded.array(), encoded.head(), encoded.readRemaining());
    }

    public static <T> ByteBuf encodeWithSizePrefix(StructuredEncoder<T> encoder, T item) {
        BinaryStructuredOutput out = new BinaryStructuredOutput();
        encoder.encode(out, item);
        ByteBuf buf = ByteBufPool.allocate((int)(out.getBuf().readRemaining() + 5));
        buf.writeVarInt(out.getBuf().readRemaining());
        buf.write(out.getBuf().array(), out.getBuf().head(), out.getBuf().readRemaining());
        out.getBuf().recycle();
        return buf;
    }
}

