/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.codec;

import io.datakernel.codec.StructuredEncoder;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public interface StructuredOutput {
    public void writeNull();

    public void writeBoolean(boolean var1);

    public void writeByte(byte var1);

    public void writeInt(int var1);

    public void writeLong(long var1);

    public void writeInt32(int var1);

    public void writeLong64(long var1);

    public void writeFloat(float var1);

    public void writeDouble(double var1);

    default public void writeBytes(byte[] bytes) {
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void writeBytes(byte[] var1, int var2, int var3);

    public void writeString(String var1);

    public <T> void writeNullable(StructuredEncoder<T> var1, @Nullable T var2);

    public <T> void writeList(StructuredEncoder<T> var1, List<T> var2);

    public <K, V> void writeMap(StructuredEncoder<K> var1, StructuredEncoder<V> var2, Map<K, V> var3);

    public <T> void writeTuple(StructuredEncoder<T> var1, T var2);

    public <T> void writeObject(StructuredEncoder<T> var1, T var2);

    default public void writeTuple(Runnable encoder) {
        this.writeTuple((o1, v1) -> encoder.run(), null);
    }

    default public void writeObject(Runnable encoder) {
        this.writeObject((o1, v1) -> encoder.run(), null);
    }

    public void writeKey(String var1);

    default public <T> void writeKey(String field, StructuredEncoder<? super T> encoder, T value) {
        this.writeKey(field);
        encoder.encode(this, value);
    }

    public <T> void writeCustom(Type var1, T var2);
}

