/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.codec;

import io.datakernel.codec.StructuredOutput;
import java.util.List;

public interface StructuredEncoder<T> {
    public void encode(StructuredOutput var1, T var2);

    public static <T> StructuredEncoder<T> ofObject(StructuredEncoder<T> encoder) {
        return (out, item) -> out.writeObject(encoder, item);
    }

    public static <T> StructuredEncoder<T> ofObject() {
        return StructuredEncoder.ofObject((out, item) -> {});
    }

    public static <T> StructuredEncoder<T> ofTuple(StructuredEncoder<T> encoder) {
        return (out, item) -> out.writeTuple(encoder, item);
    }

    public static <T> StructuredEncoder<List<T>> ofList(StructuredEncoder<T> encoder) {
        return (out, list) -> out.writeList(encoder, list);
    }
}

