/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.codec;

import io.datakernel.codec.StructuredCodecs;
import io.datakernel.codec.StructuredDecoder;
import io.datakernel.codec.StructuredEncoder;
import io.datakernel.codec.StructuredInput;
import io.datakernel.codec.StructuredOutput;
import io.datakernel.exception.ParseException;
import io.datakernel.exception.UncheckedException;
import io.datakernel.util.ParserFunction;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public interface StructuredCodec<T>
extends StructuredEncoder<T>,
StructuredDecoder<T> {
    public static <T> StructuredCodec<T> of(final StructuredDecoder<T> decoder, final StructuredEncoder<T> encoder) {
        return new StructuredCodec<T>(){

            @Override
            public void encode(StructuredOutput out, T item) {
                encoder.encode(out, item);
            }

            @Override
            public T decode(StructuredInput in) throws ParseException {
                return decoder.decode(in);
            }
        };
    }

    public static <T> StructuredCodec<T> ofObject(StructuredDecoder<T> decoder, StructuredEncoder<T> encoder) {
        return StructuredCodec.of(StructuredDecoder.ofObject(decoder), StructuredEncoder.ofObject(encoder));
    }

    public static <T> StructuredCodec<T> ofObject(Supplier<T> supplier) {
        return StructuredCodec.of(StructuredDecoder.ofObject(supplier), StructuredEncoder.ofObject());
    }

    public static <T> StructuredCodec<T> ofTuple(StructuredDecoder<T> decoder, StructuredEncoder<T> encoder) {
        return StructuredCodec.of(StructuredDecoder.ofTuple(decoder), StructuredEncoder.ofTuple(encoder));
    }

    default public StructuredCodec<@Nullable T> nullable() {
        return new StructuredCodec<T>(){

            @Override
            @Nullable
            public T decode(StructuredInput in) throws ParseException {
                return in.readNullable(StructuredCodec.this);
            }

            @Override
            public void encode(StructuredOutput out, T item) {
                out.writeNullable(StructuredCodec.this, item);
            }
        };
    }

    default public StructuredCodec<List<T>> ofList() {
        return StructuredCodecs.ofList(this);
    }

    default public <R> StructuredCodec<R> transform(final ParserFunction<T, R> reader, final Function<R, T> writer) {
        return new StructuredCodec<R>(){

            @Override
            public void encode(StructuredOutput out, R value) {
                Object result = writer.apply(value);
                StructuredCodec.this.encode(out, result);
            }

            @Override
            public R decode(StructuredInput in) throws ParseException {
                Object result = StructuredCodec.this.decode(in);
                try {
                    return reader.parse(result);
                }
                catch (UncheckedException u) {
                    throw (ParseException)u.propagate(ParseException.class);
                }
            }
        };
    }
}

