/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.codec;

import io.datakernel.codec.StructuredCodec;
import io.datakernel.codec.StructuredInput;
import io.datakernel.codec.StructuredOutput;
import io.datakernel.exception.ParseException;
import io.datakernel.util.Initializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public final class CodecSubtype<T>
implements Initializable<CodecSubtype<T>>,
StructuredCodec<T> {
    private final Map<String, StructuredCodec<? extends T>> namesToAdapters = new HashMap<String, StructuredCodec<? extends T>>();
    private final Map<Type, String> subtypesToNames = new HashMap<Type, String>();

    private CodecSubtype() {
    }

    public static <T> CodecSubtype<T> create() {
        return new CodecSubtype<T>();
    }

    public CodecSubtype<T> with(Type type, String name, StructuredCodec<? extends T> adapter) {
        this.namesToAdapters.put(name, adapter);
        this.subtypesToNames.put(type, name);
        return this;
    }

    public CodecSubtype<T> with(Type type, StructuredCodec<? extends T> adapter) {
        String name = type.getTypeName();
        name = name.substring(Math.max(name.lastIndexOf(46), name.lastIndexOf(36)) + 1);
        return this.with(type, name, adapter);
    }

    @Override
    public void encode(StructuredOutput out, T value) {
        out.writeObject(() -> {
            String field = this.subtypesToNames.get(value.getClass());
            if (field == null) {
                throw new IllegalArgumentException("Unregistered data type: " + value.getClass().getName());
            }
            StructuredCodec<Object> codec = this.namesToAdapters.get(field);
            out.writeKey(field);
            codec.encode(out, value);
        });
    }

    @Override
    public T decode(StructuredInput in) throws ParseException {
        return (T)in.readObject($ -> {
            String key = in.readKey();
            StructuredCodec<T> codec = this.namesToAdapters.get(key);
            if (codec == null) {
                throw new ParseException("Could not find codec for: " + key);
            }
            return codec.decode(in);
        });
    }
}

