/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.aggregation.ot;

import io.datakernel.aggregation.ChunkIdCodec;
import io.datakernel.aggregation.fieldtype.FieldType;
import io.datakernel.aggregation.measure.Measure;
import io.datakernel.common.Initializable;
import io.datakernel.common.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AggregationStructure
implements Initializable<AggregationStructure> {
    private final ChunkIdCodec<?> chunkIdCodec;
    private final Map<String, FieldType> keyTypes = new LinkedHashMap<String, FieldType>();
    private final Map<String, FieldType> measureTypes = new LinkedHashMap<String, FieldType>();
    private final List<String> partitioningKey = new ArrayList<String>();
    private final Map<String, Measure> measures = new LinkedHashMap<String, Measure>();

    private AggregationStructure(ChunkIdCodec<?> chunkIdCodec) {
        this.chunkIdCodec = chunkIdCodec;
    }

    public static AggregationStructure create(ChunkIdCodec<?> chunkIdCodec) {
        return new AggregationStructure(chunkIdCodec);
    }

    public AggregationStructure withKey(String keyId, FieldType type) {
        Preconditions.checkArgument((!this.keyTypes.containsKey(keyId) ? 1 : 0) != 0, (String)"Key '%s' has already been added", (Object[])new Object[]{keyId});
        this.keyTypes.put(keyId, type);
        return this;
    }

    public AggregationStructure withMeasure(String measureId, Measure aggregateFunction) {
        Preconditions.checkArgument((!this.measureTypes.containsKey(measureId) ? 1 : 0) != 0, (String)"Measure '%s' has already been added", (Object[])new Object[]{measureId});
        this.measureTypes.put(measureId, aggregateFunction.getFieldType());
        this.measures.put(measureId, aggregateFunction);
        return this;
    }

    public AggregationStructure withIgnoredMeasure(String measureId, FieldType measureType) {
        Preconditions.checkArgument((!this.measureTypes.containsKey(measureId) ? 1 : 0) != 0, (String)"Measure '%s' has already been added", (Object[])new Object[]{measureId});
        this.measureTypes.put(measureId, measureType);
        return this;
    }

    public AggregationStructure withPartitioningKey(List<String> partitioningKey) {
        this.partitioningKey.addAll(partitioningKey);
        return this;
    }

    public ChunkIdCodec<?> getChunkIdCodec() {
        return this.chunkIdCodec;
    }

    public AggregationStructure withPartitioningKey(String ... partitioningKey) {
        this.partitioningKey.addAll(Arrays.asList(partitioningKey));
        return this;
    }

    public List<String> getKeys() {
        return new ArrayList<String>(this.keyTypes.keySet());
    }

    public List<String> getMeasures() {
        return new ArrayList<String>(this.measures.keySet());
    }

    public Map<String, FieldType> getKeyTypes() {
        return this.keyTypes;
    }

    public Map<String, FieldType> getMeasureTypes() {
        return this.measureTypes;
    }

    public Measure getMeasure(String field) {
        return this.measures.get(field);
    }

    public FieldType getKeyType(String key) {
        return this.keyTypes.get(key);
    }

    public FieldType getMeasureType(String field) {
        return this.measureTypes.get(field);
    }

    public List<String> getPartitioningKey() {
        return this.partitioningKey;
    }
}

