/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.aggregation.ot;

import io.datakernel.aggregation.AggregationChunk;
import io.datakernel.aggregation.AggregationChunkCodec;
import io.datakernel.aggregation.AggregationUtils;
import io.datakernel.aggregation.PrimaryKey;
import io.datakernel.aggregation.ot.AggregationDiff;
import io.datakernel.aggregation.ot.AggregationStructure;
import io.datakernel.codec.StructuredCodec;
import io.datakernel.codec.StructuredCodecs;
import io.datakernel.codec.StructuredInput;
import io.datakernel.codec.StructuredOutput;
import io.datakernel.codec.json.JsonUtils;
import io.datakernel.common.parse.ParseException;
import java.util.Collections;
import java.util.Set;

public class AggregationDiffCodec
implements StructuredCodec<AggregationDiff> {
    public static final String ADDED = "added";
    public static final String REMOVED = "removed";
    private final StructuredCodec<Set<AggregationChunk>> aggregationChunksCodec;

    private AggregationDiffCodec(AggregationChunkCodec aggregationChunksCodec) {
        this.aggregationChunksCodec = StructuredCodecs.ofSet((StructuredCodec)JsonUtils.oneline((StructuredCodec)aggregationChunksCodec));
    }

    public static AggregationDiffCodec create(AggregationStructure structure) {
        Set<String> allowedMeasures = structure.getMeasureTypes().keySet();
        StructuredCodec<PrimaryKey> primaryKeyCodec = AggregationUtils.getPrimaryKeyCodec(structure);
        return new AggregationDiffCodec(AggregationChunkCodec.create(structure.getChunkIdCodec(), primaryKeyCodec, allowedMeasures));
    }

    public void encode(StructuredOutput out, AggregationDiff diff) {
        out.writeObject(() -> {
            out.writeKey(ADDED);
            this.aggregationChunksCodec.encode(out, diff.getAddedChunks());
            if (!diff.getRemovedChunks().isEmpty()) {
                out.writeKey(REMOVED);
                this.aggregationChunksCodec.encode(out, diff.getRemovedChunks());
            }
        });
    }

    public AggregationDiff decode(StructuredInput in) throws ParseException {
        return (AggregationDiff)in.readObject($ -> {
            in.readKey(ADDED);
            Set added = (Set)this.aggregationChunksCodec.decode(in);
            Set removed = Collections.emptySet();
            if (in.hasNext()) {
                in.readKey(REMOVED);
                removed = (Set)this.aggregationChunksCodec.decode(in);
            }
            return AggregationDiff.of(added, removed);
        });
    }
}

