/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.aggregation.measure;

import io.datakernel.aggregation.fieldtype.FieldType;
import io.datakernel.aggregation.measure.HyperLogLog;
import io.datakernel.aggregation.measure.Measure;
import io.datakernel.codec.StructuredCodecs;
import io.datakernel.codegen.Context;
import io.datakernel.codegen.Expression;
import io.datakernel.codegen.Expressions;
import io.datakernel.codegen.StoreDef;
import io.datakernel.codegen.Utils;
import io.datakernel.codegen.Variable;
import io.datakernel.serializer.asm.SerializerGen;
import io.datakernel.serializer.asm.SerializerGenArray;
import io.datakernel.serializer.asm.SerializerGenByte;
import io.datakernel.serializer.asm.SerializerGenClass;
import java.util.Collections;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

public final class MeasureHyperLogLog
extends Measure {
    private final int registers;

    MeasureHyperLogLog(int registers) {
        super(new FieldTypeHyperLogLog());
        this.registers = registers;
    }

    public static MeasureHyperLogLog create(int registers) {
        return new MeasureHyperLogLog(registers);
    }

    @Override
    public Expression valueOfAccumulator(Expression accumulator) {
        return Expressions.call((Expression)accumulator, (String)"estimate", (Expression[])new Expression[0]);
    }

    @Override
    public Expression zeroAccumulator(Variable accumulator) {
        return Expressions.set((StoreDef)accumulator, (Expression)Expressions.constructor(HyperLogLog.class, (Expression[])new Expression[]{Expressions.value((Object)this.registers)}));
    }

    @Override
    public Expression initAccumulatorWithAccumulator(Variable accumulator, Expression firstAccumulator) {
        return Expressions.sequence((Expression[])new Expression[]{Expressions.set((StoreDef)accumulator, (Expression)Expressions.constructor(HyperLogLog.class, (Expression[])new Expression[]{Expressions.value((Object)this.registers)})), Expressions.call((Expression)accumulator, (String)"union", (Expression[])new Expression[]{firstAccumulator})});
    }

    @Override
    public Expression reduce(Variable accumulator, Variable nextAccumulator) {
        return Expressions.call((Expression)accumulator, (String)"union", (Expression[])new Expression[]{nextAccumulator});
    }

    @Override
    public Expression initAccumulatorWithValue(Variable accumulator, Variable firstValue) {
        return Expressions.sequence((Expression[])new Expression[]{Expressions.set((StoreDef)accumulator, (Expression)Expressions.constructor(HyperLogLog.class, (Expression[])new Expression[]{Expressions.value((Object)this.registers)})), MeasureHyperLogLog.add((Expression)accumulator, (Expression)firstValue)});
    }

    @Override
    public Expression accumulate(Variable accumulator, Variable nextValue) {
        return MeasureHyperLogLog.add((Expression)accumulator, (Expression)nextValue);
    }

    private static Expression add(Expression accumulator, Expression value) {
        return new ExpressionHyperLogLog(value, accumulator);
    }

    private static class ExpressionHyperLogLog
    implements Expression {
        private final Expression value;
        private final Expression accumulator;

        public ExpressionHyperLogLog(Expression value, Expression accumulator) {
            this.value = value;
            this.accumulator = accumulator;
        }

        public Type load(Context ctx) {
            Type methodParameterType;
            String methodName;
            GeneratorAdapter g = ctx.getGeneratorAdapter();
            Type accumulatorType = this.accumulator.load(ctx);
            Type valueType = this.value.load(ctx);
            if (valueType == Type.LONG_TYPE || valueType.getClassName().equals(Long.class.getName())) {
                methodName = "addLong";
                methodParameterType = Type.LONG_TYPE;
            } else if (valueType == Type.INT_TYPE || valueType.getClassName().equals(Integer.class.getName())) {
                methodName = "addInt";
                methodParameterType = Type.INT_TYPE;
            } else {
                methodName = "addObject";
                methodParameterType = Type.getType(Object.class);
            }
            if (Utils.isWrapperType((Type)valueType)) {
                g.unbox(methodParameterType);
            }
            ctx.invoke(accumulatorType, methodName, new Type[]{methodParameterType});
            return Type.VOID_TYPE;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExpressionHyperLogLog that = (ExpressionHyperLogLog)o;
            return this.value.equals((Object)that.value) && this.accumulator.equals((Object)that.accumulator);
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = 31 * result + this.accumulator.hashCode();
            return result;
        }
    }

    private static final class FieldTypeHyperLogLog
    extends FieldType<Integer> {
        public FieldTypeHyperLogLog() {
            super(HyperLogLog.class, Integer.TYPE, FieldTypeHyperLogLog.serializerGen(), StructuredCodecs.INT_CODEC, null);
        }

        private static SerializerGen serializerGen() {
            SerializerGenClass serializerGenClass = new SerializerGenClass(HyperLogLog.class);
            try {
                serializerGenClass.addGetter(HyperLogLog.class.getMethod("getRegisters", new Class[0]), (SerializerGen)new SerializerGenArray((SerializerGen)new SerializerGenByte(), byte[].class), -1, -1);
                serializerGenClass.setConstructor(HyperLogLog.class.getConstructor(byte[].class), Collections.singletonList("registers"));
            }
            catch (NoSuchMethodException ignored) {
                throw new RuntimeException("Unable to construct SerializerGen for HyperLogLog");
            }
            return serializerGenClass;
        }
    }
}

