/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.aggregation.measure;

import io.datakernel.common.HashUtils;

public final class HyperLogLog
implements Comparable<HyperLogLog> {
    private final byte[] registers;
    private static final double ALPHA_16 = 172.288;
    private static final double ALPHA_32 = 713.728;
    private static final double ALPHA_64 = 2904.064;
    private static final double ALPHA_XX = 0.7213;
    private static final double NLOG2 = -Math.log(2.0);

    public HyperLogLog(int registers) {
        this.registers = new byte[registers];
    }

    public HyperLogLog(byte[] registers) {
        this.registers = registers;
    }

    public byte[] getRegisters() {
        return this.registers;
    }

    public static HyperLogLog union(HyperLogLog a, HyperLogLog b) {
        assert (a.registers.length == b.registers.length);
        byte[] buckets = new byte[a.registers.length];
        for (int i = 0; i < a.registers.length; ++i) {
            buckets[i] = a.registers[i] > b.registers[i] ? a.registers[i] : b.registers[i];
        }
        return new HyperLogLog(buckets);
    }

    public void union(HyperLogLog another) {
        assert (this.registers.length == another.registers.length);
        for (int i = 0; i < this.registers.length; ++i) {
            byte thatValue = another.registers[i];
            byte thisValue = this.registers[i];
            if (thatValue <= thisValue) continue;
            this.registers[i] = thatValue;
        }
    }

    public void addToRegister(int register, int valueHash) {
        int zeros = Integer.numberOfTrailingZeros(valueHash) + 1;
        if (this.registers[register] < zeros) {
            this.registers[register] = (byte)zeros;
        }
    }

    public void addLongHash(long longHash) {
        this.addToRegister((int)longHash & this.registers.length - 1, (int)(longHash >>> 32));
    }

    public void addObject(Object item) {
        this.addInt(item.hashCode());
    }

    public void addLong(long value) {
        this.addLongHash(HashUtils.murmur3hash((long)value));
    }

    public void addInt(int value) {
        this.addLongHash(HashUtils.murmur3hash((int)value));
    }

    public int estimate() {
        int m = this.registers.length;
        double alpha = m == 16 ? 172.288 : (m == 32 ? 713.728 : (m == 64 ? 2904.064 : 0.7213 / (1.0 + 1.079 / (double)m) * (double)m * (double)m));
        double sum = 0.0;
        for (byte value : this.registers) {
            sum += Math.exp((double)value * NLOG2);
        }
        double estimate = alpha / sum;
        if (estimate < 2.5 * (double)m) {
            int zeroCount = 0;
            for (byte bucket : this.registers) {
                if (bucket != 0) continue;
                ++zeroCount;
            }
            if (zeroCount != 0) {
                estimate = (double)m * Math.log((double)m / (double)zeroCount);
            }
        }
        return (int)estimate;
    }

    @Override
    public int compareTo(HyperLogLog that) {
        return Integer.compare(this.estimate(), that.estimate());
    }
}

