/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.aggregation.fieldtype;

import io.datakernel.aggregation.fieldtype.FieldType;
import io.datakernel.codec.StructuredCodec;
import io.datakernel.codec.StructuredCodecs;
import io.datakernel.codec.StructuredInput;
import io.datakernel.codec.StructuredOutput;
import io.datakernel.codegen.Expression;
import io.datakernel.codegen.Expressions;
import io.datakernel.codegen.utils.Primitives;
import io.datakernel.common.parse.ParseException;
import io.datakernel.common.reflection.RecursiveType;
import io.datakernel.serializer.StringFormat;
import io.datakernel.serializer.asm.SerializerGen;
import io.datakernel.serializer.asm.SerializerGenByte;
import io.datakernel.serializer.asm.SerializerGenDouble;
import io.datakernel.serializer.asm.SerializerGenEnum;
import io.datakernel.serializer.asm.SerializerGenFloat;
import io.datakernel.serializer.asm.SerializerGenInt;
import io.datakernel.serializer.asm.SerializerGenLong;
import io.datakernel.serializer.asm.SerializerGenSet;
import io.datakernel.serializer.asm.SerializerGenShort;
import io.datakernel.serializer.asm.SerializerGenString;
import java.lang.reflect.Type;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Set;

public final class FieldTypes {
    public static final StructuredCodec<LocalDate> LOCAL_DATE_CODEC = new StructuredCodec<LocalDate>(){

        public void encode(StructuredOutput out, LocalDate value) {
            out.writeString(value.toString());
        }

        public LocalDate decode(StructuredInput in) throws ParseException {
            try {
                return LocalDate.parse(in.readString());
            }
            catch (DateTimeException e) {
                throw new ParseException((Throwable)e);
            }
        }
    };

    public static FieldType<Byte> ofByte() {
        return new FieldType<Byte>(Byte.TYPE, (SerializerGen)new SerializerGenByte(), StructuredCodecs.BYTE_CODEC);
    }

    public static FieldType<Short> ofShort() {
        return new FieldType<Short>(Short.TYPE, (SerializerGen)new SerializerGenShort(), StructuredCodecs.SHORT_CODEC);
    }

    public static FieldType<Integer> ofInt() {
        return new FieldType<Integer>(Integer.TYPE, (SerializerGen)new SerializerGenInt(true), StructuredCodecs.INT_CODEC);
    }

    public static FieldType<Long> ofLong() {
        return new FieldType<Long>(Long.TYPE, (SerializerGen)new SerializerGenLong(true), StructuredCodecs.LONG_CODEC);
    }

    public static FieldType<Float> ofFloat() {
        return new FieldType<Float>(Float.TYPE, (SerializerGen)new SerializerGenFloat(), StructuredCodecs.FLOAT_CODEC);
    }

    public static FieldType<Double> ofDouble() {
        return new FieldType<Double>(Double.TYPE, (SerializerGen)new SerializerGenDouble(), StructuredCodecs.DOUBLE_CODEC);
    }

    public static <T> FieldType<Set<T>> ofSet(FieldType<T> fieldType) {
        SerializerGenSet serializer = new SerializerGenSet(fieldType.getSerializer());
        Type wrappedNestedType = fieldType.getDataType() instanceof Class ? Primitives.wrap((Class)((Class)fieldType.getDataType())) : fieldType.getDataType();
        Type dataType = RecursiveType.of(Set.class, (RecursiveType[])new RecursiveType[]{RecursiveType.of((Type)wrappedNestedType)}).getType();
        StructuredCodec codec = StructuredCodecs.ofSet(fieldType.getCodec());
        return new FieldType<Set<T>>(Set.class, dataType, (SerializerGen)serializer, codec, codec);
    }

    public static <E extends Enum<E>> FieldType<E> ofEnum(Class<E> enumClass) {
        return new FieldType<E>(enumClass, (SerializerGen)new SerializerGenEnum(enumClass), StructuredCodecs.ofEnum(enumClass));
    }

    public static FieldType<String> ofString() {
        return new FieldType<String>(String.class, (SerializerGen)new SerializerGenString(), StructuredCodecs.STRING_CODEC);
    }

    public static FieldType<String> ofString(StringFormat format) {
        return new FieldType<String>(String.class, (SerializerGen)new SerializerGenString(format), StructuredCodecs.STRING_CODEC);
    }

    public static FieldType<LocalDate> ofLocalDate() {
        return new FieldTypeDate();
    }

    public static FieldType<LocalDate> ofLocalDate(LocalDate startDate) {
        return new FieldTypeDate(startDate);
    }

    private static final class FieldTypeDate
    extends FieldType<LocalDate> {
        private final LocalDate startDate;

        FieldTypeDate() {
            this(LocalDate.parse("1970-01-01"));
        }

        FieldTypeDate(LocalDate startDate) {
            super(Integer.TYPE, (Type)((Object)LocalDate.class), (SerializerGen)new SerializerGenInt(true), LOCAL_DATE_CODEC, (StructuredCodec<?>)StructuredCodecs.INT_CODEC);
            this.startDate = startDate;
        }

        @Override
        public Expression toValue(Expression internalValue) {
            return Expressions.call((Expression)Expressions.value((Object)this.startDate), (String)"plusDays", (Expression[])new Expression[]{Expressions.cast((Expression)internalValue, Long.TYPE)});
        }

        @Override
        public Object toInternalValue(LocalDate value) {
            return (int)ChronoUnit.DAYS.between(this.startDate, value);
        }
    }
}

