/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.aggregation;

import io.datakernel.aggregation.Aggregate;
import io.datakernel.aggregation.PrimaryKey;
import io.datakernel.aggregation.annotation.Key;
import io.datakernel.aggregation.annotation.Measures;
import io.datakernel.aggregation.fieldtype.FieldType;
import io.datakernel.aggregation.measure.Measure;
import io.datakernel.aggregation.ot.AggregationStructure;
import io.datakernel.aggregation.util.PartitionPredicate;
import io.datakernel.codec.StructuredCodec;
import io.datakernel.codec.StructuredCodecs;
import io.datakernel.codegen.ClassBuilder;
import io.datakernel.codegen.DefiningClassLoader;
import io.datakernel.codegen.Expression;
import io.datakernel.codegen.Expressions;
import io.datakernel.codegen.StoreDef;
import io.datakernel.common.Preconditions;
import io.datakernel.common.collection.CollectionUtils;
import io.datakernel.datastream.processor.StreamReducers;
import io.datakernel.eventloop.util.ReflectionUtils;
import io.datakernel.serializer.BinarySerializer;
import io.datakernel.serializer.SerializerBuilder;
import io.datakernel.serializer.asm.SerializerGen;
import io.datakernel.serializer.asm.SerializerGenClass;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public class AggregationUtils {
    private static final PartitionPredicate SINGLE_PARTITION = (t, u) -> true;

    private AggregationUtils() {
    }

    public static <K extends Comparable> Class<K> createKeyClass(Map<String, FieldType> keys, DefiningClassLoader classLoader) {
        ArrayList<String> keyList = new ArrayList<String>(keys.keySet());
        return ((ClassBuilder)ClassBuilder.create((DefiningClassLoader)classLoader, Comparable.class).initialize(cb -> keys.forEach((key, value) -> cb.withField(key, value.getInternalDataType())))).withMethod("compareTo", Expressions.compareToImpl(keyList)).withMethod("equals", Expressions.equalsImpl(keyList)).withMethod("hashCode", Expressions.hashCodeImpl(keyList)).withMethod("toString", Expressions.toStringImpl(keyList)).build();
    }

    public static <R> Comparator<R> createKeyComparator(Class<R> recordClass, List<String> keys, DefiningClassLoader classLoader) {
        return (Comparator)ClassBuilder.create((DefiningClassLoader)classLoader, Comparator.class).withMethod("compare", Expressions.compare(recordClass, keys)).buildClassAndCreateNewInstance();
    }

    public static <T, R> Function<T, R> createMapper(Class<T> recordClass, Class<R> resultClass, List<String> keys, List<String> fields, DefiningClassLoader classLoader) {
        return (Function)ClassBuilder.create((DefiningClassLoader)classLoader, Function.class).withMethod("apply", Expressions.let((Expression)Expressions.constructor(resultClass, (Expression[])new Expression[0]), result -> Expressions.sequence(expressions -> {
            for (String fieldName : Stream.concat(keys.stream(), fields.stream())::iterator) {
                expressions.add(Expressions.set((StoreDef)Expressions.property((Expression)result, (String)fieldName), (Expression)Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)0), (Class)recordClass), (String)fieldName)));
            }
            expressions.add(result);
        }))).buildClassAndCreateNewInstance();
    }

    public static <K extends Comparable, R> Function<R, K> createKeyFunction(Class<R> recordClass, Class<K> keyClass, List<String> keys, DefiningClassLoader classLoader) {
        return (Function)ClassBuilder.create((DefiningClassLoader)classLoader, Function.class).withMethod("apply", Expressions.let((Expression)Expressions.constructor(keyClass, (Expression[])new Expression[0]), key -> Expressions.sequence(expressions -> {
            for (String keyString : keys) {
                expressions.add(Expressions.set((StoreDef)Expressions.property((Expression)key, (String)keyString), (Expression)Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)0), (Class)recordClass), (String)keyString)));
            }
            expressions.add(key);
        }))).buildClassAndCreateNewInstance();
    }

    public static <T> Class<T> createRecordClass(AggregationStructure aggregation, Collection<String> keys, Collection<String> fields, DefiningClassLoader classLoader) {
        return AggregationUtils.createRecordClass(CollectionUtils.keysToMap(keys.stream(), aggregation.getKeyTypes()::get), CollectionUtils.keysToMap(fields.stream(), aggregation.getMeasureTypes()::get), classLoader);
    }

    public static <T> Class<T> createRecordClass(Map<String, FieldType> keys, Map<String, FieldType> fields, DefiningClassLoader classLoader) {
        return ((ClassBuilder)((ClassBuilder)ClassBuilder.create((DefiningClassLoader)classLoader, Object.class).initialize(cb -> keys.forEach((key, value) -> cb.withField(key, value.getInternalDataType())))).initialize(cb -> fields.forEach((key, value) -> cb.withField(key, value.getInternalDataType())))).withMethod("toString", Expressions.toStringImpl((List)CollectionUtils.concat(keys.keySet(), fields.keySet()))).build();
    }

    public static <T> BinarySerializer<T> createBinarySerializer(AggregationStructure aggregation, Class<T> recordClass, List<String> keys, List<String> fields, DefiningClassLoader classLoader) {
        return AggregationUtils.createBinarySerializer(recordClass, CollectionUtils.keysToMap(keys.stream(), aggregation.getKeyTypes()::get), CollectionUtils.keysToMap(fields.stream(), aggregation.getMeasureTypes()::get), classLoader);
    }

    private static <T> BinarySerializer<T> createBinarySerializer(Class<T> recordClass, Map<String, FieldType> keys, Map<String, FieldType> fields, DefiningClassLoader classLoader) {
        SerializerGenClass serializerGenClass = new SerializerGenClass(recordClass);
        for (String key : keys.keySet()) {
            FieldType keyType = keys.get(key);
            try {
                Field recordClassKey = recordClass.getField(key);
                serializerGenClass.addField(recordClassKey, keyType.getSerializer(), -1, -1);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        for (String field : fields.keySet()) {
            try {
                Field recordClassField = recordClass.getField(field);
                serializerGenClass.addField(recordClassField, fields.get(field).getSerializer(), -1, -1);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        return SerializerBuilder.create((DefiningClassLoader)classLoader).build((SerializerGen)serializerGenClass);
    }

    public static <K extends Comparable, I, O, A> StreamReducers.Reducer<K, I, O, A> aggregationReducer(AggregationStructure aggregation, Class<I> inputClass, Class<O> outputClass, List<String> keys, List<String> fields, DefiningClassLoader classLoader) {
        return (StreamReducers.Reducer)ClassBuilder.create((DefiningClassLoader)classLoader, StreamReducers.Reducer.class).withMethod("onFirstItem", Expressions.let((Expression)Expressions.constructor(outputClass, (Expression[])new Expression[0]), accumulator -> Expressions.sequence(expressions -> {
            for (String key : keys) {
                expressions.add(Expressions.set((StoreDef)Expressions.property((Expression)accumulator, (String)key), (Expression)Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)2), (Class)inputClass), (String)key)));
            }
            for (String field : fields) {
                expressions.add(aggregation.getMeasure(field).initAccumulatorWithAccumulator(Expressions.property((Expression)accumulator, (String)field), (Expression)Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)2), (Class)inputClass), (String)field)));
            }
            expressions.add(accumulator);
        }))).withMethod("onNextItem", Expressions.sequence(expressions -> {
            for (String field : fields) {
                expressions.add(aggregation.getMeasure(field).reduce(Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)3), (Class)outputClass), (String)field), Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)2), (Class)inputClass), (String)field)));
            }
            expressions.add(Expressions.arg((int)3));
        })).withMethod("onComplete", Expressions.call((Expression)Expressions.arg((int)0), (String)"accept", (Expression[])new Expression[]{Expressions.arg((int)2)})).buildClassAndCreateNewInstance();
    }

    public static <I, O> Aggregate<O, Object> createPreaggregator(AggregationStructure aggregation, Class<I> inputClass, Class<O> outputClass, Map<String, String> keyFields, Map<String, String> measureFields, DefiningClassLoader classLoader) {
        return (Aggregate)ClassBuilder.create((DefiningClassLoader)classLoader, Aggregate.class).withMethod("createAccumulator", Expressions.let((Expression)Expressions.constructor(outputClass, (Expression[])new Expression[0]), accumulator -> Expressions.sequence(expressions -> {
            for (String key : keyFields.keySet()) {
                String inputField = (String)keyFields.get(key);
                expressions.add(Expressions.set((StoreDef)Expressions.property((Expression)accumulator, (String)key), (Expression)Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)0), (Class)inputClass), (String)inputField)));
            }
            for (String measure : measureFields.keySet()) {
                String inputFields = (String)measureFields.get(measure);
                Measure aggregateFunction = aggregation.getMeasure(measure);
                expressions.add(aggregateFunction.initAccumulatorWithValue(Expressions.property((Expression)accumulator, (String)measure), inputFields == null ? null : Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)0), (Class)inputClass), (String)inputFields)));
            }
            expressions.add(accumulator);
        }))).withMethod("accumulate", Expressions.sequence(expressions -> {
            for (String measure : measureFields.keySet()) {
                String inputFields = (String)measureFields.get(measure);
                Measure aggregateFunction = aggregation.getMeasure(measure);
                expressions.add(aggregateFunction.accumulate(Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)0), (Class)outputClass), (String)measure), inputFields == null ? null : Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)1), (Class)inputClass), (String)inputFields)));
            }
        })).buildClassAndCreateNewInstance();
    }

    public static <T> PartitionPredicate<T> singlePartition() {
        return SINGLE_PARTITION;
    }

    public static PartitionPredicate createPartitionPredicate(Class recordClass, List<String> partitioningKey, DefiningClassLoader classLoader) {
        if (partitioningKey.isEmpty()) {
            return AggregationUtils.singlePartition();
        }
        return (PartitionPredicate)ClassBuilder.create((DefiningClassLoader)classLoader, PartitionPredicate.class).withMethod("isSamePartition", (Expression)Expressions.and(partitioningKey.stream().map(keyComponent -> Expressions.cmpEq((Expression)Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)0), (Class)recordClass), (String)keyComponent), (Expression)Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)1), (Class)recordClass), (String)keyComponent))))).buildClassAndCreateNewInstance();
    }

    public static <T> Map<String, String> scanKeyFields(Class<T> inputClass) {
        String value;
        LinkedHashMap<String, String> keyFields = new LinkedHashMap<String, String>();
        for (Field field : inputClass.getFields()) {
            for (Annotation annotation : field.getAnnotations()) {
                if (annotation.annotationType() != Key.class) continue;
                value = ((Key)annotation).value();
                keyFields.put("".equals(value) ? field.getName() : value, field.getName());
            }
        }
        for (AccessibleObject accessibleObject : inputClass.getMethods()) {
            for (Annotation annotation : accessibleObject.getAnnotations()) {
                if (annotation.annotationType() != Key.class) continue;
                value = ((Key)annotation).value();
                keyFields.put("".equals(value) ? ((Method)accessibleObject).getName() : value, ((Method)accessibleObject).getName());
            }
        }
        Preconditions.checkArgument((!keyFields.isEmpty() ? 1 : 0) != 0, (String)"Missing @Key annotations in %s", (Object[])new Object[]{inputClass});
        return keyFields;
    }

    public static <T> Map<String, String> scanMeasureFields(Class<T> inputClass) {
        LinkedHashMap<String, String> measureFields = new LinkedHashMap<String, String>();
        for (Annotation annotation : inputClass.getAnnotations()) {
            if (annotation.annotationType() != Measures.class) continue;
            for (String string : ((Measures)annotation).value()) {
                measureFields.put(string, null);
            }
        }
        for (Field field : inputClass.getFields()) {
            for (Annotation annotation : field.getAnnotations()) {
                if (annotation.annotationType() != Measures.class) continue;
                for (String measure : ((Measures)annotation).value()) {
                    measureFields.put(measure.equals("") ? field.getName() : measure, field.getName());
                }
            }
        }
        for (Method method : inputClass.getMethods()) {
            for (Annotation annotation : method.getAnnotations()) {
                if (annotation.annotationType() != Measures.class) continue;
                for (String measure : ((Measures)annotation).value()) {
                    measureFields.put(measure.equals("") ? ReflectionUtils.extractFieldNameFromGetter((Method)method) : measure, method.getName());
                }
            }
        }
        Preconditions.checkArgument((!measureFields.isEmpty() ? 1 : 0) != 0, (String)"Missing @Measure(s) annotations in %s", (Object[])new Object[]{inputClass});
        return measureFields;
    }

    public static StructuredCodec<PrimaryKey> getPrimaryKeyCodec(AggregationStructure aggregation) {
        StructuredCodec[] keyCodec = new StructuredCodec[aggregation.getKeys().size()];
        for (int i = 0; i < aggregation.getKeys().size(); ++i) {
            String key = aggregation.getKeys().get(i);
            FieldType keyType = aggregation.getKeyTypes().get(key);
            keyCodec[i] = keyType.getInternalCodec();
        }
        return StructuredCodecs.ofTupleArray((StructuredCodec[])keyCodec).transform(PrimaryKey::ofArray, PrimaryKey::getArray);
    }
}

