package io.dangernoodle.scm.github.cli;

import java.io.File;
import java.io.FileReader;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.FileConverter;

import io.dangernoodle.Project;
import io.dangernoodle.github.GithubClient;
import io.dangernoodle.github.repo.setup.GithubRepositoryWorkflow;
import io.dangernoodle.github.repo.setup.settings.GithubRepositoryOverrideStore;
import io.dangernoodle.github.repo.setup.settings.GithubRepositorySettingsStore;
import io.dangernoodle.github.utils.GithubGsonTransformer;


public class ScmGithubCliTool
{
    public static void main(String... args) throws Exception
    {
        Parameters parameters = new Parameters();
        JCommander jCommander = new JCommander(parameters);
        jCommander.parse(args);

        GithubClient client = GithubClient.createClient(parameters.token);
        GithubRepositoryWorkflow workflow = new GithubRepositoryWorkflow(client);

        GithubGsonTransformer transformer = new GithubGsonTransformer();

        FileReader fileReader = new FileReader(parameters.file);
        Project project = transformer.deserialize(fileReader, Project.class);

        // TOOD: turn this into some kind of builder for project?
        if (parameters.defaults != null)
        {
            FileReader defaultsReader = new FileReader(parameters.defaults);

            GithubRepositorySettingsStore defaults = transformer.deserialize(defaultsReader, GithubRepositorySettingsStore.class);
            project.overrideSettings(new GithubRepositoryOverrideStore(defaults, project.getRepositorySettings()));
        }

        workflow.execute(project);
    }

    private static class Parameters
    {
        @Parameter(names = "--oauth", required = true)
        private String token;

        @Parameter(names = "--defaults", converter = FileConverter.class)
        private File defaults;

        @Parameter(names = "--file", required = true, converter = FileConverter.class)
        private File file;
    }
}
