/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.api.java.After;
import cucumber.api.java.AfterStep;
import cucumber.api.java.Before;
import cucumber.api.java.BeforeStep;
import cucumber.api.java.ObjectFactory;
import cucumber.api.java8.GlueBase;
import cucumber.runtime.Backend;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Env;
import cucumber.runtime.Glue;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.Utils;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.java.Function;
import cucumber.runtime.java.Java8Snippet;
import cucumber.runtime.java.JavaHookDefinition;
import cucumber.runtime.java.JavaSnippet;
import cucumber.runtime.java.JavaStepDefinition;
import cucumber.runtime.java.LambdaGlueRegistry;
import cucumber.runtime.java.MethodScanner;
import cucumber.runtime.java.ObjectFactoryLoader;
import cucumber.runtime.snippets.FunctionNameGenerator;
import cucumber.runtime.snippets.Snippet;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.pickles.PickleStep;
import io.cucumber.stepexpression.TypeRegistry;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JavaBackend
implements Backend,
LambdaGlueRegistry {
    private final SnippetGenerator snippetGenerator;
    private final TypeRegistry typeRegistry;
    private final ObjectFactory objectFactory;
    private final ClassFinder classFinder;
    private final MethodScanner methodScanner;
    private Glue glue;
    private List<Class<? extends GlueBase>> glueBaseClasses = new ArrayList<Class<? extends GlueBase>>();

    private Snippet createSnippet() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            classLoader.loadClass("cucumber.runtime.java8.LambdaGlueBase");
            return new Java8Snippet();
        }
        catch (ClassNotFoundException thatsOk) {
            return new JavaSnippet();
        }
    }

    public JavaBackend(ResourceLoader resourceLoader, TypeRegistry typeRegistry) {
        this((ClassFinder)new ResourceLoaderClassFinder(resourceLoader, Thread.currentThread().getContextClassLoader()), typeRegistry);
    }

    private JavaBackend(ClassFinder classFinder, TypeRegistry typeRegistry) {
        this(ObjectFactoryLoader.loadObjectFactory(classFinder, Env.INSTANCE.get(ObjectFactory.class.getName())), classFinder, typeRegistry);
    }

    public JavaBackend(ObjectFactory objectFactory, ClassFinder classFinder, TypeRegistry typeRegistry) {
        this.classFinder = classFinder;
        this.objectFactory = objectFactory;
        this.methodScanner = new MethodScanner(classFinder);
        this.snippetGenerator = new SnippetGenerator(this.createSnippet(), typeRegistry.parameterTypeRegistry());
        this.typeRegistry = typeRegistry;
    }

    public void loadGlue(Glue glue, List<String> gluePaths) {
        this.glue = glue;
        this.methodScanner.scan(this, gluePaths);
        for (String gluePath : gluePaths) {
            Collection glueDefinerClasses = this.classFinder.getDescendants(GlueBase.class, MultiLoader.packageName((String)gluePath));
            for (Class glueClass : glueDefinerClasses) {
                if (glueClass.isInterface() || !this.objectFactory.addClass(glueClass)) continue;
                this.glueBaseClasses.add(glueClass);
            }
        }
    }

    public void loadGlue(Glue glue, Method method, Class<?> glueCodeClass) {
        this.glue = glue;
        this.methodScanner.scan(this, method, glueCodeClass);
    }

    public void buildWorld() {
        this.objectFactory.start();
        try {
            INSTANCE.set(this);
            this.glue.removeScenarioScopedGlue();
            for (Class<? extends GlueBase> glueBaseClass : this.glueBaseClasses) {
                this.objectFactory.getInstance(glueBaseClass);
            }
        }
        finally {
            INSTANCE.remove();
        }
    }

    public void disposeWorld() {
        this.objectFactory.stop();
    }

    public List<String> getSnippet(PickleStep step, String keyword, FunctionNameGenerator functionNameGenerator) {
        return this.snippetGenerator.getSnippet(step, keyword, functionNameGenerator);
    }

    void addStepDefinition(Annotation annotation, Method method) {
        try {
            if (this.objectFactory.addClass(method.getDeclaringClass())) {
                this.glue.addStepDefinition((StepDefinition)new JavaStepDefinition(method, this.expression(annotation), this.timeoutMillis(annotation), this.objectFactory, this.typeRegistry));
            }
        }
        catch (CucumberException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CucumberException(e);
        }
    }

    @Override
    public void addStepDefinition(Function<TypeRegistry, StepDefinition> stepDefinitionFunction) {
        this.glue.addStepDefinition(stepDefinitionFunction.apply(this.typeRegistry));
    }

    void addHook(Annotation annotation, Method method) {
        if (this.objectFactory.addClass(method.getDeclaringClass())) {
            if (annotation.annotationType().equals(Before.class)) {
                String[] tagExpressions = ((Before)annotation).value();
                long timeout = ((Before)annotation).timeout();
                this.addBeforeHookDefinition(new JavaHookDefinition(method, tagExpressions, ((Before)annotation).order(), timeout, this.objectFactory));
            } else if (annotation.annotationType().equals(After.class)) {
                String[] tagExpressions = ((After)annotation).value();
                long timeout = ((After)annotation).timeout();
                this.addAfterHookDefinition(new JavaHookDefinition(method, tagExpressions, ((After)annotation).order(), timeout, this.objectFactory));
            } else if (annotation.annotationType().equals(BeforeStep.class)) {
                String[] tagExpressions = ((BeforeStep)annotation).value();
                long timeout = ((BeforeStep)annotation).timeout();
                this.addBeforeStepHookDefinition(new JavaHookDefinition(method, tagExpressions, ((BeforeStep)annotation).order(), timeout, this.objectFactory));
            } else if (annotation.annotationType().equals(AfterStep.class)) {
                String[] tagExpressions = ((AfterStep)annotation).value();
                long timeout = ((AfterStep)annotation).timeout();
                this.addAfterStepHookDefinition(new JavaHookDefinition(method, tagExpressions, ((AfterStep)annotation).order(), timeout, this.objectFactory));
            }
        }
    }

    @Override
    public void addBeforeHookDefinition(HookDefinition beforeHook) {
        this.glue.addBeforeHook(beforeHook);
    }

    @Override
    public void addAfterHookDefinition(HookDefinition afterHook) {
        this.glue.addAfterHook(afterHook);
    }

    @Override
    public void addAfterStepHookDefinition(HookDefinition afterStepHook) {
        this.glue.addAfterStepHook(afterStepHook);
    }

    @Override
    public void addBeforeStepHookDefinition(HookDefinition beforeStepHook) {
        this.glue.addBeforeStepHook(beforeStepHook);
    }

    private String expression(Annotation annotation) throws Throwable {
        Method expressionMethod = annotation.getClass().getMethod("value", new Class[0]);
        return (String)Utils.invoke((Object)annotation, (Method)expressionMethod, (long)0L, (Object[])new Object[0]);
    }

    private long timeoutMillis(Annotation annotation) throws Throwable {
        Method regexpMethod = annotation.getClass().getMethod("timeout", new Class[0]);
        return (Long)Utils.invoke((Object)annotation, (Method)regexpMethod, (long)0L, (Object[])new Object[0]);
    }
}

