/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.java.commands.plugin.util;

import io.cronapp.java.commands.plugin.util.CompositeClassloader;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.JavaRuntime;

public class ProjectClassLoader
implements AutoCloseable {
    public final URLClassLoader projectClassLoader;
    public final ClassLoader ideClassLoader;

    private ProjectClassLoader(URLClassLoader projectClassLoader, ClassLoader ideClassLoader) {
        this.projectClassLoader = projectClassLoader;
        this.ideClassLoader = ideClassLoader;
        CompositeClassloader compositeClassloader = new CompositeClassloader(ideClassLoader, (ClassLoader)projectClassLoader);
        Thread.currentThread().setContextClassLoader(compositeClassloader);
    }

    public static ProjectClassLoader doOpen(IJavaProject javaProject) throws Exception {
        ClassLoader ideClassLoader = Thread.currentThread().getContextClassLoader();
        if (ideClassLoader == null) {
            ideClassLoader = ProjectClassLoader.class.getClassLoader();
        }
        String[] entries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
        ArrayList<URL> urlList = new ArrayList<URL>();
        String[] stringArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String classPathEntry = stringArray[n2];
            Path path = new Path(classPathEntry);
            URL url = path.toFile().toURI().toURL();
            urlList.add(url);
            ++n2;
        }
        URL[] urls = urlList.toArray(new URL[0]);
        try {
            URLClassLoader classLoader = new URLClassLoader(urls);
            return new ProjectClassLoader(classLoader, ideClassLoader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        Thread.currentThread().setContextClassLoader(this.ideClassLoader);
        if (this.projectClassLoader != null) {
            try {
                this.projectClassLoader.close();
            }
            catch (IOException iOException) {}
        }
    }
}

