/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.java.commands.plugin.util;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaProjectSourceContainer;
import org.eclipse.jdt.launching.sourcelookup.containers.PackageFragmentRootSourceContainer;

public class JdtUtils {
    public static Map<String, ICompilationUnit> COMPILATION_UNIT_CACHE = Collections.synchronizedMap(new HashMap());
    public static IPackageFragment[] SRC_CACHE;

    public static ICompilationUnit getCompilationUnit(IJavaProject javaProject, String fileFullPath) throws Exception {
        ICompilationUnit cu = COMPILATION_UNIT_CACHE.get(fileFullPath);
        if (cu != null) {
            return cu;
        }
        IPackageFragment[] packagesFragments = javaProject.getPackageFragments();
        File file = new File(fileFullPath);
        IFile iFile = javaProject.getProject().getFile(fileFullPath);
        IPackageFragment fragment = JdtUtils.getPackageFragment(packagesFragments, iFile.getParent().getFullPath());
        if (fragment == null) {
            return null;
        }
        cu = fragment.getCompilationUnit(file.getName());
        COMPILATION_UNIT_CACHE.put(fileFullPath, cu);
        return cu;
    }

    public static IPackageFragment getPackageFragment(IPackageFragment[] packages, IPath packageName) throws Exception {
        IPackageFragment[] iPackageFragmentArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragment iPackageFragment = iPackageFragmentArray[n2];
            if (iPackageFragment.getPath().equals((Object)packageName)) {
                return iPackageFragment;
            }
            ++n2;
        }
        return null;
    }

    public static IPackageFragment[] getSourcesFragments(IJavaProject javaProject) throws Exception {
        if (SRC_CACHE != null) {
            return SRC_CACHE;
        }
        LinkedList<IPackageFragment> packs = new LinkedList<IPackageFragment>();
        IPackageFragment[] iPackageFragmentArray = javaProject.getPackageFragments();
        int n = iPackageFragmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragment iPackageFragment = iPackageFragmentArray[n2];
            if (iPackageFragment.getKind() == 1) {
                packs.add(iPackageFragment);
            }
            ++n2;
        }
        SRC_CACHE = packs.toArray(new IPackageFragment[0]);
        return SRC_CACHE;
    }

    public static String getModuleName(IJavaProject project) {
        IModuleDescription module;
        if (project == null || !JavaRuntime.isModularProject((IJavaProject)project)) {
            return null;
        }
        try {
            module = project.getModuleDescription();
        }
        catch (CoreException coreException) {
            return null;
        }
        return module == null ? null : module.getElementName();
    }

    public static boolean isJavaProject(IProject project) {
        if (project == null || !project.exists()) {
            return false;
        }
        try {
            return project.isNatureEnabled("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static IJavaProject getJavaProject(IProject project) {
        if (JdtUtils.isJavaProject(project)) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    public static IJavaProject getJavaProject(String projectName) {
        if (projectName == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        return JdtUtils.getJavaProject(project);
    }

    public static IProject getProject(String projectName) {
        if (projectName == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root.getProject(projectName);
    }

    public static ISourceContainer[] getSourceContainers(String projectName) {
        LinkedHashSet containers = new LinkedHashSet();
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IProject targetProject = JdtUtils.getProject(projectName);
        if (targetProject != null) {
            projects.add(targetProject);
        }
        List<IProject> workspaceProjects = Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects());
        projects.addAll(workspaceProjects);
        LinkedHashSet calculated = new LinkedHashSet();
        projects.stream().distinct().map(project -> JdtUtils.getJavaProject(project)).filter(javaProject -> javaProject != null && javaProject.exists()).forEach(javaProject -> {
            containers.addAll(Arrays.asList(JdtUtils.getSourceContainers(javaProject, calculated)));
            containers.add(new JavaProjectSourceContainer(javaProject));
        });
        return containers.toArray(new ISourceContainer[0]);
    }

    private static ISourceContainer[] getSourceContainers(IJavaProject project, Set<IRuntimeClasspathEntry> calculated) {
        if (project == null || !project.exists()) {
            return new ISourceContainer[0];
        }
        try {
            int n;
            IRuntimeClasspathEntry[] unresolved = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)project);
            ArrayList<IRuntimeClasspathEntry> resolved = new ArrayList<IRuntimeClasspathEntry>();
            IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = unresolved;
            int n2 = unresolved.length;
            int n3 = 0;
            while (n3 < n2) {
                IRuntimeClasspathEntry entry2 = iRuntimeClasspathEntryArray[n3];
                IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray2 = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)entry2, (IJavaProject)project);
                int n4 = iRuntimeClasspathEntryArray2.length;
                n = 0;
                while (n < n4) {
                    IRuntimeClasspathEntry resolvedEntry = iRuntimeClasspathEntryArray2[n];
                    if (!calculated.contains(resolvedEntry)) {
                        calculated.add(resolvedEntry);
                        resolved.add(resolvedEntry);
                    }
                    ++n;
                }
                ++n3;
            }
            LinkedHashSet<Object> containers = new LinkedHashSet<Object>();
            containers.addAll(Arrays.asList(JavaRuntime.getSourceContainers((IRuntimeClasspathEntry[])resolved.toArray(new IRuntimeClasspathEntry[0]))));
            IRuntimeClasspathEntry jrtFs = resolved.stream().filter(entry -> entry.getType() == 2 && entry.getPath().lastSegment().equals("jrt-fs.jar")).findFirst().orElse(null);
            if (jrtFs != null && project.isOpen()) {
                IPackageFragmentRoot[] allRoots;
                IPackageFragmentRoot[] iPackageFragmentRootArray = allRoots = project.getPackageFragmentRoots();
                n = allRoots.length;
                int n5 = 0;
                while (n5 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n5];
                    if (root.getPath().equals((Object)jrtFs.getPath()) && JdtUtils.isSourceAttachmentEqual(root, jrtFs)) {
                        containers.add(new PackageFragmentRootSourceContainer(root));
                    }
                    ++n5;
                }
            }
            return containers.toArray(new ISourceContainer[0]);
        }
        catch (CoreException coreException) {
            return new ISourceContainer[0];
        }
    }

    private static boolean isSourceAttachmentEqual(IPackageFragmentRoot root, IRuntimeClasspathEntry entry) throws JavaModelException {
        IPath entryPath = entry.getSourceAttachmentPath();
        if (entryPath == null) {
            return true;
        }
        IPath rootPath = root.getSourceAttachmentPath();
        if (rootPath == null) {
            return false;
        }
        return rootPath.equals((Object)entryPath);
    }

    public static Object findSourceElement(String sourcePath, ISourceContainer[] containers) {
        if (containers == null) {
            return null;
        }
        ISourceContainer[] iSourceContainerArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceContainer container = iSourceContainerArray[n2];
            try {
                Object[] objects = container.findSourceElements(sourcePath);
                if (objects.length > 0 && (objects[0] instanceof IResource || objects[0] instanceof IClassFile)) {
                    return objects[0];
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return null;
    }

    public static IJavaProject findProject(StackFrame stackFrame, ISourceContainer[] containers) {
        Location location = stackFrame.location();
        try {
            IJavaProject javaProject;
            Object sourceElement = JdtUtils.findSourceElement(location.sourcePath(), containers);
            if (sourceElement instanceof IResource) {
                return JavaCore.create((IProject)((IResource)sourceElement).getProject());
            }
            if (sourceElement instanceof IClassFile && (javaProject = ((IClassFile)sourceElement).getJavaProject()) != null) {
                return javaProject;
            }
        }
        catch (AbsentInformationException absentInformationException) {}
        return null;
    }

    private static String getTypeName(String genericTypeSignature) {
        int arrayDimension = 0;
        while (genericTypeSignature.charAt(arrayDimension) == '[') {
            ++arrayDimension;
        }
        int parameterStart = genericTypeSignature.indexOf(60);
        StringBuffer name = new StringBuffer();
        if (parameterStart < 0) {
            name.append(genericTypeSignature.substring(arrayDimension + 1, genericTypeSignature.length() - 1).replace('/', '.'));
        } else {
            if (parameterStart != 0) {
                name.append(genericTypeSignature.substring(arrayDimension + 1, parameterStart).replace('/', '.'));
            }
            try {
                String sig = Signature.toString((String)genericTypeSignature).substring(Math.max(parameterStart - 1, 0) - arrayDimension);
                name.append(sig.replace('/', '.'));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                name.append(genericTypeSignature);
            }
        }
        int i = 0;
        while (i < arrayDimension) {
            name.append("[]");
            ++i;
        }
        return name.toString();
    }
}

