/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.java.commands.plugin.util;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.Signature;

public class GetterSetterUtil {
    private static final String[] EMPTY = new String[0];

    public static String getGetterName(IJavaProject project, String fieldName, int flags, boolean isBoolean, String[] excludedNames) {
        return NamingConventions.suggestGetterName((IJavaProject)project, (String)fieldName, (int)flags, (boolean)isBoolean, (String[])excludedNames);
    }

    private static String getGetterName(IField field, String[] excludedNames, boolean useIsForBoolGetters) throws JavaModelException {
        if (excludedNames == null) {
            excludedNames = EMPTY;
        }
        return GetterSetterUtil.getGetterName(field.getJavaProject(), field.getElementName(), field.getFlags(), useIsForBoolGetters && GetterSetterUtil.isBoolean(field), excludedNames);
    }

    public static String getGetterName(IField field, String[] excludedNames) throws JavaModelException {
        return GetterSetterUtil.getGetterName(field, excludedNames, true);
    }

    public static String getSetterName(IField field, String[] excludedNames) throws JavaModelException {
        if (excludedNames == null) {
            excludedNames = EMPTY;
        }
        return GetterSetterUtil.getSetterName(field.getJavaProject(), field.getElementName(), field.getFlags(), GetterSetterUtil.isBoolean(field), excludedNames);
    }

    public static boolean isBoolean(IField field) throws JavaModelException {
        return field.getTypeSignature().equals("Z");
    }

    public static String getSetterName(IJavaProject project, String fieldName, int flags, boolean isBoolean, String[] excludedNames) {
        return NamingConventions.suggestSetterName((IJavaProject)project, (String)fieldName, (int)flags, (boolean)false, (String[])excludedNames);
    }

    public static IMethod findMethod(String name, String[] paramTypes, boolean isConstructor, IType type) throws JavaModelException {
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (GetterSetterUtil.isSameMethodSignature(name, paramTypes, isConstructor, methods[i])) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean isSameMethodSignature(String name, String[] paramTypes, boolean isConstructor, IMethod curr) throws JavaModelException {
        String[] currParamTypes;
        if ((isConstructor || name.equals(curr.getElementName())) && isConstructor == curr.isConstructor() && paramTypes.length == (currParamTypes = curr.getParameterTypes()).length) {
            int i = 0;
            while (i < paramTypes.length) {
                String t2;
                String t1 = Signature.getSimpleName((String)Signature.toString((String)paramTypes[i]));
                if (!t1.equals(t2 = Signature.getSimpleName((String)Signature.toString((String)currParamTypes[i])))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

