/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.java.commands.plugin.util;

import io.cronapp.i18n.Messages;
import io.cronapp.java.commands.plugin.util.Functions;
import io.cronapp.java.commands.plugin.util.ProjectInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.ResolvedBinaryType;
import org.eclipse.jdt.internal.core.ResolvedSourceType;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;

public class CronapiManager {
    public static final String ANNOTATION_CRONAPI = "cronapi.CronapiMetaData";
    public static final String ANNOTATION_CRONAPI_PARAM_METADATA = "cronapi.ParamMetaData";
    private static final String CRONAPIMETADATA_NAMESPACE = "cronapi.CronapiMetaData.";
    private static final String PATH_I18N = "cronapi/i18n";
    private static final String PATH_WEBAPP = "src/main/webapp";
    private static final String PROPERTY_FILE_NAME = "Messages_%s.properties";
    private static final String PATH_I18N_JSON_LOCALE = "i18n/locale_%s.json";
    private static final Logger logger = Logger.getLogger("cronapp");
    public static Map<String, JsonArray> API_CACHE = new ConcurrentHashMap<String, JsonArray>();
    private ProjectInfo projectInfo;
    private final IJavaProject javaProject;
    private final String language;
    private final String codeType;
    private final String[] webContext;
    private final String functionType;
    private final String projectName;
    private String cronapiJsFile = "cronapi.";
    private String prefixPackage = "cronapi";

    public CronapiManager(ProjectInfo projectInfo, String projectName, IJavaProject javaProject, String language, String codeType, String[] webContext, String functionType) {
        this.projectInfo = projectInfo;
        this.javaProject = javaProject;
        this.projectName = projectName;
        this.language = language;
        this.codeType = codeType;
        this.functionType = functionType;
        if (webContext.length == 0) {
            webContext = new String[]{PATH_WEBAPP};
        }
        this.webContext = webContext;
    }

    public void setCronapiJsFile(String cronapiJsFile) {
        this.cronapiJsFile = cronapiJsFile;
    }

    public void setPrefixPackage(String prefixPackage) {
        this.prefixPackage = prefixPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonArray listMetaDataMethods() throws Exception {
        String contextType = "W";
        for (String context : Arrays.asList(this.webContext)) {
            if (!context.contains("mobileapp")) continue;
            contextType = "M";
        }
        JsonArray services = API_CACHE.get(String.valueOf(this.language) + (this.codeType == null ? "" : "_" + this.codeType) + "_" + contextType + "_" + this.functionType);
        if (services != null) {
            return services;
        }
        Map<String, JsonArray> map = API_CACHE;
        synchronized (map) {
            services = API_CACHE.get(String.valueOf(this.language) + (this.codeType == null ? "" : "_" + this.codeType) + "_" + contextType + "_" + this.functionType);
            if (services != null) {
                return services;
            }
            Messages.set(this.language);
            services = new JsonArray();
            if ("javascript".equals(this.codeType) || this.codeType == null) {
                this.fillAllFunctionsJavascript(services, this.webContext[0]);
            }
            if ("java".equals(this.codeType) || this.codeType == null) {
                this.fillAllFunctionsJava(services, this.webContext[0]);
                this.fillMultiLayerFunctions(services, this.webContext);
            }
            API_CACHE.put(String.valueOf(this.language) + (this.codeType == null ? "" : "_" + this.codeType) + "_" + contextType + "_" + this.functionType, services);
            return services;
        }
    }

    private void fillMultiLayerFunctions(JsonArray services, String[] webContext) throws Exception {
        JsonArray multiLayerFunctions = new JsonArray();
        String[] stringArray = webContext;
        int n = webContext.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            this.fillAllFunctionsJavascript(multiLayerFunctions, item);
            ++n2;
        }
        multiLayerFunctions.forEach(json -> {
            if (json.asObject().get("multilayer").asBoolean()) {
                services.add((JsonValue)json);
            }
        });
    }

    private File findFile(String path) {
        return new File(path);
    }

    private File getFileInSrcPath(String classSourcePath) {
        File file = new File(this.projectInfo.absolutePath, "src/main/java" + File.separator + classSourcePath);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private String getCharset() {
        String charset = null;
        try {
            charset = this.javaProject.getProject().getDefaultCharset();
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (charset == null) {
            charset = "UTF-8";
        }
        return charset;
    }

    private void fillAllFunctionsJavascript(JsonArray services, String webContext) throws Exception {
        ArrayList<IFile> cronapiFiles = new ArrayList<IFile>();
        ArrayList<JsonObject> jsonTranslateFiles = new ArrayList<JsonObject>();
        Path pathWebApp = new Path(webContext);
        if (this.javaProject.getProject().findMember((IPath)pathWebApp) != null) {
            IContainer webApp = (IContainer)this.javaProject.getProject().findMember((IPath)pathWebApp);
            this.fillCronapiJsFilesAndTranslateJsonFiles(webApp, cronapiFiles, jsonTranslateFiles);
            this.bindClientProperties(cronapiFiles, services, jsonTranslateFiles, webApp.getFullPath().toString());
        }
    }

    private void fillAllFunctionsJava(final JsonArray services, String webContext) throws Exception {
        IPackageFragment[] packages = null;
        try {
            packages = this.javaProject.getPackageFragments();
        }
        catch (JavaModelException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        SearchPattern pattern = SearchPattern.createPattern((String)ANNOTATION_CRONAPI, (int)8, (int)65536, (int)32);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])packages);
        final HashMap cacheProperties = new HashMap();
        SearchRequestor requestorFindProperties = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws JavaModelException {
                IType type = CronapiManager.getITypeFromMatch(match);
                if (type != null) {
                    try {
                        this.addCurrentProperty(type);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }

            private void addCurrentProperty(IType classType) throws Exception {
                block24: {
                    if (classType instanceof ResolvedBinaryType) {
                        String path = ((ResolvedBinaryType)classType).getPath().toString();
                        if (!cacheProperties.containsKey(path)) {
                            File file = CronapiManager.this.findFile(path);
                            Throwable throwable = null;
                            Object var5_9 = null;
                            try (JarFile jarFile = new JarFile(file);){
                                JarEntry jarEntry = jarFile.getJarEntry("cronapi/i18n/" + String.format(CronapiManager.PROPERTY_FILE_NAME, CronapiManager.this.language));
                                if (jarEntry == null) {
                                    jarEntry = jarFile.getJarEntry("i18n/" + String.format(CronapiManager.PROPERTY_FILE_NAME, CronapiManager.this.language));
                                }
                                if (jarEntry == null) break block24;
                                Properties currentProperties = new Properties();
                                Throwable throwable2 = null;
                                Object var10_16 = null;
                                try (InputStream in = jarFile.getInputStream(jarEntry);){
                                    String charset = CronapiManager.this.javaProject.getProject().getDefaultCharset();
                                    if (charset == null) {
                                        charset = "UTF-8";
                                    }
                                    currentProperties.load(new InputStreamReader(in, Charset.forName(charset)));
                                    cacheProperties.put(path, currentProperties);
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                    } else if (throwable2 != throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    throw throwable2;
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                throw throwable;
                            }
                        }
                    } else {
                        String path = "cronapi/i18n/" + String.format(CronapiManager.PROPERTY_FILE_NAME, CronapiManager.this.language);
                        this.addInCacheIfNotNull(path);
                        String[] nameSpace = classType.getFullyQualifiedName().split(Pattern.quote("."));
                        path = "";
                        int i = 0;
                        while (i < nameSpace.length - 1) {
                            path = String.valueOf(path) + String.format("%s/", nameSpace[i]);
                            ++i;
                        }
                        path = String.valueOf(path) + String.format("i18n/%s", String.format(CronapiManager.PROPERTY_FILE_NAME, CronapiManager.this.language));
                        this.addInCacheIfNotNull(path);
                    }
                }
            }

            private void addInCacheIfNotNull(String path) throws FileNotFoundException, IOException {
                File fileMessage;
                if (!cacheProperties.containsKey(path) && (fileMessage = CronapiManager.this.getFileInSrcPath(path)) != null && fileMessage.exists()) {
                    Properties currentProperties = new Properties();
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try (FileInputStream in = new FileInputStream(fileMessage);){
                        currentProperties.load(new InputStreamReader((InputStream)in, Charset.forName(CronapiManager.this.getCharset())));
                        cacheProperties.put(path, currentProperties);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
        };
        SearchEngine searchEngineProperties = new SearchEngine();
        searchEngineProperties.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestorFindProperties, null);
        SearchRequestor requestor = new SearchRequestor(){
            Properties currentProperties = new Properties();

            public void acceptSearchMatch(SearchMatch match) throws JavaModelException {
                IType type = CronapiManager.getITypeFromMatch(match);
                if (type != null) {
                    try {
                        IMethod[] methods = type.getMethods();
                        String fullyQualifiedName = type.getFullyQualifiedName();
                        this.fillCronapiJavaMethods(type, methods, fullyQualifiedName);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }

            private String getRawType(String typeSignature) {
                String rawType = Signature.getSignatureQualifier((String)typeSignature);
                if (!rawType.isEmpty()) {
                    rawType = String.valueOf(rawType) + ".";
                }
                rawType = String.valueOf(rawType) + Signature.getSignatureSimpleName((String)typeSignature).split("<")[0];
                return rawType;
            }

            private void fillCronapiJavaMethods(IType classType, IMethod[] methods, String fullyQualifiedName) throws Exception {
                IMethod[] iMethodArray = methods;
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod method = iMethodArray[n2];
                    IAnnotation classAnnotation = this.getAnnotation((IAnnotatable)classType, CronapiManager.ANNOTATION_CRONAPI);
                    IAnnotation methodAnnotation = this.getAnnotation((IAnnotatable)method, CronapiManager.ANNOTATION_CRONAPI);
                    this.defineCurrentProperty(classType);
                    if (methodAnnotation != null && methodAnnotation.exists() && this.getAnnotationValue(methodAnnotation, "type", "function").equals(CronapiManager.this.functionType)) {
                        String nameMethod = method.getElementName();
                        String returnType = method.getReturnType();
                        String platform = this.getAnnotationValue(methodAnnotation, "platform", "").toString();
                        if (platform.isEmpty() || ((CronapiManager)CronapiManager.this).projectInfo.projectType == null || ((CronapiManager)CronapiManager.this).projectInfo.projectType.contains(platform)) {
                            String i18nType = method.getDeclaringType().getFullyQualifiedName();
                            String i18nMethod = String.valueOf(i18nType) + ".Method." + method.getElementName();
                            String categoryName = this.getAnnotationValue(classAnnotation, "categoryName", "").toString();
                            String category = this.getAnnotationValue(classAnnotation, "category", "CategoryType.OTHER").toString();
                            String description = this.getAnnotationValue(methodAnnotation, "description", "").toString();
                            String friendlyName = this.getAnnotationValue(methodAnnotation, "name", "").toString();
                            String help = this.getAnnotationValue(methodAnnotation, "help", "").toString();
                            String helpTemplate = this.getAnnotationValue(classAnnotation, "helpTemplate", "").toString();
                            if (categoryName.isEmpty()) {
                                categoryName = "{{" + i18nType + ".Name}}";
                            }
                            if (friendlyName.isEmpty()) {
                                friendlyName = "{{" + i18nMethod + ".Name}}";
                            }
                            if (description.isEmpty()) {
                                description = "{{" + i18nMethod + ".Description}}";
                            }
                            JsonObject jsonMethod = new JsonObject();
                            jsonMethod.set("type", this.getAnnotationValue(methodAnnotation, "type", "function").toString());
                            jsonMethod.set("platform", platform);
                            jsonMethod.set("name", String.valueOf(fullyQualifiedName) + "." + nameMethod);
                            jsonMethod.set("path", method.getPath().toString().replace("/" + CronapiManager.this.projectName + "/", ""));
                            jsonMethod.set("nameTags", (JsonArray)this.getAnnotationValue(methodAnnotation, "nameTags", new JsonArray()));
                            jsonMethod.set("language", "java");
                            jsonMethod.set("returnType", this.getAnnotationValue(methodAnnotation, "returnType", "ObjectType.VOID").toString());
                            jsonMethod.set("returnRawType", this.getRawType(returnType));
                            jsonMethod.set("hasReturn", !returnType.isEmpty() && !returnType.equals("V"));
                            if (!categoryName.isEmpty() && "CategoryType.OTHER".equals(category)) {
                                category = categoryName;
                            }
                            jsonMethod.set("category", this.getStringResult(category, true));
                            jsonMethod.set("categoryType", category);
                            jsonMethod.set("categoryTags", (JsonArray)this.getAnnotationValue(classAnnotation, "categoryTags", new JsonArray()));
                            jsonMethod.set("friendlyName", this.getStringResult(friendlyName, true));
                            jsonMethod.set("description", this.getStringResult(description, true));
                            jsonMethod.set("wizard", this.getAnnotationValue(methodAnnotation, "wizard", "").toString());
                            jsonMethod.set("external", (Boolean)this.getAnnotationValue(methodAnnotation, "external", true));
                            jsonMethod.set("displayInline", (Boolean)this.getAnnotationValue(methodAnnotation, "displayInline", false));
                            jsonMethod.set("arbitraryParams", (Boolean)this.getAnnotationValue(methodAnnotation, "arbitraryParams", false));
                            jsonMethod.set("multilayer", (Boolean)this.getAnnotationValue(methodAnnotation, "multilayer", false));
                            jsonMethod.set("params", this.getParams(methodAnnotation, method));
                            if (help.isEmpty() && !helpTemplate.isEmpty()) {
                                jsonMethod.set("help", helpTemplate.replace("${nameMethod}", nameMethod));
                            } else {
                                jsonMethod.set("help", help);
                            }
                            services.add(jsonMethod);
                        }
                    }
                    ++n2;
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void defineCurrentProperty(IType classType) throws Exception {
                this.currentProperties = new Properties();
                if (classType instanceof ResolvedBinaryType) {
                    String path = ((ResolvedBinaryType)classType).getPath().toString();
                    if (cacheProperties.containsKey(path)) {
                        this.currentProperties = (Properties)cacheProperties.get(path);
                        return;
                    }
                    File file = CronapiManager.this.findFile(path);
                    Throwable throwable = null;
                    Object var5_10 = null;
                    try (JarFile jarFile = new JarFile(file);){
                        JarEntry jarEntry = jarFile.getJarEntry("cronapi/i18n/" + String.format(CronapiManager.PROPERTY_FILE_NAME, CronapiManager.this.language));
                        if (jarEntry == null) {
                            jarEntry = jarFile.getJarEntry("i18n/" + String.format(CronapiManager.PROPERTY_FILE_NAME, CronapiManager.this.language));
                        }
                        if (jarEntry == null) return;
                        Throwable throwable2 = null;
                        Object var9_19 = null;
                        try (InputStream in = jarFile.getInputStream(jarEntry);){
                            this.currentProperties.load(new InputStreamReader(in, Charset.forName(CronapiManager.this.getCharset())));
                            cacheProperties.put(path, this.currentProperties);
                            return;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                            throw throwable;
                        } else {
                            if (throwable == throwable4) throw throwable;
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                String path = "cronapi/i18n/" + String.format(CronapiManager.PROPERTY_FILE_NAME, CronapiManager.this.language);
                if (cacheProperties.containsKey(path)) {
                    this.currentProperties = (Properties)cacheProperties.get(path);
                    return;
                }
                File fileMessage = CronapiManager.this.getFileInSrcPath(path);
                if (fileMessage == null || !fileMessage.exists()) return;
                Throwable throwable = null;
                Object var5_12 = null;
                try (FileInputStream in = new FileInputStream(fileMessage);){
                    this.currentProperties.load(new InputStreamReader((InputStream)in, Charset.forName(CronapiManager.this.getCharset())));
                    cacheProperties.put(path, this.currentProperties);
                    return;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                        throw throwable;
                    } else {
                        if (throwable == throwable5) throw throwable;
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }

            private IAnnotation getAnnotation(IAnnotatable container, String annotationName) {
                IAnnotation annotation = null;
                annotation = container.getAnnotation(annotationName.replace("cronapi.", ""));
                if (annotation == null || !annotation.exists()) {
                    annotation = container.getAnnotation(annotationName);
                }
                return annotation;
            }

            private Object getAnnotationValue(IAnnotation annotation, String name, Object defaultValue) throws JavaModelException {
                if (!annotation.exists()) {
                    return defaultValue;
                }
                IMemberValuePair[] annArray = annotation.getMemberValuePairs();
                int x = 0;
                while (x < annArray.length) {
                    if (annArray[x].getMemberName().equalsIgnoreCase(name)) {
                        Object result = annArray[x].getValue();
                        if (result instanceof String) {
                            return this.getStringResult(result.toString(), false);
                        }
                        if (result instanceof Object[]) {
                            JsonArray array = new JsonArray();
                            Object[] objectArray = (Object[])result;
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object o = objectArray[n2];
                                array.add(this.getStringResult(o.toString(), false));
                                ++n2;
                            }
                            return array;
                        }
                        return result;
                    }
                    ++x;
                }
                return defaultValue;
            }

            private String getStringResult(String resultAsString, boolean forceTranslate) {
                if ((resultAsString = resultAsString.replace(CronapiManager.CRONAPIMETADATA_NAMESPACE, "")).startsWith("{{") || forceTranslate) {
                    resultAsString = this.getTranslateFromProperty(resultAsString);
                }
                return resultAsString;
            }

            private String getTranslateFromProperty(String resultAsString) {
                String resultStringOb = resultAsString = resultAsString.replace("{{", "").replace("}}", "");
                if ((resultAsString = this.currentProperties.containsKey(resultAsString) ? this.currentProperties.getProperty(resultAsString) : this.tryTranslateFromOtherProperties(resultAsString)).equals(resultStringOb) && resultAsString.matches("^[A-Za-z]+[A-Za-z0-9-_]+\\.[A-Za-z0-9-\\._]*?$")) {
                    ArrayList<String> stringToShow = new ArrayList<String>(Arrays.asList(resultAsString.split("\\.")));
                    if (stringToShow.size() > 1) {
                        return (String)stringToShow.get(stringToShow.size() - 2);
                    }
                    return resultAsString;
                }
                return resultAsString;
            }

            private String tryTranslateFromOtherProperties(String resultAsString) {
                StringBuilder sb = new StringBuilder();
                cacheProperties.values().forEach(p -> {
                    if (p.containsKey(resultAsString) && sb.length() == 0) {
                        sb.append(p.getProperty(resultAsString));
                    }
                });
                return sb.length() > 0 ? sb.toString() : resultAsString;
            }

            private JsonArray getParams(IAnnotation methodAnnotation, IMethod method) throws JavaModelException {
                JsonArray result = new JsonArray();
                JsonArray methodParams = (JsonArray)this.getAnnotationValue(methodAnnotation, "params", new JsonArray());
                JsonArray paramsType = (JsonArray)this.getAnnotationValue(methodAnnotation, "paramsType", new JsonArray());
                String i18nType = method.getDeclaringType().getFullyQualifiedName();
                String i18nMethod = String.valueOf(i18nType) + ".Method." + method.getElementName();
                int i = 0;
                while (i < method.getNumberOfParameters()) {
                    String typeDefault;
                    String rawType;
                    ILocalVariable localVariable = method.getParameters()[i];
                    IAnnotation paramAnnotation = this.getAnnotation((IAnnotatable)method.getParameters()[i], CronapiManager.ANNOTATION_CRONAPI_PARAM_METADATA);
                    JsonObject param = new JsonObject();
                    String nameDefault = "";
                    if (methodParams.size() > i) {
                        nameDefault = methodParams.get(i).asString();
                    }
                    String i18nParameter = String.valueOf(i18nMethod) + ".Parameter." + method.getParameterNames()[i];
                    String description = this.getAnnotationValue(paramAnnotation, "description", nameDefault).toString();
                    if (description.isEmpty()) {
                        description = "{{" + i18nParameter + ".Description}}";
                    }
                    param.add("name", this.getStringResult(description, true));
                    String typeSignature = localVariable.getTypeSignature();
                    switch (rawType = this.getRawType(typeSignature)) {
                        case "java.lang.String": {
                            typeDefault = "ObjectType.STRING";
                            break;
                        }
                        case "java.util.Map": {
                            typeDefault = "ObjectType.MAP";
                            break;
                        }
                        case "java.util.List": {
                            typeDefault = "ObjectType.LIST";
                            break;
                        }
                        case "cronapi.Var[]": 
                        case "cronapi.Var": {
                            typeDefault = "ObjectType.UNKNOWN";
                            break;
                        }
                        default: {
                            logger.fine(String.format("Type: %s, method %s, mapping %s as ObjectType.OBJECT", localVariable.getDeclaringMember().getDeclaringType().getFullyQualifiedName(), localVariable.getDeclaringMember().getElementName(), rawType));
                            typeDefault = "ObjectType.OBJECT";
                        }
                    }
                    if (paramsType.size() > i) {
                        typeDefault = paramsType.get(i).asString();
                    }
                    param.add("type", this.getAnnotationValue(paramAnnotation, "type", typeDefault).toString());
                    param.add("rawType", rawType);
                    param.add("blockType", this.getAnnotationValue(paramAnnotation, "blockType", "").toString());
                    param.add("defaultValue", this.getAnnotationValue(paramAnnotation, "defaultValue", "").toString());
                    param.add("keys", (JsonArray)this.getAnnotationValue(paramAnnotation, "keys", new JsonArray()));
                    param.add("values", (JsonArray)this.getAnnotationValue(paramAnnotation, "values", new JsonArray()));
                    result.add(param);
                    ++i;
                }
                return result;
            }
        };
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
    }

    private static IType getITypeFromMatch(SearchMatch match) throws JavaModelException {
        if (match.getElement() instanceof ResolvedSourceType) {
            CompilationUnit unit;
            ResolvedSourceType type = (ResolvedSourceType)match.getElement();
            if (type.getParent() instanceof CompilationUnit && (unit = (CompilationUnit)type.getParent()) != null && unit.getTypes().length > 0 && unit.getTypes()[0] instanceof SourceType) {
                SourceType sourceType = (SourceType)unit.getTypes()[0];
                return sourceType;
            }
        } else if (match.getElement() instanceof ResolvedBinaryType) {
            ResolvedBinaryType type = (ResolvedBinaryType)match.getElement();
            return type;
        }
        return null;
    }

    private String getFileContent(IFile file) throws Exception {
        File osFile = file.getLocation().toFile();
        byte[] bytes = Functions.getBytesFromFile(osFile.getAbsolutePath());
        String content = new String(bytes, this.getCharset());
        return content;
    }

    private Boolean existFunction(JsonArray array, String name) {
        String object = "\"name\":\"" + name + "\"";
        Boolean bool = array.toString().contains(object);
        return bool;
    }

    private void bindClientProperties(List<IFile> cronapiFiles, JsonArray services, List<JsonObject> jsonTranslateFiles, String webApp) throws Exception {
        int indexTranslate = 0;
        for (IFile file : cronapiFiles) {
            String content = this.getFileContent(file);
            JsonObject jsonTranslate = jsonTranslateFiles.get(indexTranslate++);
            Map<String, String> keyCategories = CronapiManager.fillJsDocFromCategories(content, this.prefixPackage);
            Pattern pattern = Pattern.compile("\\b" + this.prefixPackage + "\\..*?=\\s+function.*\\)|\\b" + this.prefixPackage + "\\..*?=\\s+async\\s+function.*\\)|function\\s.*\\)");
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                String platform;
                boolean isValid;
                String functionName = "";
                boolean async = false;
                if (matcher.group().contains(" async ")) {
                    async = true;
                }
                if (matcher.group().startsWith(this.prefixPackage)) {
                    functionName = matcher.group().substring(0, matcher.group().indexOf(" "));
                } else {
                    functionName = matcher.group().replace("function", "").trim();
                    functionName = functionName.substring(0, functionName.indexOf("(")).trim();
                }
                if (functionName.isEmpty()) continue;
                String params = matcher.group().substring(matcher.group().indexOf("(") + 1, matcher.group().indexOf(")"));
                String[] paramsNames = params.split(Pattern.quote(","));
                String jsDoc = CronapiManager.getJSDoc(matcher, content);
                if (!CronapiManager.isJsDocTypeFunction(jsDoc, this.functionType) || !(isValid = (platform = CronapiManager.getJsDocValue(jsDoc, jsonTranslate, "platform", "").toString()).isEmpty() || this.projectInfo.projectType == null || this.projectInfo.projectType.equals("M") && platform.equals("M") && webApp.contains("mobileapp") || this.projectInfo.projectType.equals("M") && platform.equals("W") && !webApp.contains("mobileapp") || this.projectInfo.projectType.equals("W") && platform.equals("W"))) continue;
                JsonObject jsonMethod = new JsonObject();
                jsonMethod.set("type", CronapiManager.getJsDocValue(jsDoc, jsonTranslate, "type", "function").toString());
                jsonMethod.set("platform", platform);
                jsonMethod.set("name", functionName);
                jsonMethod.set("async", async);
                jsonMethod.set("nameTags", (JsonArray)CronapiManager.getJsDocValue(jsDoc, jsonTranslate, "nameTags", new JsonArray(), true));
                jsonMethod.set("language", "javascript");
                jsonMethod.set("returnType", CronapiManager.getJsDocValue(jsDoc, jsonTranslate, "returns", "ObjectType.VOID").toString());
                jsonMethod.set("hasReturn", !jsonMethod.get("returnType").asString().equals("ObjectType.VOID"));
                String categoryName = CronapiManager.getInfoFromCategory(functionName, keyCategories, jsonTranslate, "categoryName", "").toString();
                String category = CronapiManager.getInfoFromCategory(functionName, keyCategories, jsonTranslate, "category", "CategoryType.OTHER").toString();
                if (!categoryName.isEmpty() && "CategoryType.OTHER".equals(category)) {
                    category = categoryName;
                }
                jsonMethod.set("path", file.getFullPath().toString().replace("/" + this.projectName + "/", ""));
                jsonMethod.set("category", CronapiManager.getStringResult(jsonTranslate, category, true));
                jsonMethod.set("categoryType", category);
                jsonMethod.set("categoryTags", (JsonArray)CronapiManager.getInfoFromCategory(functionName, keyCategories, jsonTranslate, "categoryTags", new JsonArray()));
                jsonMethod.set("friendlyName", CronapiManager.getJsDocValue(jsDoc, jsonTranslate, "name", functionName).toString());
                jsonMethod.set("description", CronapiManager.getJsDocValue(jsDoc, jsonTranslate, "description", "").toString());
                jsonMethod.set("wizard", CronapiManager.getJsDocValue(jsDoc, jsonTranslate, "wizard", "").toString());
                jsonMethod.set("external", Boolean.parseBoolean(CronapiManager.getJsDocValue(jsDoc, jsonTranslate, "external", true).toString()));
                jsonMethod.set("displayInline", Boolean.parseBoolean(CronapiManager.getJsDocValue(jsDoc, jsonTranslate, "displayInline", false).toString()));
                jsonMethod.set("arbitraryParams", Boolean.parseBoolean(CronapiManager.getJsDocValue(jsDoc, jsonTranslate, "arbitraryParams", false).toString()));
                jsonMethod.set("multilayer", Boolean.parseBoolean(CronapiManager.getJsDocValue(jsDoc, jsonTranslate, "multilayer", false).toString()));
                jsonMethod.set("params", this.getParams(paramsNames, jsDoc, jsonTranslate));
                if (this.existFunction(services, functionName).booleanValue()) continue;
                services.add(jsonMethod);
            }
        }
    }

    private JsonArray getParams(String[] paramsNames, String jsDoc, JsonObject jsonTranslate) {
        JsonArray array = new JsonArray();
        JsonArray paramsFromMethod = new JsonArray();
        if (!jsDoc.isEmpty()) {
            Pattern patternJsDoc = Pattern.compile("\\@.*");
            Matcher matcherJsDoc = patternJsDoc.matcher(jsDoc);
            while (matcherJsDoc.find()) {
                String[] values = matcherJsDoc.group().replace("@", "").split(" ", 2);
                if (!values[0].trim().equals("param")) continue;
                String[] paramSplited = values[1].split(Pattern.quote(" "), 3);
                String type = paramSplited[0].replace("{", "").replace("}", "").trim();
                String name = paramSplited[1].trim();
                if (paramSplited.length > 2) {
                    name = CronapiManager.getPropertyFromJsonI18n(jsonTranslate, paramSplited[2].trim());
                }
                JsonObject jsonParam = new JsonObject();
                jsonParam.set("name", name);
                jsonParam.set("type", type);
                paramsFromMethod.add(jsonParam);
            }
        }
        int i = 0;
        while (i < paramsNames.length) {
            String p = paramsNames[i];
            if (!p.trim().isEmpty()) {
                String jsDocParam = CronapiManager.getJSDocFromString(p);
                if (!jsDocParam.isEmpty()) {
                    p = p.substring(p.indexOf("*/") + 2);
                }
                JsonObject jsonFromParameter = new JsonObject();
                if (!jsDocParam.isEmpty()) {
                    Pattern patternJsDoc = Pattern.compile("\\@.*?\\s.*?\\s|\\@.*?\\s.*?\\*");
                    Matcher matcherJsDoc = patternJsDoc.matcher(jsDocParam);
                    while (matcherJsDoc.find()) {
                        String[] values = matcherJsDoc.group().replace("@", "").split(" ", 2);
                        String key = values[0].trim();
                        String value = values[1].trim().replace("*", "");
                        if (value.startsWith("{{")) {
                            value = CronapiManager.getPropertyFromJsonI18n(jsonTranslate, value.trim());
                        }
                        value = value.replace("{", "").replace("}", "");
                        jsonFromParameter.set(key, value);
                    }
                }
                JsonObject finalObj = new JsonObject();
                String finalName = p;
                if (paramsFromMethod.size() > i) {
                    finalName = paramsFromMethod.get(i).asObject().get("name").asString();
                }
                if (jsonFromParameter.get("description") != null && !jsonFromParameter.get("description").isNull()) {
                    finalName = jsonFromParameter.get("description").asString();
                }
                finalObj.set("name", finalName);
                String finalType = "";
                if (paramsFromMethod.size() > i) {
                    finalType = paramsFromMethod.get(i).asObject().get("type").asString();
                }
                if (jsonFromParameter.get("type") != null && !jsonFromParameter.get("type").isNull()) {
                    finalType = jsonFromParameter.get("type").asString();
                }
                finalObj.set("type", finalType);
                String blockType = "";
                if (jsonFromParameter.get("blockType") != null && !jsonFromParameter.get("blockType").isNull()) {
                    blockType = jsonFromParameter.get("blockType").asString();
                }
                finalObj.set("blockType", blockType);
                String defaultValue = "";
                if (jsonFromParameter.get("defaultValue") != null && !jsonFromParameter.get("defaultValue").isNull()) {
                    defaultValue = jsonFromParameter.get("defaultValue").asString();
                }
                finalObj.set("defaultValue", defaultValue);
                JsonArray values = new JsonArray();
                if (jsonFromParameter.get("values") != null && !jsonFromParameter.get("values").isNull()) {
                    values = CronapiManager.getSplitedValue(jsonFromParameter.get("values").asString());
                }
                finalObj.set("values", values);
                JsonArray keys = new JsonArray();
                if (jsonFromParameter.get("keys") != null && !jsonFromParameter.get("keys").isNull()) {
                    keys = CronapiManager.getSplitedValue(jsonFromParameter.get("keys").asString());
                }
                finalObj.set("keys", keys);
                array.add(finalObj);
            }
            ++i;
        }
        if (array.size() == 0 && paramsFromMethod.size() > 0) {
            i = 0;
            while (i < paramsFromMethod.size()) {
                JsonObject finalObj = new JsonObject();
                String finalName = paramsFromMethod.get(i).asObject().get("name").asString();
                finalObj.set("name", finalName);
                String finalType = paramsFromMethod.get(i).asObject().get("type").asString();
                finalObj.set("type", finalType);
                finalObj.set("blockType", "");
                finalObj.set("defaultValue", "");
                finalObj.set("values", "");
                finalObj.set("keys", "");
                array.add(finalObj);
                ++i;
            }
        }
        return array;
    }

    private static JsonArray getSplitedValue(String value) {
        JsonArray array = new JsonArray();
        if (value != null) {
            String[] splited;
            String[] stringArray = splited = value.split(Pattern.quote("|"));
            int n = splited.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                array.add(string);
                ++n2;
            }
        }
        return array;
    }

    private static Object getJsDocValue(String jsDoc, JsonObject jsonTranslate, String name, Object defaultValue) {
        return CronapiManager.getJsDocValue(jsDoc, jsonTranslate, name, defaultValue, false);
    }

    private static Object getJsDocValue(String jsDoc, JsonObject jsonTranslate, String name, Object defaultValue, boolean forceJsonArray) {
        if (!jsDoc.isEmpty()) {
            Pattern patternJsDoc = Pattern.compile("\\@.*");
            Matcher matcherJsDoc = patternJsDoc.matcher(jsDoc);
            while (matcherJsDoc.find()) {
                String[] values = matcherJsDoc.group().replace("@", "").split(" ", 2);
                if (!values[0].equals(name)) continue;
                if (values[1].contains("|") || forceJsonArray) {
                    String[] splited = values[1].split(Pattern.quote("|"));
                    JsonArray array = new JsonArray();
                    String[] stringArray = splited;
                    int n = splited.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        array.add(CronapiManager.getStringResult(jsonTranslate, s, false));
                        ++n2;
                    }
                    return array;
                }
                return CronapiManager.getStringResult(jsonTranslate, values[1], false);
            }
        }
        return defaultValue;
    }

    private static String getStringResult(JsonObject jsonTranslate, String resultAsString, boolean forceTranslate) {
        if (resultAsString.startsWith("{{") || forceTranslate) {
            resultAsString = CronapiManager.getPropertyFromJsonI18n(jsonTranslate, resultAsString);
        }
        resultAsString = resultAsString.replace("{", "").replace("}", "");
        return resultAsString;
    }

    private static Map<String, String> fillJsDocFromCategories(String content, String prefixPackage) {
        HashMap<String, String> keyCategories = new HashMap<String, String>();
        Pattern patternCategories = Pattern.compile("\\b" + prefixPackage + "\\..*=\\s+\\{|\\b" + prefixPackage + "\\..*=[^\\n]+\\|\\|\\{\\}|\\b" + prefixPackage + "\\..*=.*\\b" + prefixPackage + "\\..*\\|\\|\\s+\\{");
        Matcher matcherCategories = patternCategories.matcher(content);
        while (matcherCategories.find()) {
            String categoryNameSpace = "";
            if (!matcherCategories.group().startsWith(prefixPackage)) continue;
            categoryNameSpace = matcherCategories.group().substring(0, matcherCategories.group().indexOf(" "));
            String jsDoc = CronapiManager.getJSDoc(matcherCategories, content);
            keyCategories.put(categoryNameSpace, jsDoc);
        }
        return keyCategories;
    }

    private static boolean isJsDocTypeFunction(String jsDoc, String functionType) {
        boolean result = false;
        if (!jsDoc.isEmpty()) {
            Pattern patternJsDoc = Pattern.compile("\\@.*");
            Matcher matcherJsDoc = patternJsDoc.matcher(jsDoc);
            while (matcherJsDoc.find()) {
                String[] values = matcherJsDoc.group().replace("@", "").split(" ", 2);
                if (!values[0].equals("type") || !values[1].equals(functionType)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private static Object getInfoFromCategory(String functionName, Map<String, String> keyCategories, JsonObject jsonTranslate, String typeInfo, Object defaultValue) {
        for (String key : keyCategories.keySet()) {
            String jsDoc;
            if (!functionName.contains(key) || (jsDoc = keyCategories.get(key)) == null || jsDoc.isEmpty()) continue;
            return CronapiManager.getJsDocValue(jsDoc, jsonTranslate, typeInfo, defaultValue, defaultValue instanceof JsonArray);
        }
        return new JsonArray();
    }

    private static String getPropertyFromJsonI18n(JsonObject jsonTranslate, String value) {
        String property = value.replace("{{", "").replace("}}", "").trim();
        property = property.replace("{", "").replace("}", "").trim();
        String result = "";
        try {
            if (jsonTranslate != null) {
                if (property.contains("|")) {
                    String[] splited;
                    String[] stringArray = splited = property.split(Pattern.quote("|"));
                    int n = splited.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        String translate = jsonTranslate.get(string) != null ? jsonTranslate.get(string).asString() : string;
                        property = property.replace(string, translate);
                        ++n2;
                    }
                } else {
                    result = jsonTranslate.get(property) != null ? jsonTranslate.get(property).asString() : property;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (result == null || result.isEmpty()) {
            result = property;
        }
        return result;
    }

    public static String getJSDoc(Matcher matcher, String content) {
        String doc = "";
        try {
            int endIndex = matcher.start() - 1;
            boolean stopSearch = false;
            if (endIndex - 5 > -1 && "this".equals(content.substring(endIndex - 4, endIndex).trim())) {
                endIndex -= 5;
            }
            while (!stopSearch && endIndex > -1) {
                if (' ' == content.charAt(endIndex) || '\t' == content.charAt(endIndex) || '\n' == content.charAt(endIndex) || '\r' == content.charAt(endIndex)) {
                    --endIndex;
                    continue;
                }
                if ('/' == content.charAt(endIndex) && endIndex > 0 && '*' == content.charAt(endIndex - 1)) {
                    stopSearch = true;
                    boolean allCopiedJSDoc = false;
                    while (!allCopiedJSDoc) {
                        if (endIndex > 1 && '*' == content.charAt(endIndex) && '*' == content.charAt(endIndex - 1) && '/' == content.charAt(endIndex - 2)) {
                            allCopiedJSDoc = true;
                            doc = "/**" + doc;
                        } else {
                            doc = String.valueOf(content.charAt(endIndex)) + doc;
                        }
                        --endIndex;
                    }
                    continue;
                }
                stopSearch = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return doc;
    }

    public static String getJSDocFromString(String content) {
        String doc = "";
        try {
            int endIndex = content.indexOf("*/") + 1;
            boolean stopSearch = false;
            if (endIndex - 5 > -1 && "this".equals(content.substring(endIndex - 4, endIndex).trim())) {
                endIndex -= 5;
            }
            while (!stopSearch && endIndex > -1) {
                if (' ' == content.charAt(endIndex) || '\t' == content.charAt(endIndex) || '\n' == content.charAt(endIndex) || '\r' == content.charAt(endIndex)) {
                    --endIndex;
                    continue;
                }
                if ('/' == content.charAt(endIndex) && endIndex > 0 && '*' == content.charAt(endIndex - 1)) {
                    stopSearch = true;
                    boolean allCopiedJSDoc = false;
                    while (!allCopiedJSDoc) {
                        if (endIndex > 1 && '*' == content.charAt(endIndex) && '*' == content.charAt(endIndex - 1) && '/' == content.charAt(endIndex - 2)) {
                            allCopiedJSDoc = true;
                            doc = "/**" + doc;
                        } else {
                            doc = String.valueOf(content.charAt(endIndex)) + doc;
                        }
                        --endIndex;
                    }
                    continue;
                }
                stopSearch = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return doc;
    }

    private void fillCronapiJsFilesAndTranslateJsonFiles(IContainer webApp, List<IFile> cronapiFiles, List<JsonObject> jsonTranslateFiles) throws Exception {
        if (webApp.exists()) {
            IResource[] members;
            IResource[] iResourceArray = members = webApp.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray[n2];
                if (iResource instanceof IFile) {
                    IFile file = (IFile)iResource;
                    if (file.getName().contains(this.cronapiJsFile) && (file.getName().endsWith(".js") || file.getName().endsWith(".ts")) && !file.getName().endsWith(".min.js") && !file.getFullPath().toString().contains("/bin/")) {
                        cronapiFiles.add(file);
                        IContainer parentFolder = iResource.getParent();
                        if (parentFolder.findMember(String.format(PATH_I18N_JSON_LOCALE, this.language.toLowerCase())) != null) {
                            IFile localeJson = (IFile)parentFolder.findMember(String.format(PATH_I18N_JSON_LOCALE, this.language.toLowerCase()));
                            JsonObject json = JsonObject.readFrom(this.getFileContent(localeJson));
                            jsonTranslateFiles.add(json);
                        } else {
                            jsonTranslateFiles.add(null);
                        }
                    }
                } else if (iResource instanceof IFolder) {
                    this.fillCronapiJsFilesAndTranslateJsonFiles((IContainer)((Folder)iResource), cronapiFiles, jsonTranslateFiles);
                }
                ++n2;
            }
        }
    }
}

