/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.java.commands.plugin.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;

public class CronapiCollector
extends SearchRequestor {
    private static final Logger logger = Logger.getLogger("cronapp");
    private static final Pattern i18nPattern = Pattern.compile("\\{\\{(.*?)}}");
    private static final String ANNOTATION_CRONAPI_METADATA = "CronapiMetaData";
    private static final String ANNOTATION_CRONAPI_PARAM_METADATA = "ParamMetaData";
    private final JsonArray missingTranslations = new JsonArray();
    private final JsonArray cronapi = new JsonArray();
    private final String locale;
    private final Map<IPackageFragmentRoot, Properties> i18nCache = new HashMap<IPackageFragmentRoot, Properties>();

    public CronapiCollector(String locale) {
        this.locale = locale;
    }

    public JsonArray getMissingTranslations() {
        return this.missingTranslations;
    }

    public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
        Object element = searchMatch.getElement();
        if (!(element instanceof IType)) {
            return;
        }
        IType type = (IType)element;
        JsonElement jsonType = this.collectType(type);
        if (jsonType != null) {
            this.cronapi.add(jsonType);
        }
    }

    private String translate(String s, IPackageFragment packageFragment) {
        Properties i18n;
        IPackageFragmentRoot packageFragmentRoot = null;
        if (packageFragment.getParent() instanceof IPackageFragmentRoot) {
            packageFragmentRoot = (IPackageFragmentRoot)packageFragment.getParent();
        } else {
            logger.log(Level.SEVERE, "Cannot find IPackageFragmentRoot");
        }
        if (packageFragmentRoot == null) {
            i18n = new Properties();
        } else if (this.i18nCache.containsKey(packageFragmentRoot)) {
            i18n = this.i18nCache.get(packageFragmentRoot);
        } else {
            i18n = new Properties();
            try {
                String i18nFileName = "Messages_" + this.locale + ".properties";
                IPackageFragment i18nPackage = packageFragmentRoot.getPackageFragment("i18n");
                IResource i18nResource = Arrays.stream(i18nPackage.getNonJavaResources()).filter(e -> e instanceof IResource).map(e -> (IResource)e).filter(e -> e.getName().equals(i18nFileName)).findFirst().orElse(null);
                if (i18nResource != null) {
                    Throwable throwable = null;
                    Object var9_11 = null;
                    try (FileInputStream i18nStream = new FileInputStream(i18nResource.getRawLocation().toFile());){
                        i18n.load(i18nStream);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                this.i18nCache.put(packageFragmentRoot, i18n);
            }
            catch (IOException | JavaModelException e2) {
                logger.log(Level.SEVERE, e2.getMessage(), e2);
            }
        }
        Matcher matcher = i18nPattern.matcher(s);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String term = matcher.group(1);
            String translated = "";
            if (i18n.containsKey(term)) {
                translated = i18n.getProperty(term);
            } else {
                this.missingTranslations.add(term);
            }
            if (translated.isEmpty()) {
                translated = term;
            }
            matcher.appendReplacement(buffer, translated);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private JsonElement collectType(IType type) throws JavaModelException {
        IAnnotation cronapiMetaData = type.getAnnotation(ANNOTATION_CRONAPI_METADATA);
        if (cronapiMetaData == null || !cronapiMetaData.exists()) {
            return null;
        }
        JsonObject jsonType = new JsonObject();
        String i18nType = type.getFullyQualifiedName();
        String typeName = Arrays.stream(cronapiMetaData.getMemberValuePairs()).filter(e -> e.getMemberName().equals("categoryName") || e.getMemberName().equals("category")).map(e -> e.getValue().toString()).findFirst().orElse("{{" + i18nType + ".Name}}");
        String typeDescription = Arrays.stream(cronapiMetaData.getMemberValuePairs()).filter(e -> e.getMemberName().equals("description")).map(e -> e.getValue().toString()).findFirst().orElse("{{" + i18nType + ".Description}}");
        typeName = this.translate(typeName, type.getPackageFragment());
        typeDescription = this.translate(typeDescription, type.getPackageFragment());
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            this.collectMethod(method, i18nType);
            ++n2;
        }
        return jsonType;
    }

    private JsonElement collectMethod(IMethod method, String i18nType) throws JavaModelException {
        IAnnotation cronapiMetaData = method.getAnnotation(ANNOTATION_CRONAPI_METADATA);
        if (cronapiMetaData == null || !cronapiMetaData.exists()) {
            return null;
        }
        JsonObject jsonMethod = new JsonObject();
        String i18nMethod = String.valueOf(i18nType) + ".Method." + method.getElementName();
        String methodName = Arrays.stream(cronapiMetaData.getMemberValuePairs()).filter(e -> e.getMemberName().equals("name")).map(e -> e.getValue().toString()).findFirst().orElse("{{" + i18nMethod + ".Name}}");
        String methodDescription = Arrays.stream(cronapiMetaData.getMemberValuePairs()).filter(e -> e.getMemberName().equals("description")).map(e -> e.getValue().toString()).findFirst().orElse("{{" + i18nMethod + ".Description}}");
        this.translate(methodName, method.getDeclaringType().getPackageFragment());
        this.translate(methodDescription, method.getDeclaringType().getPackageFragment());
        ILocalVariable[] iLocalVariableArray = method.getParameters();
        int n = iLocalVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalVariable parameter = iLocalVariableArray[n2];
            this.collectParameter(parameter, i18nMethod);
            ++n2;
        }
        return jsonMethod;
    }

    private JsonElement collectParameter(ILocalVariable parameter, String i18nMethod) throws JavaModelException {
        JsonObject jsonParameter = new JsonObject();
        String i18nParameter = String.valueOf(i18nMethod) + ".Parameter." + parameter.getElementName();
        String parameterDescription = "{{" + i18nParameter + ".Description}}";
        IAnnotation cronapiMetaData = parameter.getAnnotation(ANNOTATION_CRONAPI_PARAM_METADATA);
        if (cronapiMetaData != null && cronapiMetaData.exists()) {
            parameterDescription = Arrays.stream(cronapiMetaData.getMemberValuePairs()).filter(e -> e.getMemberName().equals("description")).map(e -> e.getValue().toString()).findFirst().orElse(parameterDescription);
        }
        this.translate(parameterDescription, parameter.getDeclaringMember().getDeclaringType().getPackageFragment());
        return jsonParameter;
    }
}

