/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.java.commands.plugin.util;

import java.net.URL;

public class CompositeClassloader
extends ClassLoader {
    private final ClassLoader fallback;

    public CompositeClassloader(ClassLoader parent, ClassLoader fallback) {
        super(parent);
        this.fallback = fallback;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.fallback != null) {
            return this.fallback.loadClass(name);
        }
        return super.findClass(name);
    }

    @Override
    protected URL findResource(String name) {
        if (this.fallback != null) {
            return this.fallback.getResource(name);
        }
        return super.findResource(name);
    }
}

