/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.java.commands.plugin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.cronapp.java.commands.plugin.util.SearchManager;
import java.util.List;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.core.ResolvedBinaryType;
import org.eclipse.jdt.internal.core.ResolvedSourceType;
import org.eclipse.jdt.internal.core.SourceType;

public class SearchHandler {
    private String parseLocation(String location) {
        location = location.replace("=", "");
        location = location.substring(0, location.indexOf("<"));
        if ((location = location.replace("\\/", "/")).startsWith("/")) {
            location = location.substring(1);
        }
        return location;
    }

    public Object search(List<Object> arguments) throws Exception {
        String projectId = arguments.get(0).toString();
        String text = arguments.get(1).toString();
        JsonObject json = new JsonObject();
        JsonArray values = new JsonArray();
        json.add("matches", (JsonElement)values);
        text = text.trim();
        text = text.replace(".", "");
        if (text.length() > 0 && !text.contains("*")) {
            text = String.valueOf(text) + "*";
        }
        List<SearchMatch> result = SearchManager.search(projectId, text);
        int i = 0;
        if (result != null) {
            for (SearchMatch match : result) {
                ResolvedBinaryType type;
                JsonObject obj = new JsonObject();
                if (i >= 100) {
                    obj.addProperty("name", "...");
                    obj.addProperty("fullname", "...");
                    obj.addProperty("location", "...");
                    values.add((JsonElement)obj);
                    break;
                }
                if (match.getElement() instanceof ResolvedBinaryType) {
                    type = (ResolvedBinaryType)match.getElement();
                    obj.addProperty("name", type.getElementName());
                    obj.addProperty("fullname", type.getFullyQualifiedName());
                    obj.addProperty("location", this.parseLocation(type.getHandleMemento()));
                    values.add((JsonElement)obj);
                    ++i;
                    continue;
                }
                if (match.getElement() instanceof ResolvedSourceType) {
                    type = (ResolvedSourceType)match.getElement();
                    obj.addProperty("name", type.getElementName());
                    obj.addProperty("fullname", type.getFullyQualifiedName());
                    obj.addProperty("location", this.parseLocation(type.getHandleMemento()));
                    obj.addProperty("path", type.getResource().getFullPath().toString().replace("/" + projectId.replace("-", "") + "/", ""));
                    values.add((JsonElement)obj);
                    ++i;
                    continue;
                }
                if (!(match.getElement() instanceof SourceType)) continue;
                type = (SourceType)match.getElement();
                obj.addProperty("name", type.getElementName());
                obj.addProperty("fullname", type.getFullyQualifiedName());
                obj.addProperty("location", this.parseLocation(type.getHandleMemento()));
                obj.addProperty("path", type.getResource().getFullPath().toString().replace("/" + projectId.replace("-", "") + "/", ""));
                values.add((JsonElement)obj);
                ++i;
            }
        }
        return json;
    }
}

