/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.java.commands.plugin;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.cronapp.java.commands.plugin.util.CronapiManager;
import io.cronapp.java.commands.plugin.util.JdtUtils;
import io.cronapp.java.commands.plugin.util.ProjectInfo;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;

public class ResolveCustomBlocklyHandler {
    public Object resolveCustomBlockly(List<Object> arguments) throws Exception {
        ProjectInfo projectInfo = (ProjectInfo)new Gson().fromJson(new Gson().toJson(arguments.get(0)), ProjectInfo.class);
        String projectName = (String)arguments.get(1);
        IJavaProject javaProject = JdtUtils.getJavaProject(projectName);
        String language = (String)arguments.get(2);
        String codeType = (String)arguments.get(3);
        List strList = (List)arguments.get(4);
        String[] webContext = strList.toArray(new String[strList.size()]);
        CronapiManager manager = new CronapiManager(projectInfo, projectName, javaProject, language, codeType, webContext, "blockly");
        manager.setCronapiJsFile(".blockly.");
        manager.setPrefixPackage("blockly");
        JsonArray json = (JsonArray)new JsonParser().parse(manager.listMetaDataMethods().toString());
        JsonArray result = new JsonArray();
        for (JsonElement element : json) {
            JsonObject blockly = this.getJsonObject(result, element.getAsJsonObject(), codeType, webContext);
            JsonObject method = new JsonObject();
            String name = element.getAsJsonObject().get("name").getAsString();
            name = name.substring(name.lastIndexOf(".") + 1, name.length());
            method.addProperty("name", name);
            method.addProperty("hasReturn", String.valueOf(!element.getAsJsonObject().get("returnType").getAsString().equals("ObjectType.VOID")));
            JsonArray params = new JsonArray();
            for (JsonElement param : element.getAsJsonObject().get("params").getAsJsonArray()) {
                params.add(param.getAsJsonObject().get("name").getAsString());
            }
            method.add("params", (JsonElement)params);
            blockly.getAsJsonArray("methods").add((JsonElement)method);
        }
        JsonObject responseObj = new JsonObject();
        responseObj.add("elems", (JsonElement)result);
        return responseObj;
    }

    private JsonObject getJsonObject(JsonArray result, JsonObject json, String language, String[] webContext) {
        String name = json.getAsJsonPrimitive("name").getAsString();
        name = name.substring(0, name.lastIndexOf("."));
        String path = json.getAsJsonPrimitive("path").getAsString();
        for (JsonElement element : result) {
            if (!element.getAsJsonObject().getAsJsonPrimitive("namespace").getAsString().equalsIgnoreCase(name)) continue;
            return element.getAsJsonObject();
        }
        JsonObject obj = new JsonObject();
        if (language.equals("javascript")) {
            obj.addProperty("language", "js");
        } else {
            obj.addProperty("language", language);
        }
        obj.addProperty("namespace", name);
        obj.addProperty("class", name);
        obj.addProperty("sourcePath", path);
        obj.add("methods", (JsonElement)new JsonArray());
        result.add((JsonElement)obj);
        return obj;
    }
}

