/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.java.commands.plugin;

import com.google.gson.JsonParser;
import io.cronapp.java.commands.plugin.util.JdtUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.changes.RenamePackageChange;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.rename.RenameCompilationUnitProcessor;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.rename.RenameLocalVariableProcessor;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.rename.RenamePackageProcessor;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.rename.RenameVirtualMethodProcessor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;

public class RenameOperationHandler {
    private static final String RENAME_PACKAGE = "renamePackage";
    private static final String RENAME_CLASS = "renameClass";
    private static final String RENAME_PARAMETER = "renameParameter";
    private static final String RENAME_FIELD = "renameField";
    private static final String RENAME_METHOD = "renameMethod";
    private String projectId;
    private String fullPackageName;
    private String contentModified;
    private String contentOriginal;
    private String oldValue;
    private String newValue;
    private JsonObject json;
    private boolean hasConflitResource;
    private int row;
    private int column;
    private boolean isInnerClass;
    private JsonArray jsonAffectedObjects;
    private IJavaProject javaProject;

    public Object exec(List<Object> arguments) throws Exception {
        this.projectId = arguments.get(0).toString();
        this.fullPackageName = arguments.get(1).toString();
        this.json = JsonObject.readFrom((String)arguments.get(2));
        this.contentOriginal = this.json.get("contentOriginal").asString();
        this.contentModified = this.json.get("contentModified").asString();
        this.newValue = this.json.get("newValue").asString();
        this.oldValue = this.json.get("oldValue").asString();
        this.row = this.json.get("row").asInt();
        this.column = this.json.get("column").asInt();
        this.isInnerClass = false;
        this.javaProject = JdtUtils.getJavaProject(this.projectId);
        ICompilationUnit cu = null;
        if (!this.json.get("action").asString().equals(RENAME_PACKAGE)) {
            cu = JdtUtils.getCompilationUnit(this.javaProject, this.fullPackageName);
        }
        if (this.contentModified != null && !this.contentModified.isEmpty() && cu != null) {
            cu.getBuffer().setContents(this.contentModified);
            cu.reconcile(0, false, null, null);
        }
        int offSet = this.getOffSet();
        ArrayList<SourceType> sourceTypes = new ArrayList<SourceType>();
        if (cu != null) {
            RenameOperationHandler.fillAllSourceTypes((SourceType)cu.getTypes()[0], sourceTypes);
        }
        this.jsonAffectedObjects = new JsonArray();
        if (this.json.get("action").asString().equals(RENAME_METHOD)) {
            this.renameMethod(sourceTypes, offSet);
        } else if (this.json.get("action").asString().equals(RENAME_FIELD)) {
            this.renameField(sourceTypes, offSet);
        } else if (this.json.get("action").asString().equals(RENAME_PARAMETER)) {
            this.renameParameter(sourceTypes, offSet, cu);
        } else if (this.json.get("action").asString().equals(RENAME_CLASS)) {
            this.renameClass(sourceTypes, offSet, cu);
        } else if (this.json.get("action").asString().equals(RENAME_PACKAGE)) {
            this.renamePackage();
        }
        JsonObject result = new JsonObject();
        result.add("hasConflitResource", this.hasConflitResource);
        result.add("jsonAffectedObjects", this.jsonAffectedObjects);
        result.add("isInnerClass", this.isInnerClass);
        return new JsonParser().parse(result.toString());
    }

    public static void fillAllSourceTypes(SourceType sourceType, List<SourceType> sourceTypes) throws JavaModelException {
        sourceTypes.add(sourceType);
        if (sourceType.hasChildren()) {
            int i = 0;
            while (i < sourceType.getChildren().length) {
                if (sourceType.getChildren()[i] instanceof SourceType) {
                    RenameOperationHandler.fillAllSourceTypes((SourceType)sourceType.getChildren()[i], sourceTypes);
                }
                ++i;
            }
        }
    }

    private void renamePackage() throws Exception {
        IPackageFragmentRoot[] packagesFragmentsRoot;
        IPackageFragment selected = null;
        String fullNamePackage = "";
        JsonArray allOpenResources = this.json.get("allOpenResources").asArray();
        this.jsonAffectedObjects = new JsonArray();
        int i = 0;
        while (i < allOpenResources.size()) {
            JsonObject openFile = allOpenResources.get(i).asObject();
            if (openFile.get("fullPackageName").asString().contains(this.oldValue)) {
                JsonObject conflited = new JsonObject();
                conflited.add("fullPackageName", openFile.get("fullPackageName").asString());
                conflited.add("conflicted", true);
                this.jsonAffectedObjects.add(conflited);
                this.hasConflitResource = true;
            }
            ++i;
        }
        if (this.hasConflitResource) {
            return;
        }
        IPackageFragmentRoot[] iPackageFragmentRootArray = packagesFragmentsRoot = this.javaProject.getAllPackageFragmentRoots();
        int n = packagesFragmentsRoot.length;
        int conflited = 0;
        while (conflited < n) {
            IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[conflited];
            if (!packageFragmentRoot.isArchive()) {
                IJavaElement[] iJavaElementArray = packageFragmentRoot.getChildren();
                int n2 = iJavaElementArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IJavaElement pkg = iJavaElementArray[n3];
                    if (pkg != null && pkg.getElementName() != null && !pkg.getElementName().isEmpty() && pkg instanceof IPackageFragment && (fullNamePackage = this.GetFullNamePackageFromPath(pkg.getPath().toString())).equals(this.oldValue)) {
                        selected = (IPackageFragment)pkg;
                        break;
                    }
                    ++n3;
                }
            }
            ++conflited;
        }
        if (selected == null) {
            throw new Exception("Package not found");
        }
        RenamePackageProcessor processor = new RenamePackageProcessor(selected);
        processor.setUpdateReferences(true);
        processor.setRenameSubpackages(true);
        String sourceFolder = this.GetSourceFolderFromHandlerIdentifier(selected.getHandleIdentifier());
        String newValueFullPackage = this.newValue.replace(sourceFolder, "");
        newValueFullPackage = newValueFullPackage.replaceAll("/", ".");
        processor.setNewElementName(newValueFullPackage);
        Change changes = this.getChanges((RenameProcessor)processor);
        this.jsonAffectedObjects = this.GetAffectedObjectsJson(changes);
        if (!this.hasConflitResource) {
            changes.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
            changes.perform((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private String GetSourceFolderFromHandlerIdentifier(String handleIdentifier) {
        int lengthProjectId = this.projectId.replaceAll("-", "").length();
        String sourceFolder = handleIdentifier.substring(lengthProjectId + 2, handleIdentifier.length());
        sourceFolder = sourceFolder.replaceAll("\\/", "").replaceAll("\\\\", "/");
        sourceFolder = String.valueOf(sourceFolder.substring(0, sourceFolder.indexOf("<"))) + "/";
        return sourceFolder;
    }

    private String GetFullNamePackageFromPath(String fullNamePackage) {
        int lengthProjectId = this.projectId.replaceAll("-", "").length();
        fullNamePackage = fullNamePackage.substring(lengthProjectId + 2, fullNamePackage.length());
        return fullNamePackage;
    }

    private void renameClass(List<SourceType> sourceTypes, int offSet, ICompilationUnit cu) throws Exception {
        Change changes;
        RenameCompilationUnitProcessor processor;
        if (this.oldValue.contains(".java")) {
            this.oldValue = this.oldValue.substring(0, this.oldValue.indexOf(".java"));
        }
        boolean isFirstClass = this.row == 0 && this.column == 0;
        int index = 0;
        SourceType sourceTypeToChange = null;
        for (SourceType sourceType : sourceTypes) {
            if (sourceType.getElementName().equals(this.oldValue) && this.SameOffSet(sourceType.getNameRange().getOffset(), offSet)) {
                sourceTypeToChange = sourceType;
                break;
            }
            ++index;
        }
        if (index == 0 || isFirstClass) {
            processor = new RenameCompilationUnitProcessor(cu);
            processor.setUpdateReferences(true);
            if (!this.newValue.contains(".java")) {
                this.newValue = String.valueOf(this.newValue) + ".java";
            }
            processor.setNewElementName(this.newValue);
            changes = this.getChanges((RenameProcessor)processor);
            this.jsonAffectedObjects = this.GetAffectedObjectsJson(changes);
            if (!this.hasConflitResource) {
                changes.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                changes.perform((IProgressMonitor)new NullProgressMonitor());
            }
        } else if (sourceTypeToChange != null) {
            this.isInnerClass = true;
            if (this.newValue.contains(".java")) {
                this.newValue = this.newValue.substring(0, this.newValue.indexOf(".java"));
            }
            processor = new RenameTypeProcessor(sourceTypeToChange);
            processor.setUpdateReferences(true);
            processor.setNewElementName(this.newValue);
            changes = this.getChanges((RenameProcessor)processor);
            this.jsonAffectedObjects = this.GetAffectedObjectsJson(changes);
            if (!this.hasConflitResource) {
                changes.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                changes.perform((IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    private void renameParameter(List<SourceType> sourceTypes, int offSet, ICompilationUnit cu) throws Exception {
        ILocalVariable parameterToRename = null;
        for (SourceType sourceType : sourceTypes) {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = sourceType.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalVariable[] parameters;
                IMethod m = iMethodArray[n2];
                ILocalVariable[] iLocalVariableArray = parameters = m.getParameters();
                int n3 = parameters.length;
                int n4 = 0;
                while (n4 < n3) {
                    ILocalVariable p = iLocalVariableArray[n4];
                    if (p.getElementName().equals(this.oldValue) && this.SameOffSet(p.getNameRange().getOffset(), offSet)) {
                        parameterToRename = p;
                        break;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        RenameLocalVariableProcessor processor = new RenameLocalVariableProcessor(parameterToRename);
        processor.setUpdateReferences(true);
        processor.setNewElementName(this.newValue);
        this.fillRequiredObjsInRenameLocalVariableProcessor(processor, parameterToRename, cu);
        Change changes = this.getChanges((RenameProcessor)processor);
        this.jsonAffectedObjects = this.GetAffectedObjectsJson(changes);
        if (!this.hasConflitResource) {
            changes.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
            changes.perform((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void renameField(List<SourceType> sourceTypes, int offSet) throws Exception {
        IField fieldToRename = null;
        block0: for (SourceType sourceType : sourceTypes) {
            IField[] fields;
            IField[] iFieldArray = fields = sourceType.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField f = iFieldArray[n2];
                if (f.getElementName().equals(this.oldValue) && this.SameOffSet(f.getNameRange().getOffset(), offSet)) {
                    fieldToRename = f;
                    continue block0;
                }
                ++n2;
            }
        }
        RenameFieldProcessor processor = new RenameFieldProcessor(fieldToRename);
        processor.setUpdateReferences(true);
        processor.setNewElementName(this.newValue);
        Change changes = this.getChanges((RenameProcessor)processor);
        this.jsonAffectedObjects = this.GetAffectedObjectsJson(changes);
        if (!this.hasConflitResource) {
            changes.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
            changes.perform((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void renameMethod(List<SourceType> sourceTypes, int offSet) throws Exception {
        IMethod methodToRename = null;
        block0: for (SourceType sourceType : sourceTypes) {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = sourceType.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod m = iMethodArray[n2];
                if (m.getElementName().equals(this.oldValue) && this.SameOffSet(m.getNameRange().getOffset(), offSet)) {
                    methodToRename = m;
                    continue block0;
                }
                ++n2;
            }
        }
        RenameVirtualMethodProcessor processor = new RenameVirtualMethodProcessor(methodToRename);
        processor.setUpdateReferences(true);
        processor.setNewElementName(this.newValue);
        Change changes = this.getChanges((RenameProcessor)processor);
        this.jsonAffectedObjects = this.GetAffectedObjectsJson(changes);
        if (!this.hasConflitResource) {
            changes.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
            changes.perform((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void fillRequiredObjsInRenameLocalVariableProcessor(RenameLocalVariableProcessor processor, ILocalVariable parameterToRename, ICompilationUnit cu) throws Exception {
        ISourceRange sourceRange = parameterToRename.getNameRange();
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(cu.getTypes()[0].getCompilationUnit());
        parser.setResolveBindings(true);
        ASTNode nameCU = parser.createAST((IProgressMonitor)new NullProgressMonitor());
        ASTNode name = NodeFinder.perform((ASTNode)nameCU, (ISourceRange)sourceRange);
        VariableDeclaration vdc = null;
        if (name.getParent() instanceof VariableDeclaration) {
            vdc = (VariableDeclaration)name.getParent();
        }
        Class<?> c = processor.getClass();
        Field fTempDeclarationNode = c.getDeclaredField("fTempDeclarationNode");
        fTempDeclarationNode.setAccessible(true);
        fTempDeclarationNode.set(processor, vdc);
        Field fCurrentName = c.getDeclaredField("fCurrentName");
        fCurrentName.setAccessible(true);
        fCurrentName.set(processor, this.oldValue);
        Field fCompilationUnitNode = c.getDeclaredField("fCompilationUnitNode");
        fCompilationUnitNode.setAccessible(true);
        fCompilationUnitNode.set(processor, nameCU);
    }

    private JsonArray GetAffectedObjectsJson(Change changes) throws Exception {
        JsonArray jsonAffectedObjects;
        block4: {
            JsonArray allOpenResources;
            block3: {
                this.hasConflitResource = false;
                allOpenResources = this.json.get("allOpenResources").asArray();
                jsonAffectedObjects = new JsonArray();
                if (changes.getAffectedObjects() == null) break block3;
                Object[] objectArray = changes.getAffectedObjects();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object aObj = objectArray[n2];
                    CompilationUnit cuObj = (CompilationUnit)aObj;
                    this.addCompilationUnitToJsonCheckIfIsConflicted(cuObj, jsonAffectedObjects, allOpenResources);
                    ++n2;
                }
                break block4;
            }
            CompositeChange cc = (CompositeChange)changes;
            if (cc.getChildren().length <= 0) break block4;
            CompositeChange changesUnits = (CompositeChange)cc.getChildren()[0];
            Change[] changeArray = changesUnits.getChildren();
            int n = changeArray.length;
            int n3 = 0;
            while (n3 < n) {
                Change aObj = changeArray[n3];
                if (!(aObj instanceof RenameCompilationUnitChange) && !(aObj instanceof RenamePackageChange)) {
                    Class<?> compChange = aObj.getClass();
                    Field fTempDeclarationNode = compChange.getDeclaredField("fCUnit");
                    fTempDeclarationNode.setAccessible(true);
                    CompilationUnit cuObj = (CompilationUnit)fTempDeclarationNode.get(aObj);
                    this.addCompilationUnitToJsonCheckIfIsConflicted(cuObj, jsonAffectedObjects, allOpenResources);
                }
                ++n3;
            }
        }
        return jsonAffectedObjects;
    }

    private void addCompilationUnitToJsonCheckIfIsConflicted(CompilationUnit cuObj, JsonArray jsonAffectedObjects, JsonArray allOpenResources) throws Exception {
        JsonObject jsonAffectedObject = new JsonObject();
        int indexProjectId = cuObj.getCorrespondingResource().toString().indexOf(this.projectId.replaceAll("-", "")) + 1;
        String fullPackageNameAffectedObject = cuObj.getCorrespondingResource().toString().substring(indexProjectId + this.projectId.replaceAll("-", "").length());
        jsonAffectedObject.add("fullPackageName", fullPackageNameAffectedObject);
        jsonAffectedObject.add("conflicted", false);
        int i = 0;
        while (i < allOpenResources.size()) {
            JsonObject jsonOpenResource = allOpenResources.get(i).asObject();
            if (fullPackageNameAffectedObject.equals(jsonOpenResource.get("fullPackageName").asString()) && jsonOpenResource.get("isModified").toString().equals("true")) {
                jsonAffectedObject.set("conflicted", true);
                this.hasConflitResource = true;
            }
            ++i;
        }
        jsonAffectedObjects.add(jsonAffectedObject);
    }

    private Change getChanges(RenameProcessor processor) throws Exception {
        RenameRefactoring fRefactoring = new RenameRefactoring(processor);
        RefactoringStatus status = fRefactoring.checkFinalConditions((IProgressMonitor)new NullProgressMonitor());
        if (status.hasError()) {
            throw new Exception(status.getEntryWithHighestSeverity().getMessage());
        }
        Change changes = fRefactoring.createChange((IProgressMonitor)new NullProgressMonitor());
        return changes;
    }

    private int getOffSet() {
        int currentLine = 0;
        int offset = -1;
        int lineoffset = -1;
        int i = 0;
        while (i < this.contentModified.length()) {
            ++offset;
            if (currentLine == this.row && ++lineoffset == this.column) break;
            if (this.contentModified.charAt(i) == '\n') {
                ++currentLine;
                lineoffset = -1;
            }
            ++i;
        }
        return offset < 0 ? 0 : offset;
    }

    private boolean SameOffSet(int offSetFromObject, int offSetFromSelectedText) {
        int rangeOffSetStart = offSetFromObject;
        int rangeOffSetEnd = offSetFromObject + this.oldValue.length();
        return offSetFromSelectedText >= rangeOffSetStart && offSetFromSelectedText <= rangeOffSetEnd;
    }
}

