/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.java.commands.plugin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.cronapp.java.commands.plugin.util.Functions;
import io.cronapp.java.commands.plugin.util.JdtUtils;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class ObjectFieldsHandler {
    public Object fields(List<Object> arguments) throws Exception {
        try {
            String projectName = (String)arguments.get(0);
            String classType = (String)arguments.get(1);
            IJavaProject javaProject = JdtUtils.getJavaProject(projectName);
            IType type = javaProject.findType(classType);
            IType builderType = type.getType("Builder");
            if (builderType.exists()) {
                return this.getBuilderFields(type);
            }
            return this.getBeanFields(type);
        }
        catch (Exception exception) {
            return new JsonArray();
        }
    }

    private boolean containsFieldByName(JsonArray fieldsArray, String name) {
        int i = 0;
        while (i < fieldsArray.size()) {
            JsonObject json = (JsonObject)fieldsArray.get(i);
            if (name.equals(json.get("name").getAsString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public JsonArray getBeanFields(IType type) throws Exception {
        JsonArray fieldsArray = new JsonArray();
        ITypeHierarchy typeHierarchy = type.newTypeHierarchy(null);
        IType currentType = type;
        while (currentType != null) {
            IField[] fields;
            IMethod[] methods;
            IMethod[] iMethodArray = methods = currentType.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod m = iMethodArray[n2];
                if (!Flags.isStatic((int)m.getFlags()) && Flags.isPublic((int)m.getFlags()) && m.getElementName().startsWith("get")) {
                    String name = m.getElementName().substring(3);
                    boolean hasSetter = Arrays.stream(methods).anyMatch(candidate -> candidate.getElementName().equals("set" + name) && candidate.getNumberOfParameters() == 1);
                    if (hasSetter) {
                        this.addObjectProperty(fieldsArray, m, Functions.firstToLower(name));
                    }
                }
                ++n2;
            }
            IField[] iFieldArray = fields = currentType.getFields();
            int n3 = fields.length;
            n = 0;
            while (n < n3) {
                IField f = iFieldArray[n];
                if (!Flags.isStatic((int)f.getFlags()) && Flags.isPublic((int)f.getFlags()) && !this.containsFieldByName(fieldsArray, f.getElementName())) {
                    JsonObject jsonField = new JsonObject();
                    jsonField.addProperty("name", f.getElementName());
                    jsonField.addProperty("realname", f.getElementName());
                    jsonField.addProperty("type", f.getDeclaringType().getFullyQualifiedName());
                    fieldsArray.add((JsonElement)jsonField);
                }
                ++n;
            }
            currentType = typeHierarchy.getSuperclass(currentType);
        }
        return fieldsArray;
    }

    private JsonArray getBuilderFields(IType type) throws Exception {
        IMethod[] methods;
        JsonArray fieldsArray = new JsonArray();
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod m = iMethodArray[n2];
            if (!Flags.isStatic((int)m.getFlags()) && Flags.isPublic((int)m.getFlags()) && !m.isConstructor() && !m.getReturnType().endsWith("$Builder;") && m.getNumberOfParameters() == 0) {
                String name = m.getElementName();
                this.addObjectProperty(fieldsArray, m, name);
            }
            ++n2;
        }
        return fieldsArray;
    }

    private void addObjectProperty(JsonArray array, IMethod method, String name) throws JavaModelException {
        if (!this.containsFieldByName(array, name)) {
            JsonObject jsonField = new JsonObject();
            jsonField.addProperty("name", name);
            jsonField.addProperty("realname", method.getElementName());
            String returnType = method.getReturnType();
            String typeName = Signature.getSignatureQualifier((String)returnType);
            if (!typeName.isEmpty()) {
                typeName = String.valueOf(typeName) + ".";
            }
            typeName = String.valueOf(typeName) + Signature.getSignatureSimpleName((String)returnType);
            jsonField.addProperty("type", typeName);
            array.add((JsonElement)jsonField);
        }
    }
}

