/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.java.commands.plugin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.cronapp.java.commands.plugin.util.JdtUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.SourceType;

public class InfoFromStubWebServiceHandler {
    private String stubClass;
    private int indexParams;

    public Object fields(List<Object> arguments) throws Exception {
        String projectName = (String)arguments.get(0);
        String fullPackageName = (String)arguments.get(1);
        this.indexParams = 0;
        IJavaProject javaProject = JdtUtils.getJavaProject(projectName);
        ICompilationUnit cu = JdtUtils.getCompilationUnit(javaProject, fullPackageName);
        JsonObject result = new JsonObject();
        SourceType sourceType = (SourceType)cu.getAllTypes()[0];
        this.stubClass = String.valueOf(cu.getPackageDeclarations()[0].getElementName()) + "." + cu.getElementName().replace(".java", "");
        result.add("methods", (JsonElement)this.GetMethodsFromCU(cu, sourceType, false));
        result.addProperty("stubClass", this.stubClass);
        return result;
    }

    public JsonArray GetMethodsFromCU(ICompilationUnit cu, SourceType sourceType, boolean isInnerClass) throws Exception {
        ArrayList<String> methodsFromAxis = new ArrayList<String>(){
            private static final long serialVersionUID = 1L;
            {
                this.add("getUniqueSuffix");
                this.add("populateAxisService");
                this.add("populateFaults");
                this.add("optimizeContent");
                this.add("toOM");
                this.add("toEnvelope");
                this.add("fromOM");
            }
        };
        JsonArray methods = new JsonArray();
        IMethod[] iMethodArray = sourceType.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod m = iMethodArray[n2];
            if (!m.isConstructor() && !m.getElementName().startsWith("start") && !methodsFromAxis.contains(m.getElementName()) && (isInnerClass && m.getElementName().startsWith("set") || !isInnerClass)) {
                JsonObject method = new JsonObject();
                method.addProperty("methodName", m.getElementName());
                method.addProperty("returnType", this.getTypeTranslate(m.getReturnType()));
                JsonArray parameters = new JsonArray();
                ILocalVariable[] iLocalVariableArray = m.getParameters();
                int n3 = iLocalVariableArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ILocalVariable param = iLocalVariableArray[n4];
                    JsonObject parameter = new JsonObject();
                    parameter.addProperty("isObject", Boolean.valueOf(this.isObject(param.getTypeSignature())));
                    parameter.addProperty("type", this.getTypeTranslate(param.getTypeSignature()));
                    if (isInnerClass && m.getElementName().startsWith("set")) {
                        String paramNameSameMethodName = m.getElementName().replace("set", "");
                        paramNameSameMethodName = String.valueOf(Character.toLowerCase(paramNameSameMethodName.charAt(0))) + paramNameSameMethodName.substring(1);
                        if (this.isObject(param.getTypeSignature())) {
                            parameter.addProperty("name", String.valueOf(paramNameSameMethodName) + this.indexParams++);
                        } else {
                            parameter.addProperty("name", paramNameSameMethodName);
                        }
                    } else {
                        parameter.addProperty("name", String.valueOf(param.getElementName()) + this.indexParams++);
                    }
                    if (this.isObject(param.getTypeSignature())) {
                        String[] innerClass = parameter.get("type").getAsString().replace(".", "/").split("/");
                        IType[] iTypeArray = cu.getAllTypes();
                        int n5 = iTypeArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IType type = iTypeArray[n6];
                            if (type.getElementName().equals(innerClass[innerClass.length - 1])) {
                                SourceType paramObj = (SourceType)type;
                                parameter.add("methods", (JsonElement)this.GetMethodsFromCU(cu, paramObj, true));
                                parameter.addProperty("hasArgumentsInConstructor", Boolean.valueOf(this.checkHasArgumentsInConstrutor(paramObj)));
                                Flags.toString((int)paramObj.getFlags());
                                break;
                            }
                            ++n6;
                        }
                    }
                    parameters.add((JsonElement)parameter);
                    ++n4;
                }
                method.add("parameters", (JsonElement)parameters);
                methods.add((JsonElement)method);
            }
            ++n2;
        }
        return methods;
    }

    public boolean checkHasArgumentsInConstrutor(SourceType paramObj) throws JavaModelException {
        boolean result = false;
        IMethod[] iMethodArray = paramObj.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod m = iMethodArray[n2];
            if (m.isConstructor()) {
                result = m.getParameters().length > 0;
                break;
            }
            ++n2;
        }
        return result;
    }

    public boolean isObject(String typeSignature) {
        ArrayList<String> primitives = new ArrayList<String>(){
            private static final long serialVersionUID = 1L;
            {
                this.add("byte");
                this.add("char");
                this.add("double");
                this.add("float");
                this.add("int");
                this.add("long");
                this.add("short");
                this.add("boolean");
            }
        };
        String signature = this.getTypeTranslate(typeSignature);
        if (primitives.contains(signature)) {
            return false;
        }
        return !signature.startsWith("java.math") && !signature.startsWith("java.lang") && !signature.startsWith("java.util");
    }

    public String getTypeTranslate(String typeSignature) {
        String translated;
        String array;
        block36: {
            block35: {
                array = "";
                if (typeSignature.startsWith("[")) {
                    array = "[]";
                    typeSignature = typeSignature.substring(1);
                } else if (typeSignature.startsWith("[[")) {
                    array = "[][]";
                    typeSignature = typeSignature.substring(2);
                }
                translated = "";
                if (!typeSignature.startsWith("Q") && !typeSignature.startsWith("L")) break block35;
                translated = typeSignature.substring(1).replace(";", "");
                if (!(translated.startsWith("java.math") || translated.startsWith("java.lang") || translated.startsWith("java.util") || translated.contains(this.stubClass))) {
                    translated = String.valueOf(this.stubClass) + "." + translated;
                }
                break block36;
            }
            switch (typeSignature) {
                case "B": {
                    translated = "java.lang.Byte";
                    break;
                }
                case "C": {
                    translated = "java.lang.Character";
                    break;
                }
                case "D": {
                    translated = "java.lang.Double";
                    break;
                }
                case "F": {
                    translated = "java.lang.Float";
                    break;
                }
                case "I": {
                    translated = "java.lang.Integer";
                    break;
                }
                case "J": {
                    translated = "java.lang.Long";
                    break;
                }
                case "S": {
                    translated = "java.lang.Short";
                    break;
                }
                case "Z": {
                    translated = "java.lang.Boolean";
                    break;
                }
                case "T": {
                    translated = typeSignature.substring(1).replace(";", "");
                    break;
                }
                default: {
                    translated = typeSignature;
                }
            }
        }
        return String.valueOf(translated) + array;
    }
}

