/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.java.commands.plugin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.cronapp.java.commands.plugin.util.GetterSetterUtil;
import io.cronapp.java.commands.plugin.util.JdtUtils;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class FieldsFromClassHandler {
    private final String[] EMPTY_STRINGS = new String[0];

    public Object fields(List<Object> arguments) throws Exception {
        IField[] fields;
        ICompilationUnit resCU;
        String projectName = (String)arguments.get(0);
        String fullPackageName = (String)arguments.get(1);
        IJavaProject javaProject = JdtUtils.getJavaProject(projectName);
        JsonArray jsonArray = new JsonArray();
        ICompilationUnit cu = resCU = JdtUtils.getCompilationUnit(javaProject, fullPackageName);
        IField[] iFieldArray = fields = cu.getTypes()[0].getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("name", field.getElementName());
            jsonObject.addProperty("type", Signature.toString((String)field.getTypeSignature()));
            jsonObject.addProperty("typeSignature", field.getTypeSignature());
            jsonObject.addProperty("accessModify", this.getAccessModify(field.getSource()));
            jsonObject.addProperty("setterName", GetterSetterUtil.getSetterName(field, null));
            jsonObject.addProperty("getterName", GetterSetterUtil.getGetterName(field, null));
            jsonObject.addProperty("hasSetterName", Boolean.valueOf(this.GetMethodAssociated(field, true)));
            jsonObject.addProperty("hasGetterName", Boolean.valueOf(this.GetMethodAssociated(field, false)));
            jsonArray.add((JsonElement)jsonObject);
            ++n2;
        }
        return jsonArray;
    }

    private boolean GetMethodAssociated(IField field, boolean isSetter) throws IllegalArgumentException, JavaModelException {
        String methodToSearch = "";
        IMethod methodExist = null;
        if (isSetter) {
            methodToSearch = GetterSetterUtil.getSetterName(field, null);
            methodExist = GetterSetterUtil.findMethod(methodToSearch, new String[]{field.getTypeSignature()}, false, field.getDeclaringType());
        } else {
            methodToSearch = GetterSetterUtil.getGetterName(field, null);
            methodExist = GetterSetterUtil.findMethod(methodToSearch, this.EMPTY_STRINGS, false, field.getDeclaringType());
        }
        return methodExist != null;
    }

    private String getAccessModify(String typeSignature) {
        String[] splited = typeSignature.split(" ");
        if (splited.length > 2) {
            return splited[0];
        }
        return "";
    }
}

