/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Messages {
    private static final String BUNDLE_NAME = "io.cronapp.i18n.Messages";
    private static final ResourceBundle DEFAULT_BUNDLE = ResourceBundle.getBundle("io.cronapp.i18n.Messages", new Locale("pt", "BR"), new UTF8Control());
    public static final ThreadLocal<ResourceBundle> RESOURCE_BUNDLE = new ThreadLocal();

    public static String getString(String key) {
        try {
            ResourceBundle bundle = RESOURCE_BUNDLE.get();
            if (bundle == null) {
                return DEFAULT_BUNDLE.getString(key);
            }
            return RESOURCE_BUNDLE.get().getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String format(String pattern, Object ... arguments) {
        String fixedPattern = pattern.replace("'", "''");
        return MessageFormat.format(fixedPattern, arguments);
    }

    public static void set(Locale locale) {
        RESOURCE_BUNDLE.set(ResourceBundle.getBundle(BUNDLE_NAME, locale));
    }

    public static void set(String localeStr) {
        String[] p = localeStr.split("_");
        Locale locale = p.length > 1 ? new Locale(p[0], p[1]) : new Locale(p[0]);
        RESOURCE_BUNDLE.set(ResourceBundle.getBundle(BUNDLE_NAME, locale));
    }

    public static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle(BUNDLE_NAME, locale, new UTF8Control());
    }

    public static Locale getLocale() {
        ResourceBundle bundle = RESOURCE_BUNDLE.get();
        if (bundle == null) {
            bundle = DEFAULT_BUNDLE;
        }
        return bundle.getLocale();
    }

    public static class UTF8Control
    extends ResourceBundle.Control {
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            PropertyResourceBundle bundle = null;
            InputStream stream = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                try {
                    bundle = new PropertyResourceBundle(new InputStreamReader(stream, "UTF-8"));
                }
                finally {
                    stream.close();
                }
            }
            return bundle;
        }
    }
}

