/*
 * Decompiled with CFR 0.152.
 */
package cronapp.reports.j4c.export;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJGroupLabel;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.builders.GroupBuilder;
import ar.com.fdvs.dj.domain.chart.DJChart;
import ar.com.fdvs.dj.domain.chart.DJChartOptions;
import ar.com.fdvs.dj.domain.chart.builder.AbstractChartBuilder;
import ar.com.fdvs.dj.domain.chart.builder.DJPieChartBuilder;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.ImageScaleMode;
import ar.com.fdvs.dj.domain.constants.LabelPosition;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import cronapp.reports.j4c.J4CBorder;
import cronapp.reports.j4c.J4CChart;
import cronapp.reports.j4c.J4CField;
import cronapp.reports.j4c.J4CFont;
import cronapp.reports.j4c.J4CImage;
import cronapp.reports.j4c.J4CObject;
import cronapp.reports.j4c.J4CPage;
import cronapp.reports.j4c.J4CText;
import cronapp.reports.j4c.charts.J4CPieChart;
import cronapp.reports.j4c.commons.J4CCalculation;
import cronapp.reports.j4c.commons.J4CChartPosition;
import cronapp.reports.j4c.commons.J4CGroupLayout;
import cronapp.reports.j4c.commons.J4CPageFormat;
import cronapp.reports.j4c.commons.J4CPosition;
import cronapp.reports.j4c.commons.J4CTextMode;
import cronapp.reports.j4c.export.J4CExport;
import java.awt.Color;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Optional;
import net.sf.jasperreports.engine.type.ScaleImageEnum;

public class DynamicReportExport
implements J4CExport<DynamicReport> {
    private final J4CObject j4CObject;
    private final Connection connection;
    private final HashMap<J4CField, AbstractColumn> mapColumns;

    DynamicReportExport(J4CObject j4CObject, Connection connection) {
        this.j4CObject = j4CObject;
        this.connection = connection;
        this.mapColumns = new HashMap();
    }

    @Override
    public DynamicReport get() {
        J4CChart chart;
        J4CImage image;
        DynamicReportBuilder dynamicReportBuilder = new DynamicReportBuilder();
        dynamicReportBuilder.setReportName(this.j4CObject.getName());
        dynamicReportBuilder.setUseFullPageWidth(true);
        dynamicReportBuilder.setWhenNoDataAllSectionNoDetail();
        dynamicReportBuilder.setPrintBackgroundOnOddRows(this.j4CObject.isConditionalLinesColor());
        if (this.j4CObject.isPagination()) {
            dynamicReportBuilder.addAutoText((byte)1, (byte)0, (byte)2);
        }
        dynamicReportBuilder.setDetailHeight(this.j4CObject.getPage().getLineSpace());
        dynamicReportBuilder.setTopMargin(this.j4CObject.getPage().getTopMargin());
        dynamicReportBuilder.setBottomMargin(this.j4CObject.getPage().getBottomMargin());
        dynamicReportBuilder.setLeftMargin(this.j4CObject.getPage().getLeftMargin());
        dynamicReportBuilder.setRightMargin(this.j4CObject.getPage().getRightMargin());
        dynamicReportBuilder.setPageSizeAndOrientation(this.toPage(this.j4CObject.getPage()));
        J4CText title = this.j4CObject.getTitle();
        dynamicReportBuilder.setTitle(title.getValue(), title.isExpressionValue());
        dynamicReportBuilder.setTitleStyle(this.toStyle(title));
        J4CText subTitle = this.j4CObject.getSubTitle();
        dynamicReportBuilder.setSubtitle(subTitle.getValue());
        dynamicReportBuilder.setSubtitleStyle(this.toStyle(subTitle));
        this.j4CObject.getFields().forEach(j4CColumn -> {
            AbstractColumn columnDoes = ColumnBuilder.getNew().setColumnProperty(j4CColumn.getText().getValue(), j4CColumn.getType()).setStyle(this.toStyle(j4CColumn.getText())).setTitle(j4CColumn.getTitle().getValue()).setHeaderStyle(this.toStyle(j4CColumn.getTitle())).build();
            columnDoes.setName(j4CColumn.getText().getValue());
            dynamicReportBuilder.addColumn(columnDoes);
            this.mapColumns.put((J4CField)j4CColumn, columnDoes);
        });
        this.mapColumns.entrySet().forEach(entry -> {
            J4CField j4CField = (J4CField)entry.getKey();
            AbstractColumn abstractColumn = (AbstractColumn)entry.getValue();
            Optional.ofNullable(j4CField.getGroup()).ifPresent(j4CGroup -> {
                PropertyColumn propertyColumn = (PropertyColumn)abstractColumn;
                GroupBuilder groupBuilder = new GroupBuilder();
                groupBuilder.setCriteriaColumn(propertyColumn);
                groupBuilder.setGroupLayout(this.toGroupLayout(j4CGroup.getGroupLayout()));
                groupBuilder.setStartInNewPage(j4CGroup.isStartInNewPage());
                if (j4CGroup.getGroupLayout().equals((Object)J4CGroupLayout.VALUE_IN_HEADER_WITH_HEADERS)) {
                    dynamicReportBuilder.setPrintColumnNames(false);
                }
                Optional.ofNullable(j4CGroup.getSummary()).ifPresent(j4CSummary -> {
                    Style valueStyle = this.toStyle(j4CSummary.getValue());
                    Style labelStyle = this.toStyle(j4CSummary.getLabel());
                    DJGroupLabel summaryLabel = new DJGroupLabel(j4CSummary.getLabel().getValue(), labelStyle, this.toPosition(j4CSummary.getLabel().getHorizontalAlignment()));
                    summaryLabel.setJasperExpression(j4CSummary.getValue().isExpressionValue());
                    J4CField summaryColumn = this.getJ4CColumn(j4CSummary.getColumn());
                    groupBuilder.addFooterVariable(this.mapColumns.get(summaryColumn), this.toCalculation(j4CSummary.getCalculation()), valueStyle, null, summaryLabel);
                });
                dynamicReportBuilder.addGroup(groupBuilder.build());
            });
            Optional.ofNullable(j4CField.getSummary()).ifPresent(j4CSummary -> {
                Style summaryStyle = this.toStyle(j4CSummary.getValue());
                dynamicReportBuilder.addGlobalFooterVariable(abstractColumn, this.toCalculation(j4CSummary.getCalculation()), summaryStyle);
                dynamicReportBuilder.setGrandTotalLegend("");
            });
        });
        String sql = this.j4CObject.dataset().getSql(this.connection);
        if (sql != null && sql.length() > 0) {
            dynamicReportBuilder.setQuery(sql, "sql");
        }
        if ((image = this.j4CObject.getImage()) != null) {
            dynamicReportBuilder.addFirstPageImageBanner(image.getPath(), image.getWidth(), image.getHeight(), this.toBannerPosition(image.getPosition()), this.toScale(image.getImageScale()));
            if (image.isRepeatEachPage()) {
                dynamicReportBuilder.addImageBanner(image.getPath(), image.getWidth(), image.getHeight(), this.toBannerPosition(image.getPosition()), this.toScale(image.getImageScale()));
            }
        }
        if ((chart = this.j4CObject.getChart()) != null) {
            DJChart djChart = this.toChart(chart);
            dynamicReportBuilder.addChart(djChart);
        }
        String json = this.j4CObject.build().toJson().get();
        dynamicReportBuilder.setProperty("DATASOURCE", this.j4CObject.dataset().getJndiConnection());
        dynamicReportBuilder.setProperty("J4C_OBJECT", json);
        dynamicReportBuilder.setProperty("zoom.factor", "50.0");
        dynamicReportBuilder.setProperty("JASPER_EDITED", Boolean.FALSE.toString());
        return dynamicReportBuilder.build();
    }

    private DJChart toChart(J4CChart j4CChart) {
        switch (j4CChart.getJRType()) {
            case 9: {
                return this.toPieChart(new DJPieChartBuilder(), (J4CPieChart)j4CChart);
            }
        }
        return null;
    }

    private DJChart toPieChart(DJPieChartBuilder pieChartBuilder, J4CPieChart j4CChart) {
        this.toBaseChartProperties((AbstractChartBuilder)pieChartBuilder, j4CChart);
        return pieChartBuilder.setCircular(true).setKey((PropertyColumn)this.mapColumns.get(this.getJ4CColumn(j4CChart.getKey()))).addSerie(this.mapColumns.get(this.getJ4CColumn(j4CChart.getSerie()))).build();
    }

    private void toBaseChartProperties(AbstractChartBuilder abstractChartBuilder, J4CChart j4CChart) {
        abstractChartBuilder.setWidth(j4CChart.getWidth()).setHeight(j4CChart.getHeight()).setCentered(j4CChart.isCentered()).setPosition(this.toChartPosition(j4CChart.getPosition())).setShowLegend(true).setBackColor(Color.LIGHT_GRAY).setTitlePosition(DJChartOptions.EDGE_TOP).setTitleColor(Color.DARK_GRAY).setTitleFont(Font.ARIAL_BIG_BOLD).setTitle("").setSubtitle("").setSubtitleColor(Color.DARK_GRAY).setSubtitleFont(Font.COURIER_NEW_BIG_BOLD).setLegendColor(Color.DARK_GRAY).setLegendFont(Font.COURIER_NEW_MEDIUM_BOLD).setLegendBackgroundColor(Color.WHITE).setLegendPosition(DJChartOptions.EDGE_BOTTOM).setLineStyle(DJChartOptions.LINE_STYLE_DASHED).setLineWidth(1.0f).setLineColor(Color.DARK_GRAY).setPadding(5);
    }

    private byte toChartPosition(J4CChartPosition j4CChartPosition) {
        switch (j4CChartPosition) {
            case HEADER: {
                return 2;
            }
        }
        return 1;
    }

    private Page toPage(J4CPage j4CPage) {
        switch (j4CPage.getLeaf()) {
            case A4: {
                if (j4CPage.getFormat().equals((Object)J4CPageFormat.PORTRAIT)) {
                    return Page.Page_A4_Portrait();
                }
                return Page.Page_A4_Landscape();
            }
            case LETTER: {
                if (j4CPage.getFormat().equals((Object)J4CPageFormat.PORTRAIT)) {
                    return Page.Page_Letter_Portrait();
                }
                return Page.Page_Letter_Landscape();
            }
        }
        return Page.Page_A4_Portrait();
    }

    private ImageScaleMode toScale(ScaleImageEnum scale) {
        switch (scale) {
            case CLIP: {
                return ImageScaleMode.NO_RESIZE;
            }
            case FILL_FRAME: {
                return ImageScaleMode.FILL;
            }
            case REAL_HEIGHT: {
                return ImageScaleMode.REAL_HEIGHT;
            }
            case REAL_SIZE: {
                return ImageScaleMode.REAL_SIZE;
            }
        }
        return ImageScaleMode.FILL_PROPORTIONALLY;
    }

    private byte toBannerPosition(J4CPosition position) {
        switch (position) {
            case CENTER: {
                return 2;
            }
            case RIGHT: {
                return 1;
            }
        }
        return 0;
    }

    private DJCalculation toCalculation(J4CCalculation j4CCalculation) {
        switch (j4CCalculation) {
            case AVERAGE: {
                return DJCalculation.AVERAGE;
            }
            case COUNT: {
                return DJCalculation.COUNT;
            }
            case NOTHING: {
                return DJCalculation.NOTHING;
            }
        }
        return DJCalculation.SUM;
    }

    private LabelPosition toPosition(J4CPosition j4CPosition) {
        switch (j4CPosition) {
            case BOTTOM: {
                return LabelPosition.BOTTOM;
            }
            case RIGHT: {
                return LabelPosition.RIGHT;
            }
            case TOP: {
                return LabelPosition.TOP;
            }
        }
        return LabelPosition.LEFT;
    }

    private GroupLayout toGroupLayout(J4CGroupLayout j4CGroupLayout) {
        switch (j4CGroupLayout) {
            case VALUE_IN_HEADER_AND_FOR_EACH: {
                return GroupLayout.VALUE_IN_HEADER_AND_FOR_EACH;
            }
            case VALUE_IN_HEADER_AND_FOR_EACH_WITH_HEADERS: {
                return GroupLayout.VALUE_IN_HEADER_AND_FOR_EACH_WITH_HEADERS;
            }
            case VALUE_IN_HEADER: {
                return GroupLayout.VALUE_IN_HEADER;
            }
            case VALUE_IN_HEADER_WITH_HEADERS: {
                return GroupLayout.VALUE_IN_HEADER_WITH_HEADERS;
            }
            case VALUE_IN_HEADER_WITH_HEADERS_AND_COLUMN_NAME: {
                return GroupLayout.VALUE_IN_HEADER_WITH_HEADERS_AND_COLUMN_NAME;
            }
            case VALUE_FOR_EACH: {
                return GroupLayout.VALUE_FOR_EACH;
            }
            case VALUE_FOR_EACH_WITH_HEADERS: {
                return GroupLayout.VALUE_FOR_EACH_WITH_HEADERS;
            }
            case EMPTY: {
                return GroupLayout.EMPTY;
            }
            case DEFAULT_WITH_HEADER: {
                return GroupLayout.DEFAULT_WITH_HEADER;
            }
        }
        return GroupLayout.DEFAULT;
    }

    private Style toStyle(J4CText j4CText) {
        Style style = new Style();
        J4CFont j4CFont = j4CText.getFont();
        Font font = new Font();
        font.setFontName(j4CFont.getName());
        font.setFontSize((float)j4CFont.getSize());
        font.setBold(j4CFont.isBold());
        font.setItalic(j4CFont.isItalic());
        font.setUnderline(j4CFont.isUnderline());
        style.setFont(font);
        style.setBackgroundColor(j4CText.getBackcolor());
        style.setTextColor(j4CText.getForecolor());
        style.setHorizontalAlign(this.toHorizontalAlign(j4CText.getHorizontalAlignment()));
        style.setVerticalAlign(this.toVerticalAlign(j4CText.getVerticalAlignment()));
        style.setTransparent(j4CText.getMode().equals((Object)J4CTextMode.TRANSPARENT));
        style.setBorderTop(this.toBorder(j4CText.getBorderTop()));
        style.setBorderBottom(this.toBorder(j4CText.getBorderBottom()));
        style.setBorderLeft(this.toBorder(j4CText.getBorderLeft()));
        style.setBorderRight(this.toBorder(j4CText.getBorderRight()));
        return style;
    }

    private Border toBorder(J4CBorder j4CBorder) {
        Border border = new Border(Border.BORDER_WIDTH_NONE);
        border.setColor(j4CBorder.getColor());
        border.setLineStyle((byte)j4CBorder.getLineStyle().ordinal());
        border.setWidth(j4CBorder.getWidth().getWidth());
        return border;
    }

    private VerticalAlign toVerticalAlign(J4CPosition j4CPosition) {
        switch (j4CPosition) {
            case TOP: {
                return VerticalAlign.TOP;
            }
            case BOTTOM: {
                return VerticalAlign.BOTTOM;
            }
        }
        return VerticalAlign.MIDDLE;
    }

    private HorizontalAlign toHorizontalAlign(J4CPosition j4CPosition) {
        switch (j4CPosition) {
            case LEFT: {
                return HorizontalAlign.LEFT;
            }
            case RIGHT: {
                return HorizontalAlign.RIGHT;
            }
        }
        return HorizontalAlign.CENTER;
    }

    private J4CField getJ4CColumn(String columnName) {
        J4CField[] finalColumn = new J4CField[]{null};
        this.j4CObject.getFields().stream().filter(column -> column.getText().getValue().equals(columnName)).findFirst().ifPresent(column -> {
            finalColumn[0] = column;
        });
        return finalColumn[0];
    }
}

