/*
 * Decompiled with CFR 0.152.
 */
package cronapp.reports.j4c.dataset;

import cronapp.reports.commons.Functions;
import cronapp.reports.commons.Geleia;
import cronapp.reports.j4c.dataset.StringLiteralWithoutQuote;
import io.zatarox.squiggle.Matchable;
import io.zatarox.squiggle.literal.BigDecimalLiteral;
import io.zatarox.squiggle.literal.BooleanLiteral;
import io.zatarox.squiggle.literal.DateTimeLiteral;
import io.zatarox.squiggle.literal.FloatLiteral;
import io.zatarox.squiggle.literal.IntegerLiteral;
import java.math.BigDecimal;
import java.util.Date;

public class CriteriaUtil {
    public static Matchable newBigDecimalValue(BigDecimal value) {
        return new BigDecimalLiteral(value);
    }

    public static Matchable newBooleanValue(boolean value) {
        return new BooleanLiteral(value);
    }

    public static Matchable newDateValue(Date value) {
        return new DateTimeLiteral(value);
    }

    public static Matchable newDoubleValue(double value) {
        return new FloatLiteral(value);
    }

    public static Matchable newLongValue(long value) {
        return new IntegerLiteral(value);
    }

    public static Matchable newStringValue(String value) {
        return new StringLiteralWithoutQuote(value);
    }

    public static Matchable newMatch(Object value) {
        String type;
        if (value == null) {
            return CriteriaUtil.newStringValue("");
        }
        switch (type = value.getClass().getSimpleName()) {
            case "Boolean": {
                return CriteriaUtil.newBooleanValue((Boolean)value);
            }
            case "Short": 
            case "Integer": 
            case "Long": {
                return CriteriaUtil.newLongValue(Geleia.longNotNull(String.valueOf(value)));
            }
            case "Float": 
            case "Double": {
                return CriteriaUtil.newDoubleValue(Geleia.doubleNotNull(String.valueOf(value)));
            }
            case "Date": 
            case "Time": 
            case "Timestamp": {
                return CriteriaUtil.newDateValue((Date)value);
            }
        }
        return CriteriaUtil.newStringValue((String)value);
    }

    public static Object fromType(String value, String type) {
        if (Functions.isExists(value) && value.startsWith("$")) {
            return value;
        }
        switch (type) {
            case "Boolean": {
                return Geleia.booleanNotNull(value);
            }
            case "Short": {
                return Geleia.shortNotNull(value);
            }
            case "Integer": {
                return Geleia.intNotNull(value);
            }
            case "Long": {
                return Geleia.longNotNull(value);
            }
            case "Float": {
                return Geleia.floatNotNull(value);
            }
            case "Double": {
                return Geleia.doubleNotNull(value);
            }
        }
        return Geleia.stringNotNull(value);
    }
}

