/*
 * Decompiled with CFR 0.152.
 */
package cronapp.reports.j4c;

import com.google.gson.Gson;
import cronapp.reports.commons.GsonSingleton;
import cronapp.reports.j4c.J4CChart;
import cronapp.reports.j4c.J4CField;
import cronapp.reports.j4c.J4CImage;
import cronapp.reports.j4c.J4CPage;
import cronapp.reports.j4c.J4CParameter;
import cronapp.reports.j4c.J4CTemplate;
import cronapp.reports.j4c.J4CText;
import cronapp.reports.j4c.commons.J4CUtils;
import cronapp.reports.j4c.dataset.J4CColumn;
import cronapp.reports.j4c.dataset.J4CDataset;
import cronapp.reports.j4c.export.ReportMaker;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class J4CObject
implements Serializable,
Cloneable {
    private final String name;
    private J4CText title;
    private J4CText subTitle;
    private boolean conditionalLinesColor;
    private J4CDataset dataset;
    private boolean pagination;
    private List<J4CField> fields;
    private J4CImage image;
    private J4CPage page;
    private J4CChart chart;
    private Set<J4CParameter> parameters;
    private transient Map<String, Object> parametersValue;
    private transient J4CTemplate template;

    public J4CObject() {
        this("J4CReport");
    }

    public J4CObject(String name) {
        this.name = name;
    }

    public static J4CObject fromJSON(String json) {
        Gson gson = (Gson)GsonSingleton.INSTANCE.get();
        J4CObject j4CObject = (J4CObject)gson.fromJson(json, J4CObject.class);
        j4CObject.dataset().synchronizeParent(j4CObject);
        return j4CObject;
    }

    public String getName() {
        return this.name;
    }

    public J4CText getTitle() {
        if (this.title == null) {
            this.title = new J4CText();
        }
        return this.title;
    }

    public void setTitle(J4CText title) {
        this.title = title;
    }

    public J4CText getSubTitle() {
        if (this.subTitle == null) {
            this.subTitle = new J4CText();
        }
        return this.subTitle;
    }

    public void setSubTitle(J4CText subTitle) {
        this.subTitle = subTitle;
    }

    public boolean isConditionalLinesColor() {
        return this.conditionalLinesColor;
    }

    public void setConditionalLinesColor(boolean conditionalLinesColor) {
        this.conditionalLinesColor = conditionalLinesColor;
    }

    public boolean isPagination() {
        return this.pagination;
    }

    public void setPagination(boolean pagination) {
        this.pagination = pagination;
    }

    public J4CImage getImage() {
        return this.image;
    }

    public void setImage(J4CImage image) {
        this.image = image;
    }

    public List<J4CField> getFields() {
        if (this.fields == null) {
            this.fields = new LinkedList<J4CField>();
        }
        return this.fields;
    }

    public void removeAllFields() {
        this.fields = null;
    }

    void addField(J4CField field) {
        this.getFields().add(field);
    }

    J4CObject removeField(J4CField field) {
        Iterator<J4CField> iterator = this.getFields().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getText().getValue().equals(field.getText().getValue())) continue;
            iterator.remove();
        }
        return this;
    }

    public ReportMaker build() {
        return new ReportMaker(this);
    }

    public J4CDataset dataset() {
        if (this.dataset == null) {
            this.dataset = new J4CDataset(this);
        }
        return this.dataset;
    }

    public J4CTemplate template() {
        if (this.template == null) {
            this.template = new J4CTemplate(this);
        }
        return this.template;
    }

    public void synchronizeFields(Connection connection) {
        J4CDataset dataset = this.dataset();
        try {
            this.removeAllFields();
            List<J4CColumn> columnRecords = dataset.getDataPreviewWithoutRecords(connection);
            int size = columnRecords.size();
            for (int index = 0; index < size; ++index) {
                J4CColumn column = columnRecords.get(index);
                J4CField field = new J4CField();
                field.setText(new J4CText(column.getName()));
                field.setType(column.getTypeClass());
                field.setTitle(new J4CText(column.getName()));
                if (this.hasField(field)) {
                    field.setText(new J4CText("COLUMN_".concat(String.valueOf(index + 1))));
                }
                this.addField(field);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean hasField(J4CField field) {
        return this.getFields().stream().anyMatch(j4CField -> j4CField.getText().getValue().equals(field.getText().getValue()));
    }

    public void setDataset(J4CDataset dataset) {
        this.dataset = dataset;
    }

    public J4CPage getPage() {
        if (this.page == null) {
            this.page = new J4CPage();
        }
        return this.page;
    }

    public void setPage(J4CPage page) {
        this.page = page;
    }

    public J4CChart getChart() {
        return this.chart;
    }

    public void setChart(J4CChart chart) {
        this.chart = chart;
    }

    public Set<J4CParameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new HashSet<J4CParameter>();
            this.parameters.add(new J4CParameter("DATA_LIMIT", Integer.class.getName(), 10));
        }
        return this.parameters;
    }

    public void setParameters(Set<J4CParameter> parameters) {
        this.parameters = parameters;
    }

    public J4CObject addParameter(J4CParameter parameter) {
        String name = parameter.getName();
        J4CParameter j4CParameter = this.hasParameter(name);
        if (j4CParameter != null) {
            this.getParameters().removeIf(this.getPredicateParameterExists(name));
        }
        this.getParameters().add(parameter);
        return this;
    }

    public void removeParameter(String parameterName) {
        this.getParameters().removeIf(this.getPredicateParameterExists(parameterName));
    }

    public Map<String, Object> getParametersValue() {
        if (this.parametersValue == null) {
            this.parametersValue = new HashMap<String, Object>();
        }
        return this.parametersValue;
    }

    public void setParametersValue(Map<String, Object> parametersValue) {
        this.parametersValue = parametersValue;
    }

    public Map<String, Object> getParametersDefaultValue() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        this.getParameters().forEach(parameter -> parameters.put(parameter.getName(), J4CUtils.defaultValueBy(parameter.getType())));
        return parameters;
    }

    public J4CParameter hasParameter(String parameter) {
        return this.getParameters().stream().filter(this.getPredicateParameterExists(parameter)).findFirst().orElse(null);
    }

    private Predicate<J4CParameter> getPredicateParameterExists(String parameter) {
        return p -> p.getName().equals(parameter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        J4CObject object = (J4CObject)o;
        return this.name != null ? this.name.equals(object.name) : object.name == null;
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return "J4CObject{'" + this.name + "'}";
    }

    public J4CObject clone() {
        try {
            J4CObject clone = (J4CObject)super.clone();
            clone.title = this.getTitle().clone();
            clone.subTitle = this.getSubTitle().clone();
            clone.fields = new ArrayList<J4CField>(this.getFields());
            clone.page = this.getPage().clone();
            clone.parameters = new HashSet<J4CParameter>(this.getParameters());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

