/*
 * Decompiled with CFR 0.152.
 */
package cronapp.reports.commons;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.omg.CORBA.Environment;

public class Functions {
    static final String[] PREPOSICOES = new String[]{"a", "ao", "\u00e0", "aos", "\u00e0s", "de", "do", "da", "dos", "das", "em", "no", "na", "nos", "nas", "por", "pelo", "pela", "pelos", "pelas", "ante", "ap\u00f3s", "at\u00e9", "com", "contra", "desde", "entre", "para", "perante", "sem", "sob", "sobre", "tr\u00e1s"};

    public static String getCampoLog(String nomeUsuario) {
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy - HH:mm:ss");
        return nomeUsuario.concat(" - ").concat(format.format(new java.util.Date()));
    }

    public static java.util.Date getDataSQL(java.util.Date AData, String formato) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(formato);
        java.util.Date dDataAtual = format.parse(format.format(AData));
        Date dataSQL = new Date(dDataAtual.getTime());
        return dataSQL;
    }

    public static String getDescricaoPeriodo(java.util.Date dataInicial, java.util.Date dataFinal) {
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
        String inicio = format.format(dataInicial);
        String fim = format.format(dataFinal);
        return "De ".concat(inicio).concat(" \u00e0 ").concat(fim);
    }

    public static String getDataPorExtenso(java.util.Date data) {
        SimpleDateFormat dfmt = new SimpleDateFormat("EEEE, d 'de' MMMM 'de' yyyy");
        return dfmt.format(data);
    }

    public static String getDataPorExtenso() {
        return Functions.getDataPorExtenso(new java.util.Date());
    }

    public static String getHora(java.util.Date AData) {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        String sHoraAtual = format.format(AData);
        return sHoraAtual;
    }

    public static String getHoraAtual() {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        String sHoraAtual = format.format(new java.util.Date());
        return sHoraAtual;
    }

    public static InputStream getInputStream(String resource) {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            stream = Environment.class.getResourceAsStream(resource);
        }
        if (stream == null) {
            stream = Environment.class.getClassLoader().getResourceAsStream(stripped);
        }
        if (stream == null) {
            throw new RuntimeException(resource.concat(" n\u00e3o encontrado"));
        }
        return stream;
    }

    public static java.util.Date getOnlyDate(java.util.Date date) {
        if (date == null) {
            return null;
        }
        DateTimeZone timeZone = DateTimeZone.forID((String)"America/Sao_Paulo");
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"dd/MM/yyyy").withZone(timeZone);
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
        String dateFormated = format.format(date);
        return formatter.parseLocalDate(dateFormated).toDate();
    }

    public static java.util.Date getOnlyDate(String date) {
        return Functions.getOnlyDate(ISODateTimeFormat.dateOptionalTimeParser().withOffsetParsed().parseLocalDateTime(date).toDate());
    }

    public static java.util.Date getOnlyDate() {
        return Functions.getOnlyDate(new java.util.Date());
    }

    public static String getZerosAEsquerda(String valor, int digitos) {
        StringBuilder builder = new StringBuilder(digitos);
        int length = digitos - valor.length();
        for (int iCount = 0; iCount < length; ++iCount) {
            builder.append("0");
        }
        builder.append(valor);
        return builder.toString();
    }

    public static boolean isExists(String value) {
        return value != null && !value.isEmpty() && !"null".equals(value);
    }

    static String getRegexPreposicoes() {
        int length = PREPOSICOES.length;
        StringBuilder builder = new StringBuilder(length * 2);
        for (int count = 0; count < length; count = (int)((byte)(count + 1))) {
            if (count == 0) {
                builder.append("[");
            }
            if (count > 0) {
                builder.append("-");
            }
            builder.append(PREPOSICOES[count]);
            if (count + 1 != length) continue;
            builder.append("]");
        }
        return builder.toString();
    }

    public static String doRemovePreposicao(String referencia) {
        LinkedList<String> referList = new LinkedList<String>(Arrays.asList(referencia.split(" ")));
        CollectionUtils.filter(referList, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                String item;
                boolean result = false;
                String[] stringArray = PREPOSICOES;
                int n = stringArray.length;
                for (int i = 0; i < n && !(result = ((String)object).equalsIgnoreCase(item = stringArray[i])); ++i) {
                }
                return !result;
            }
        });
        StringBuilder builder = new StringBuilder(referencia.length());
        for (String item : referList) {
            builder.append(item).append(" ");
        }
        return builder.toString().trim();
    }

    public static String doRemoveCaracteres(String value) {
        if (!Functions.isExists(value)) {
            return "";
        }
        return value.replaceAll("[^0-9A-Za-z]", "").trim();
    }

    private static String getTrucate(String value, int init, int end) {
        if (value == null) {
            return new String();
        }
        String result = value;
        if (result.length() >= end) {
            result = value.substring(init, end);
        }
        return result;
    }

    public static String getTruncateRigthToLeft(String value, int length) {
        return Functions.getTrucate(value, 0, length);
    }

    public static String getTruncateLeftToRigth(String value, int length) {
        int init = value.length() - length;
        if (init < 0) {
            init *= -1;
        }
        return Functions.getTrucate(value, init, value.length());
    }

    public static String doPrintListVertical(Collection<String> lista) {
        StringBuilder result = new StringBuilder(lista.size() * 2);
        for (String item : lista) {
            result.append(item);
            result.append("\n");
        }
        return result.toString();
    }

    public static String getIPExterno() {
        URL whatismyip = null;
        try {
            whatismyip = new URL("http://checkip.amazonaws.com");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return Functions.getHttpContent(whatismyip);
    }

    public static String getHttpContent(URL url) {
        String content = new String();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            content = in.readLine();
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return content;
    }

    public static <K, V> Map<K, V> getParametros(Object[] array) {
        return MapUtils.putAll(new HashMap(), (Object[])array);
    }

    public static java.util.Date getDateBy(String dataString) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        return dateFormat.parse(dataString);
    }

    public static Double RoundTo(Double number, int casasDecimais) {
        if (casasDecimais < 0) {
            throw new ArithmeticException("As casas decimais deve ser igual ou superior a 0 (zero).");
        }
        Double numberDivider = Math.pow(10.0, casasDecimais);
        Double resultNumber = number * numberDivider;
        return (double)Math.round(resultNumber) / numberDivider;
    }

    public static java.util.Date getPlusWorkDate(int days) {
        if (days < 1) {
            return new java.util.Date();
        }
        LocalDate localDate = Instant.ofEpochMilli(new java.util.Date().getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
        int addedDays = 0;
        while (addedDays < days) {
            if ((localDate = localDate.plusDays(1L)).getDayOfWeek() == DayOfWeek.SATURDAY || localDate.getDayOfWeek() == DayOfWeek.SUNDAY) continue;
            ++addedDays;
        }
        return java.util.Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static java.util.Date getMinusWorkDate(int days) {
        if (days < 1) {
            return new java.util.Date();
        }
        LocalDate localDate = Instant.ofEpochMilli(new java.util.Date().getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
        int addedDays = 0;
        while (addedDays < days) {
            if ((localDate = localDate.minusDays(1L)).getDayOfWeek() == DayOfWeek.SATURDAY || localDate.getDayOfWeek() == DayOfWeek.SUNDAY) continue;
            ++addedDays;
        }
        return java.util.Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static java.util.Date toDate(LocalDate localDate) {
        return java.util.Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate toLocalDate(java.util.Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static String so() {
        String so = System.getProperty("os.name");
        if (so.indexOf(32) > -1) {
            so = so.substring(0, so.indexOf(32));
        }
        return so;
    }

    public static boolean isWindows() {
        return Functions.so().equalsIgnoreCase("Windows");
    }

    public static boolean isLinux() {
        return Functions.so().equalsIgnoreCase("Linux");
    }

    public static boolean isMac() {
        return Functions.so().equalsIgnoreCase("Mac");
    }

    public static File getNewFileCompressed(File file, String name, String suffix) throws IOException, DocumentException {
        File fileCompress = File.createTempFile(file.getName(), suffix);
        PdfReader reader = new PdfReader((InputStream)new FileInputStream(file));
        PdfStamper stamper = new PdfStamper(reader, (OutputStream)new FileOutputStream(fileCompress));
        int total = reader.getNumberOfPages() + 1;
        for (int i = 1; i < total; ++i) {
            reader.setPageContent(i + 1, reader.getPageContent(i + 1));
        }
        stamper.setFullCompression();
        stamper.close();
        return fileCompress;
    }

    public static int getHoursUntilTarget(int targetHour) {
        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(11);
        return hour < targetHour ? targetHour - hour : targetHour - hour + 24;
    }
}

