/*
 * Decompiled with CFR 0.152.
 */
package cronapp.reports;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReportExport {
    private static final Logger log = LoggerFactory.getLogger(ReportExport.class);
    private final String fileTarget;
    private final JasperPrint jasperPrint;

    ReportExport(String fileTarget, JasperPrint jasperPrint) {
        this.fileTarget = fileTarget;
        this.jasperPrint = jasperPrint;
    }

    public byte[] toPDF() {
        try {
            JasperExportManager.exportReportToPdfFile((JasperPrint)this.jasperPrint, (String)this.fileTarget);
        }
        catch (JRException e) {
            log.error("Problemas durante a exportacao do relatorio para o arquivo PDF.");
            throw new RuntimeException(e);
        }
        return this.getBytes();
    }

    public byte[] toXLS() {
        try {
            JRXlsExporter exporter = new JRXlsExporter();
            SimpleXlsReportConfiguration configuration = new SimpleXlsReportConfiguration();
            configuration.setOnePagePerSheet(Boolean.valueOf(false));
            configuration.setDetectCellType(Boolean.valueOf(true));
            configuration.setIgnoreCellBackground(Boolean.valueOf(true));
            configuration.setWrapText(Boolean.valueOf(false));
            configuration.setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true));
            configuration.setCollapseRowSpan(Boolean.valueOf(true));
            configuration.setAutoFitPageHeight(Boolean.valueOf(true));
            configuration.setForcePageBreaks(Boolean.valueOf(false));
            configuration.setIgnorePageMargins(Boolean.valueOf(true));
            configuration.setShowGridLines(Boolean.valueOf(true));
            configuration.setWhitePageBackground(Boolean.valueOf(false));
            SimpleExporterInput simpleExporterInput = new SimpleExporterInput(this.jasperPrint);
            SimpleOutputStreamExporterOutput simpleOutputStreamExporterOutput = new SimpleOutputStreamExporterOutput(this.fileTarget);
            exporter.setConfiguration((ReportExportConfiguration)configuration);
            exporter.setExporterInput((ExporterInput)simpleExporterInput);
            exporter.setExporterOutput((ExporterOutput)simpleOutputStreamExporterOutput);
            exporter.exportReport();
        }
        catch (JRException e) {
            log.error("Problemas durante a exportacao do relatorio para o arquivo PDF.");
            throw new RuntimeException(e);
        }
        return this.getBytes();
    }

    private byte[] getBytes() {
        Path path = Paths.get(this.fileTarget, new String[0]);
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            log.error("Problemas para obter o array de bytes do relatorio.");
            throw new RuntimeException(e);
        }
    }
}

