/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.tenant;

import cronapi.database.TenantService;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class MultitenantJpaTransactionManager
extends JpaTransactionManager {
    private static final long serialVersionUID = 1L;
    @Autowired
    private TenantService tenantService;

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        super.doBegin(transaction, definition);
        EntityManagerFactory entityManagerFactory = this.getEntityManagerFactory();
        EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource((Object)entityManagerFactory);
        EntityManager em = emHolder.getEntityManager();
        try {
            if (this.tenantService != null && this.tenantService.getContextIds() != null) {
                Set keySet = this.tenantService.getContextIds().keySet();
                for (String key : keySet) {
                    em.setProperty(key, this.tenantService.getId(key));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected EntityManager createEntityManagerForTransaction() {
        return super.createEntityManagerForTransaction();
    }
}

