/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.rest;

import cronapi.AppConfig;
import cronapi.Var;
import cronapp.framework.CannotChangePasswordException;
import cronapp.framework.api.ApiManager;
import cronapp.framework.api.EventsManager;
import cronapp.framework.api.User;
import cronapp.framework.i18n.Messages;
import cronapp.framework.persistence.InvalidConfirmationPasswordException;
import cronapp.framework.persistence.PasswordConstraintException;
import cronapp.framework.rest.AuthenticationUtil;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/changePassword"})
public class ChangePassword {
    @ResponseStatus(value=HttpStatus.OK)
    @PostMapping
    public void post(String oldPassword, String newPassword, String newPasswordConfirmation) throws Exception {
        String authenticationType = AppConfig.type();
        if (authenticationType != null && !authenticationType.equalsIgnoreCase("internal") && !authenticationType.equalsIgnoreCase("token")) {
            throw new CannotChangePasswordException(Messages.getString("CannotChangePassword"));
        }
        if (!newPassword.equals(newPasswordConfirmation)) {
            throw new InvalidConfirmationPasswordException();
        }
        String username = AuthenticationUtil.getUsername();
        if (EventsManager.hasEvent("onChangePassword")) {
            EventsManager.executeEventOnTransaction("onChangePassword", Var.valueOf((String)"username", (Object)username), Var.valueOf((String)"oldPassword", (Object)oldPassword), Var.valueOf((String)"newPassword", (Object)newPassword), Var.valueOf((String)"newPasswordConfirmation", (Object)newPasswordConfirmation));
        } else {
            ApiManager apiManager = ApiManager.byUser(username);
            User user = apiManager.getUser();
            if (user == null) {
                throw new UsernameNotFoundException(Messages.getString("UserNotFound"));
            }
            String password = user.getPassword();
            if (!apiManager.passwordMatches(oldPassword, password)) {
                throw new BadCredentialsException(Messages.getString("UserOrPassordInvalids"));
            }
            try {
                apiManager.updatePassword(newPassword);
            }
            catch (Exception e) {
                PasswordConstraintException passwordConstraintException = PasswordConstraintException.unwrap(e);
                if (passwordConstraintException != null) {
                    throw passwordConstraintException;
                }
                throw e;
            }
        }
    }
}

