/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.token;

import cronapi.AppConfig;
import cronapi.RestClient;
import cronapi.Var;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.mobile.device.Device;
import org.springframework.security.core.userdetails.UserDetails;

public class TokenUtils {
    private static String secret = AppConfig.token();
    private static final String AUDIENCE_MOBILE = "mobile";
    private static final String AUDIENCE_TABLET = "tablet";
    public static final String AUTH_HEADER_NAME = "X-AUTH-TOKEN";

    public static List<String> getAuthoritiesFromToken(String token) {
        List<String> authorities;
        try {
            Claims claims = TokenUtils.getClaimsFromToken(token);
            authorities = (List)claims.get((Object)"authorities");
        }
        catch (Exception e) {
            authorities = new ArrayList<String>();
        }
        return authorities;
    }

    public static String getUsernameFromToken(String token) {
        String username;
        try {
            Claims claims = TokenUtils.getClaimsFromToken(token);
            username = claims.getSubject();
        }
        catch (Exception e) {
            username = null;
        }
        return username;
    }

    public static String getProviderFromToken(String token) {
        String provider;
        try {
            Claims claims = TokenUtils.getClaimsFromToken(token);
            provider = claims.getIssuer();
        }
        catch (Exception e) {
            provider = null;
        }
        return provider;
    }

    private static Date getCreatedDateFromToken(String token) {
        Date created;
        try {
            Claims claims = TokenUtils.getClaimsFromToken(token);
            created = new Date((Long)claims.get((Object)"created"));
        }
        catch (Exception e) {
            created = null;
        }
        return created;
    }

    static Date getExpirationDateFromToken(String token) {
        Date expiration;
        try {
            Claims claims = TokenUtils.getClaimsFromToken(token);
            expiration = claims.getExpiration();
        }
        catch (Exception e) {
            expiration = null;
        }
        return expiration;
    }

    private static String getAudienceFromToken(String token) {
        String audience;
        try {
            Claims claims = TokenUtils.getClaimsFromToken(token);
            audience = (String)claims.get((Object)"audience");
        }
        catch (Exception e) {
            audience = null;
        }
        return audience;
    }

    public static Claims getClaimsFromToken(String token) {
        Claims claims;
        try {
            claims = (Claims)Jwts.parser().setSigningKey(secret).parseClaimsJws(token).getBody();
        }
        catch (Exception e) {
            claims = null;
        }
        return claims;
    }

    public static String getNameFromToken(String token) {
        String name;
        try {
            Claims claims = TokenUtils.getClaimsFromToken(token);
            name = (String)claims.get((Object)"name");
        }
        catch (Exception e) {
            name = null;
        }
        return name;
    }

    public static String getIssuerFromToken(String token) {
        String issuer;
        try {
            Claims claims = TokenUtils.getClaimsFromToken(token);
            issuer = (String)claims.get((Object)"iss");
        }
        catch (Exception e) {
            issuer = null;
        }
        return issuer;
    }

    public static List<String> getScopeFromToken(String token) {
        String scope;
        try {
            Claims claims = TokenUtils.getClaimsFromToken(token);
            scope = (String)claims.get((Object)"scope");
        }
        catch (Exception e) {
            scope = null;
        }
        return scope == null ? List.of() : Arrays.asList(scope.trim().split(" "));
    }

    private static Date generateCurrentDate() {
        return new Date(System.currentTimeMillis());
    }

    public static Date generateExpirationDate() {
        Long expiration = AppConfig.tokenExpiration();
        return new Date(System.currentTimeMillis() + expiration * 1000L);
    }

    public static boolean isTokenExpired(String token) {
        Date expiration = TokenUtils.getExpirationDateFromToken(token);
        return expiration.before(TokenUtils.generateCurrentDate());
    }

    private static boolean isCreatedBeforeLastPasswordReset(Date created, Date lastPasswordReset) {
        return lastPasswordReset != null && created.before(lastPasswordReset);
    }

    private static String generateAudience(Device device) {
        String audience = "unknown";
        if (device.isNormal()) {
            audience = "web";
        } else if (device.isTablet()) {
            audience = AUDIENCE_TABLET;
        } else if (device.isMobile()) {
            audience = AUDIENCE_MOBILE;
        }
        return audience;
    }

    private static boolean ignoreTokenExpiration(String token) {
        String audience = TokenUtils.getAudienceFromToken(token);
        return AUDIENCE_TABLET.equals(audience) || AUDIENCE_MOBILE.equals(audience);
    }

    static String generateToken(UserDetails userDetails, Device device) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("sub", userDetails.getUsername());
        claims.put("audience", TokenUtils.generateAudience(device));
        claims.put("created", TokenUtils.generateCurrentDate());
        claims.put("iss", "local");
        return TokenUtils.generateToken(claims, null);
    }

    static String generateToken(UserDetails userDetails, Device device, String provider) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("sub", userDetails.getUsername());
        claims.put("audience", TokenUtils.generateAudience(device));
        claims.put("created", TokenUtils.generateCurrentDate());
        claims.put("iss", provider);
        return TokenUtils.generateToken(claims, null);
    }

    public static String generateToken(UserDetails userDetails, String name, Device device, String provider) {
        String oldToken;
        LinkedHashMap<String, Object> extraClaims = new LinkedHashMap<String, Object>();
        Enumeration names = RestClient.getRestClient().getRequest().getAttributeNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String attrName = (String)names.nextElement();
                if (attrName == null || !attrName.startsWith("CronappToken:")) continue;
                extraClaims.put(attrName.replace("CronappToken:", ""), Var.valueOf((Object)RestClient.getRestClient().getRequest().getAttribute(attrName)).getObject());
            }
        }
        Date expires = null;
        if (RestClient.getRestClient().getRequest().getAttribute("CronappTokenExpiration") != null) {
            expires = ((Calendar)RestClient.getRestClient().getRequest().getAttribute("CronappTokenExpiration")).getTime();
        }
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("sub", userDetails.getUsername());
        claims.put("audience", TokenUtils.generateAudience(device));
        claims.put("created", TokenUtils.generateCurrentDate());
        claims.put("iss", provider);
        claims.put("name", name);
        claims.put("authorities", userDetails.getAuthorities().stream().map(authority -> authority.getAuthority()).collect(Collectors.toList()));
        if (extraClaims != null) {
            claims.putAll(extraClaims);
        }
        if (StringUtils.isNotBlank((String)(oldToken = RestClient.getRestClient().getToken()))) {
            Claims oldClaims = TokenUtils.getClaimsFromToken(oldToken);
            oldClaims.forEach(claims::putIfAbsent);
        }
        return TokenUtils.generateToken(claims, expires);
    }

    public static String generateToken(Map<String, Object> claims, Date expires) {
        return Jwts.builder().setClaims(claims).setExpiration(expires == null ? TokenUtils.generateExpirationDate() : expires).signWith(SignatureAlgorithm.HS512, secret).compact();
    }

    static boolean canTokenBeRefreshed(String token, Date lastPasswordReset) {
        Date created = TokenUtils.getCreatedDateFromToken(token);
        return TokenUtils.isCreatedBeforeLastPasswordReset(created, lastPasswordReset) && (!TokenUtils.isTokenExpired(token) || TokenUtils.ignoreTokenExpiration(token));
    }

    static String refreshToken(String token) {
        String refreshedToken;
        try {
            Claims claims = TokenUtils.getClaimsFromToken(token);
            claims.put((Object)"created", (Object)TokenUtils.generateCurrentDate());
            refreshedToken = TokenUtils.generateToken((Map<String, Object>)claims, null);
        }
        catch (Exception e) {
            refreshedToken = null;
        }
        return refreshedToken;
    }
}

