/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.rest;

import cronapi.Var;
import cronapp.framework.api.ApiManager;
import cronapp.framework.api.EventsManager;
import cronapp.framework.api.User;
import cronapp.framework.i18n.Messages;
import cronapp.framework.rest.AuthenticationUtil;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/changeTheme"})
public class ChangeTheme {
    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(method={RequestMethod.POST})
    public void post(String theme) throws Exception {
        String username = AuthenticationUtil.getUsername();
        if (EventsManager.hasEvent("onChangeTheme")) {
            EventsManager.executeEventOnTransaction("onChangeTheme", Var.valueOf((String)"username", (Object)username), Var.valueOf((String)"theme", (Object)theme));
        } else {
            ApiManager apiManager = ApiManager.byUser(username);
            User user = apiManager.getUser();
            if (user == null) {
                throw new UsernameNotFoundException(Messages.getString("UserNotFound"));
            }
            apiManager.updateTheme(theme);
        }
    }
}

