/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.sso;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import cronapi.ErrorResponse;
import cronapi.RestClient;
import cronapp.framework.authentication.security.CronappUserDetails;
import cronapp.framework.authentication.sso.SsoSecurityConfigurer;
import cronapp.framework.authentication.token.AuthenticationController;
import cronapp.framework.authentication.token.AuthenticationResponse;
import cronapp.framework.i18n.Messages;
import cronapp.framework.tenant.TenantComponent;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.mobile.device.LiteDeviceResolver;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"auth"})
public class SSORESTController {
    private static final Logger log = LoggerFactory.getLogger(SSORESTController.class);
    private AuthenticationController authenticationController;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private UserInfoTokenServices tokenServices;
    @Autowired
    private Environment env;

    public SSORESTController(@Nullable TenantComponent tenantComponent) {
        this.authenticationController = new AuthenticationController(tenantComponent);
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseBody
    ResponseEntity<ErrorResponse> handleControllerException(HttpServletRequest req, Throwable ex) {
        log.error(ex.getMessage(), ex);
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR.value(), ex, req.getMethod());
        return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @RequestMapping(value={"sso"}, method={RequestMethod.POST})
    public ResponseEntity<AuthenticationResponse> authenticationSSORequest(@RequestParam(name="client_id") String client_id, @RequestParam(name="client_secret") String client_secret, @RequestParam(name="access_token") String access_token, HttpServletRequest request) throws AuthenticationException {
        if (!this.env.getProperty("security.oauth2.client.clientId").equals(client_id) || !this.env.getProperty("security.oauth2.client.clientSecret").equals(client_secret)) {
            throw new AuthenticationServiceException(Messages.getString("AuthError", "Not Authorized"));
        }
        OAuth2Authentication authentication = this.tokenServices.loadAuthentication(access_token);
        UsernamePasswordAuthenticationToken userAuthentication = (UsernamePasswordAuthenticationToken)authentication.getUserAuthentication();
        CronappUserDetails externalUserDetails = SsoSecurityConfigurer.getCronappUserDetails(userAuthentication);
        Gson gson = new Gson();
        JsonObject json = (JsonObject)gson.toJsonTree((Object)externalUserDetails);
        ObjectMapper mapper = new ObjectMapper();
        Map details = (Map)mapper.convertValue((Object)externalUserDetails, Map.class);
        LiteDeviceResolver deviceResolver = new LiteDeviceResolver();
        AuthenticationController authenticationController = new AuthenticationController(null);
        RestClient.getRestClient().getRequest().setAttribute("CronappToken:SSOAccessToken", (Object)access_token);
        RestClient.getRestClient().getRequest().setAttribute("CronappToken:SSOUserDetails", (Object)details);
        return authenticationController.auth(externalUserDetails.getEmail(), "cronapp", deviceResolver.resolveDevice(request), "SSO", null, json, request);
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<AuthenticationResponse> authenticationRequest(@RequestParam String username, String password, @RequestHeader(name="X-AUTH-TOKEN", required=false) String token, HttpServletRequest request) throws AuthenticationException {
        LiteDeviceResolver deviceResolver = new LiteDeviceResolver();
        return this.authenticationController.auth(username, password, deviceResolver.resolveDevice(request), "local", token, null, request);
    }

    @RequestMapping(value={"refresh"}, method={RequestMethod.GET})
    public ResponseEntity<?> authenticationRequest(HttpServletRequest request) {
        return this.authenticationController.authenticationRequest(request);
    }

    @RequestMapping(value={"/signin/sso"}, method={RequestMethod.GET})
    @ResponseBody
    public String forwardLoginSSO(@RequestParam(name="_ctk") String _ctk, HttpServletRequest request) {
        String forwardPage = "<!DOCTYPE html><html><head>    <meta charset='UTF-8'>    <meta http-equiv='Content-Security-Policy' content=\"default-src * cronapp://*; connect-src * cronapp:;script-src 'unsafe-inline';\"></head><body>    <script>       try {          let data = {'type': 'sso_user', '_ctk': '" + _ctk + "' };          let parentWindow = window.opener;          parentWindow.postMessage(data, location.href);        } catch(error) {          console.error(error);        }        window.location.assign('" + request.getContextPath() + "/#/connected?_ctk=" + _ctk + "');      </script></body></html>";
        return forwardPage;
    }
}

