package cronapp.framework.persistence;

import cronapp.framework.i18n.Messages;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value = HttpStatus.BAD_REQUEST)
public class InvalidConfirmationPasswordException extends RuntimeException {
  public InvalidConfirmationPasswordException() {
    super(Messages.getString("WrongConfirmationPassword"));
  }

  public InvalidConfirmationPasswordException(Throwable cause) {
    super(Messages.getString("WrongConfirmationPassword"), cause);
  }
}
