package cronapp.framework.jpa;

import cronapi.Var;
import cronapp.framework.CronappMetadataSource;
import cronapp.framework.api.EventsManager;
import org.eclipse.persistence.config.PersistenceUnitProperties;
import org.eclipse.persistence.internal.jpa.deployment.JavaSECMPInitializer;

import javax.persistence.spi.PersistenceUnitInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class CronappJPAInitializer extends JavaSECMPInitializer {
    protected CronappJPAInitializer(ClassLoader loader) {
        super(loader);
    }

    @Override
    public String createUniquePersistenceUnitName(PersistenceUnitInfo puInfo) {
        String fullPuName = super.createUniquePersistenceUnitName(puInfo);
        if (puInfo.getProperties().containsKey(PersistenceUnitProperties.METADATA_SOURCE)) {
            String metadataSource = puInfo.getProperties().getProperty(PersistenceUnitProperties.METADATA_SOURCE);
            if (metadataSource.equals(CronappMetadataSource.class.getName())) {
                Map<String, Object> properties = new HashMap<>();
                Properties puInfoPropeties = puInfo.getProperties();

                for (Map.Entry<Object, Object> entry : puInfoPropeties.entrySet()) {
                    properties.put(entry.getKey().toString(), entry.getValue());
                }

                Map<String, Object> propertyOverrides = getPropertyOverrides(properties);

                return fullPuName.concat("#").concat(String.valueOf(propertyOverrides.hashCode()));
            }
        }

        return fullPuName;
    }

    @Override
    public boolean isPersistenceProviderSupported(String providerClassName) {
        return super.isPersistenceProviderSupported(providerClassName)
                || providerClassName.equals(CronappPersistenceProvider.class.getName());
    }

    public static Map<String, Object> getPropertyOverrides(Map<String, Object> properties) {
        if (!EventsManager.hasEvent("onConfigureConnection")) {
            return properties;
        }
        Var configuration = EventsManager.executeEventOnTransaction(
                "onConfigureConnection",
                Var.valueOf("connection", properties.get("cronapp.diagram.namespace"))
        );

        if (configuration.isString()) {
            properties.put(PersistenceUnitProperties.NON_JTA_DATASOURCE, configuration.toString());
        } else {
            properties.put(PersistenceUnitProperties.JDBC_DRIVER, configuration.get("driver"));
            properties.put(PersistenceUnitProperties.JDBC_URL, configuration.get("url"));
            properties.put(PersistenceUnitProperties.JDBC_USER, configuration.get("user"));
            properties.put(PersistenceUnitProperties.JDBC_PASSWORD, configuration.get("password"));
            properties.put(PersistenceUnitProperties.NON_JTA_DATASOURCE, "");
        }

        return properties;
    }
}
