package cronapp.framework.authentication.token;

import cronapp.framework.api.ApiManager;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.Set;

@Service
public class CustomUserDetailsService implements UserDetailsService {
  
  @Override
  public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
    ApiManager apiManager = ApiManager.byUser(username);
    Set<GrantedAuthority> authorities = apiManager.getAuthorities();
    return new org.springframework.security.core.userdetails.User(username, "password", true, true, true, true, authorities);
  }
  
}
