package cronapp.framework.authentication;

import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

import java.util.LinkedList;
import java.util.List;

public class AuthenticationUtil {
  public static List<String> PUBLIC_PATTERNS = new LinkedList<>();
  public static final String ENCRYPT = "$2a$10$";

  static {
    PUBLIC_PATTERNS.add("/");
    PUBLIC_PATTERNS.add("/node_modules/**");
  }

  public static void loadStaticSecurity(HttpSecurity httpSecurity) {
    AuthenticationUtil.PUBLIC_PATTERNS.stream().forEach(p -> {
      try {
        httpSecurity.authorizeRequests().antMatchers(p).permitAll();
      } catch (Throwable e) {
        throw new RuntimeException(e);
      }
    });
  }
}
