package cronapp.framework.persistence;

import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.stream.Collectors;

@ResponseStatus(value = HttpStatus.BAD_REQUEST)
public class PasswordConstraintException extends RuntimeException {

  public PasswordConstraintException() {
  }

  public PasswordConstraintException(String message) {
    super(message);
  }

  public PasswordConstraintException(String message, Throwable cause) {
    super(message, cause);
  }

  public PasswordConstraintException(Throwable cause) {
    super(cause);
  }

  public static PasswordConstraintException unwrap(Exception exception) {
    ConstraintViolationException constraintViolationException = null;
    Throwable currentThrowable = exception;

    while (currentThrowable != null) {
      if (currentThrowable instanceof ConstraintViolationException) {
        constraintViolationException = (ConstraintViolationException) currentThrowable;
        break;
      }

      currentThrowable = currentThrowable.getCause();
    }

    if (constraintViolationException != null) {
      String message = constraintViolationException.getConstraintViolations().stream()
          .filter(constraintViolation -> constraintViolation.getConstraintDescriptor().getConstraintValidatorClasses().contains(PasswordConstraintValidator.class))
          .map(ConstraintViolation::getMessage)
          .collect(Collectors.joining("\n"));

      if (StringUtils.isNotBlank(message)) {
        return new PasswordConstraintException(message, exception);
      }
    }

    return null;
  }
}
