package cronapp.framework.persistence;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

@Constraint(validatedBy = PasswordConstraintValidator.class)
@Target(TYPE)
@Retention(RUNTIME)
@Repeatable(ValidPasswords.class)
public @interface ValidPassword {
  String message() default "Invalid Password";

  Class<?>[] groups() default {};

  Class<? extends Payload>[] payload() default {};

  String passwordProperty();

  String passwordHistoryProperty();
}
